/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm5.requests;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5Operations;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5SearchParameters;
import org.projecthusky.communication.ch.camel.chpharm5.ChPharm5Operations;

public class ChPharm5FindMedicationCardSearchParameters
extends Pharm5SearchParameters {
    public static final String INCLUDE_NON_ACTIVE_PARAM_NAME = "includenonactive";
    public static final String PAPER_FORMAT_PARAM_NAME = "paperformat";
    private @Nullable TokenOrListParam language;
    private @Nullable TokenParam includeNonActive;
    private @Nullable TokenParam paperFormat;

    public ChPharm5FindMedicationCardSearchParameters(TokenParam patientIdentifier, DateRangeParam date, StringParam authorFamilyName, StringParam authorGivenName, TokenParam identifier, TokenOrListParam status, TokenOrListParam setting, DateRangeParam period, TokenOrListParam facility, TokenOrListParam event, TokenOrListParam securityLabel, TokenOrListParam format, TokenOrListParam language, TokenParam includeNonActive, TokenParam paperFormat, SortSpec sortSpec, Set<Include> includeSpec, FhirContext fhirContext) {
        super(patientIdentifier, date, authorFamilyName, authorGivenName, identifier, status, setting, period, facility, event, securityLabel, format, null, sortSpec, includeSpec, fhirContext);
        this.language = language;
        this.includeNonActive = includeNonActive;
        this.paperFormat = paperFormat;
    }

    @Deprecated
    public Pharm5Operations getOperation() {
        throw new UnsupportedOperationException("ChPharm5SearchParameters#getOperation is not supported, use getChPharm5Operation instead.");
    }

    public ChPharm5Operations getChPharm5Operation() {
        return ChPharm5Operations.FIND_MEDICATION_CARD;
    }

    public Parameters toParameters() {
        Parameters params = super.toParameters();
        if (this.language != null) {
            params.addParameter("language", (Type)new StringType(this.language.getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.getFhirContext())).collect(Collectors.joining(","))));
        }
        if (this.includeNonActive != null) {
            params.addParameter(INCLUDE_NON_ACTIVE_PARAM_NAME, (Type)new BooleanType(this.includeNonActive.getValueAsQueryToken(this.getFhirContext())));
        }
        if (this.paperFormat != null) {
            params.addParameter(PAPER_FORMAT_PARAM_NAME, (Type)new StringType(this.paperFormat.getValueAsQueryToken(this.getFhirContext())));
        }
        return params;
    }

    public static ChPharm5FindMedicationCardSearchParametersBuilder chPharm5Builder() {
        return new ChPharm5FindMedicationCardSearchParametersBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChPharm5FindMedicationCardSearchParameters)) {
            return false;
        }
        ChPharm5FindMedicationCardSearchParameters other = (ChPharm5FindMedicationCardSearchParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenOrListParam this$language = this.getLanguage();
        TokenOrListParam other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        TokenParam this$includeNonActive = this.getIncludeNonActive();
        TokenParam other$includeNonActive = other.getIncludeNonActive();
        if (this$includeNonActive == null ? other$includeNonActive != null : !this$includeNonActive.equals(other$includeNonActive)) {
            return false;
        }
        TokenParam this$paperFormat = this.getPaperFormat();
        TokenParam other$paperFormat = other.getPaperFormat();
        return !(this$paperFormat == null ? other$paperFormat != null : !this$paperFormat.equals(other$paperFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChPharm5FindMedicationCardSearchParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TokenOrListParam $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        TokenParam $includeNonActive = this.getIncludeNonActive();
        result = result * 59 + ($includeNonActive == null ? 43 : $includeNonActive.hashCode());
        TokenParam $paperFormat = this.getPaperFormat();
        result = result * 59 + ($paperFormat == null ? 43 : $paperFormat.hashCode());
        return result;
    }

    public String toString() {
        return "ChPharm5FindMedicationCardSearchParameters(language=" + String.valueOf(this.getLanguage()) + ", includeNonActive=" + String.valueOf(this.getIncludeNonActive()) + ", paperFormat=" + String.valueOf(this.getPaperFormat()) + ")";
    }

    public @Nullable TokenOrListParam getLanguage() {
        return this.language;
    }

    public @Nullable TokenParam getIncludeNonActive() {
        return this.includeNonActive;
    }

    public @Nullable TokenParam getPaperFormat() {
        return this.paperFormat;
    }

    public void setLanguage(@Nullable TokenOrListParam language) {
        this.language = language;
    }

    public void setIncludeNonActive(@Nullable TokenParam includeNonActive) {
        this.includeNonActive = includeNonActive;
    }

    public void setPaperFormat(@Nullable TokenParam paperFormat) {
        this.paperFormat = paperFormat;
    }

    public static class ChPharm5FindMedicationCardSearchParametersBuilder {
        private TokenParam patientIdentifier;
        private DateRangeParam date;
        private StringParam authorFamilyName;
        private StringParam authorGivenName;
        private TokenParam identifier;
        private TokenOrListParam status;
        private TokenOrListParam setting;
        private DateRangeParam period;
        private TokenOrListParam facility;
        private TokenOrListParam event;
        private TokenOrListParam securityLabel;
        private TokenOrListParam format;
        private TokenOrListParam language;
        private TokenParam includeNonActive;
        private TokenParam paperFormat;
        private SortSpec sortSpec;
        private Set<Include> includeSpec;
        private FhirContext fhirContext;

        ChPharm5FindMedicationCardSearchParametersBuilder() {
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder patientIdentifier(TokenParam patientIdentifier) {
            this.patientIdentifier = patientIdentifier;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder date(DateRangeParam date) {
            this.date = date;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder authorFamilyName(StringParam authorFamilyName) {
            this.authorFamilyName = authorFamilyName;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder authorGivenName(StringParam authorGivenName) {
            this.authorGivenName = authorGivenName;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder identifier(TokenParam identifier) {
            this.identifier = identifier;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder status(TokenOrListParam status) {
            this.status = status;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder setting(TokenOrListParam setting) {
            this.setting = setting;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder period(DateRangeParam period) {
            this.period = period;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder facility(TokenOrListParam facility) {
            this.facility = facility;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder event(TokenOrListParam event) {
            this.event = event;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder securityLabel(TokenOrListParam securityLabel) {
            this.securityLabel = securityLabel;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder format(TokenOrListParam format) {
            this.format = format;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder language(TokenOrListParam language) {
            this.language = language;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder includeNonActive(TokenParam includeNonActive) {
            this.includeNonActive = includeNonActive;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder paperFormat(TokenParam paperFormat) {
            this.paperFormat = paperFormat;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder sortSpec(SortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder includeSpec(Set<Include> includeSpec) {
            this.includeSpec = includeSpec;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParametersBuilder fhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
            return this;
        }

        public ChPharm5FindMedicationCardSearchParameters build() {
            return new ChPharm5FindMedicationCardSearchParameters(this.patientIdentifier, this.date, this.authorFamilyName, this.authorGivenName, this.identifier, this.status, this.setting, this.period, this.facility, this.event, this.securityLabel, this.format, this.language, this.includeNonActive, this.paperFormat, this.sortSpec, this.includeSpec, this.fhirContext);
        }

        public String toString() {
            return "ChPharm5FindMedicationCardSearchParameters.ChPharm5FindMedicationCardSearchParametersBuilder(patientIdentifier=" + String.valueOf(this.patientIdentifier) + ", date=" + String.valueOf(this.date) + ", authorFamilyName=" + String.valueOf(this.authorFamilyName) + ", authorGivenName=" + String.valueOf(this.authorGivenName) + ", identifier=" + String.valueOf(this.identifier) + ", status=" + String.valueOf(this.status) + ", setting=" + String.valueOf(this.setting) + ", period=" + String.valueOf(this.period) + ", facility=" + String.valueOf(this.facility) + ", event=" + String.valueOf(this.event) + ", securityLabel=" + String.valueOf(this.securityLabel) + ", format=" + String.valueOf(this.format) + ", language=" + String.valueOf(this.language) + ", includeNonActive=" + String.valueOf(this.includeNonActive) + ", paperFormat=" + String.valueOf(this.paperFormat) + ", sortSpec=" + String.valueOf(this.sortSpec) + ", includeSpec=" + String.valueOf(this.includeSpec) + ", fhirContext=" + String.valueOf(this.fhirContext) + ")";
        }
    }
}

