/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm5;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5Operations;

public enum ChPharm5Operations {
    FIND_MEDICATION_TREATMENT_PLANS("$find-medication-treatment-plans"),
    FIND_PRESCRIPTIONS("$find-prescriptions"),
    FIND_DISPENSES("$find-dispenses"),
    FIND_MEDICATION_ADMINISTRATIONS("$find-medication-administrations"),
    FIND_PRESCRIPTIONS_FOR_VALIDATION("$find-prescriptions-for-validation"),
    FIND_PRESCRIPTIONS_FOR_DISPENSE("$find-prescriptions-for-dispense"),
    FIND_MEDICATION_LIST("$find-medication-list"),
    FIND_MEDICATION_CARD("$find-medication-card");

    private final String operation;

    private ChPharm5Operations(String operation) {
        this.operation = Objects.requireNonNull(operation);
    }

    public String getOperation() {
        return this.operation;
    }

    public static ChPharm5Operations fromPharm5Operation(Pharm5Operations pharm5Operation) {
        return switch (pharm5Operation) {
            default -> throw new IncompatibleClassChangeError();
            case Pharm5Operations.FIND_MEDICATION_TREATMENT_PLANS -> FIND_MEDICATION_TREATMENT_PLANS;
            case Pharm5Operations.FIND_PRESCRIPTIONS -> FIND_PRESCRIPTIONS;
            case Pharm5Operations.FIND_DISPENSES -> FIND_DISPENSES;
            case Pharm5Operations.FIND_MEDICATION_ADMINISTRATIONS -> FIND_MEDICATION_ADMINISTRATIONS;
            case Pharm5Operations.FIND_PRESCRIPTIONS_FOR_VALIDATION -> FIND_PRESCRIPTIONS_FOR_VALIDATION;
            case Pharm5Operations.FIND_PRESCRIPTIONS_FOR_DISPENSE -> FIND_PRESCRIPTIONS_FOR_DISPENSE;
            case Pharm5Operations.FIND_MEDICATION_LIST -> FIND_MEDICATION_LIST;
        };
    }

    public static @Nullable ChPharm5Operations fromOperation(String operation) {
        if (operation == null || ((String)operation).isBlank()) {
            return null;
        }
        if (!((String)operation).startsWith("$")) {
            operation = "$" + (String)operation;
        }
        for (ChPharm5Operations chPharm5Operation : ChPharm5Operations.values()) {
            if (!chPharm5Operation.getOperation().equals(operation)) continue;
            return chPharm5Operation;
        }
        return null;
    }

    public @Nullable Pharm5Operations toPharm5Operation() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FIND_MEDICATION_TREATMENT_PLANS -> Pharm5Operations.FIND_MEDICATION_TREATMENT_PLANS;
            case FIND_PRESCRIPTIONS -> Pharm5Operations.FIND_PRESCRIPTIONS;
            case FIND_DISPENSES -> Pharm5Operations.FIND_DISPENSES;
            case FIND_MEDICATION_ADMINISTRATIONS -> Pharm5Operations.FIND_MEDICATION_ADMINISTRATIONS;
            case FIND_PRESCRIPTIONS_FOR_VALIDATION -> Pharm5Operations.FIND_PRESCRIPTIONS_FOR_VALIDATION;
            case FIND_PRESCRIPTIONS_FOR_DISPENSE -> Pharm5Operations.FIND_PRESCRIPTIONS_FOR_DISPENSE;
            case FIND_MEDICATION_LIST -> Pharm5Operations.FIND_MEDICATION_LIST;
            case FIND_MEDICATION_CARD -> null;
        };
    }
}

