/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm5;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Parameters;
import org.openehealth.ipf.commons.ihe.fhir.ClientRequestFactory;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5SearchParameters;
import org.projecthusky.communication.ch.camel.chpharm5.requests.ChPharm5FindMedicationCardSearchParameters;

public class ChPharm5ClientRequestFactory
implements ClientRequestFactory<IOperationUntypedWithInput<Bundle>> {
    public IClientExecutable<IOperationUntypedWithInput<Bundle>, ?> getClientExecutable(IGenericClient client, Object requestData, Map<String, Object> parametersMap) {
        String operation;
        Parameters parameters;
        Objects.requireNonNull(client, "client shall not be null in ChPharm5ClientRequestFactory");
        Objects.requireNonNull(requestData, "requestData shall not be null in ChPharm5ClientRequestFactory");
        Objects.requireNonNull(parametersMap, "parametersMap shall not be null in ChPharm5ClientRequestFactory");
        if (requestData instanceof Parameters) {
            Parameters p2;
            parameters = p2 = (Parameters)requestData;
            operation = Optional.ofNullable(p2.getUserString("operation")).orElseThrow(() -> new IllegalArgumentException("The Parameters 'requestData' doesn't contain the operation name"));
        } else if (requestData instanceof ChPharm5FindMedicationCardSearchParameters) {
            ChPharm5FindMedicationCardSearchParameters searchParameters = (ChPharm5FindMedicationCardSearchParameters)((Object)requestData);
            parameters = searchParameters.toParameters();
            operation = searchParameters.getChPharm5Operation().getOperation();
        } else if (requestData instanceof Pharm5SearchParameters) {
            Pharm5SearchParameters searchParameters = (Pharm5SearchParameters)requestData;
            parameters = searchParameters.toParameters();
            operation = searchParameters.getOperation().getOperation();
        } else {
            throw new IllegalArgumentException(String.format("The argument 'requestData' is not supported (expected Parameters or Pharm5SearchParameters, got '%s')", requestData.getClass().getName()));
        }
        return this.getClientExecutable(client, parameters, operation);
    }

    IOperationUntypedWithInput<Bundle> getClientExecutable(IGenericClient client, Parameters parameters, String operation) {
        return ((IOperationUnnamed)client.operation().onType(DocumentReference.class)).named(operation).withParameters((IBaseParameters)parameters).returnResourceType(Bundle.class).useHttpGet();
    }
}

