/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm5;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.event.QueryInformationBuilder;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirQueryAuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirQueryAuditStrategy;
import org.openehealth.ipf.commons.ihe.fhir.audit.codes.FhirEventTypeCode;
import org.openehealth.ipf.commons.ihe.fhir.audit.codes.FhirParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5SearchParameters;

public class ChPharm5AuditStrategy
extends FhirQueryAuditStrategy {
    public ChPharm5AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, FhirQueryAuditDataset auditDataset) {
        String operation = "unknown";
        String endpointUrl = auditDataset.getDestinationUserId();
        if (endpointUrl != null && endpointUrl.lastIndexOf("$") >= 0) {
            operation = endpointUrl.substring(endpointUrl.lastIndexOf("$"));
        }
        return new QueryInformationBuilder(auditContext, (AuditDataset)auditDataset, (EventType)FhirEventTypeCode.QueryPharmacyDocumentsOverMhd, new PurposeOfUse[0]).addPatients((Collection)auditDataset.getPatientIds()).setQueryParameters(operation, (ParticipantObjectIdType)FhirParticipantObjectIdTypeCode.QueryPharmacyDocumentsOverMhd, auditDataset.getQueryString(), ParticipantObjectTypeCode.System, ParticipantObjectTypeCodeRole.Query, List.of(new TypeValuePairType("QueryEncoding", "UTF-8"))).getMessages();
    }

    public FhirQueryAuditDataset enrichAuditDatasetFromRequest(FhirQueryAuditDataset auditDataset, Object request, Map<String, Object> parameters) {
        Parameters bodyParameters;
        List patientIdentifier;
        FhirQueryAuditDataset dataset = super.enrichAuditDatasetFromRequest(auditDataset, request, parameters);
        BiConsumer<String, String> addPatientId = (value, system) -> {
            system = system.startsWith("urn:oid:") ? system.substring(8) : system;
            dataset.getPatientIds().add(String.format("%s^^^&%s&ISO", value, system));
        };
        Pharm5SearchParameters searchParameters = (Pharm5SearchParameters)parameters.get("FhirRequestParameters");
        if (searchParameters != null) {
            List tokenParams = searchParameters.getPatientIdParam();
            if (tokenParams != null) {
                tokenParams.forEach(t -> addPatientId.accept(t.getValue(), t.getSystem()));
            }
        } else if (request instanceof Parameters && (patientIdentifier = (bodyParameters = (Parameters)request).getParameterValues("patient.identifier")) instanceof StringType) {
            String[] parts = ((String)((StringType)patientIdentifier).getValue()).split("\\|");
            addPatientId.accept(parts[1], parts[0]);
        }
        if (parameters.containsKey("FhirHttpQuery")) {
            dataset.setQueryString(URLDecoder.decode((String)parameters.get("FhirHttpQuery"), StandardCharsets.UTF_8));
        }
        if (parameters.containsKey("FhirHttpUrl")) {
            dataset.setServiceEndpointUrl(URLDecoder.decode((String)parameters.get("FhirHttpUrl"), StandardCharsets.UTF_8));
        }
        return dataset;
    }

    public FhirQueryAuditDataset createAuditDataset() {
        return new FhirQueryAuditDataset(this.isServerSide());
    }
}

