/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm1.validate.requests.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryReturnType;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.CXValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.NopValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotLengthAndNameUniquenessValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.ChoiceValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.CodeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.DocumentEntryTypeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StatusValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StringListValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StringValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.TimestampValidation;
import org.projecthusky.communication.ch.camel.chpharm1.requests.query.ChPharm1QueryType;
import org.projecthusky.communication.ch.camel.validate.CodeEnumValidation;
import org.projecthusky.communication.ch.enums.stable.FormatCode;

public class ChPharm1RequestValidator
implements Validator<EbXMLAdhocQueryRequest, ValidationProfile> {
    private static final CXValidator cxValidator = new CXValidator(true);
    private static final NopValidator nopValidator = new NopValidator();
    private static final Map<ChPharm1QueryType, Set<String>> ALLOWED_MULTIPLE_SLOTS = new EnumMap<ChPharm1QueryType, Set<String>>(ChPharm1QueryType.class);

    private static void addAllowedMultipleSlots(ChPharm1QueryType queryType, QueryParameter ... parameters) {
        Set slotNames = Arrays.stream(parameters).map(QueryParameter::getSlotName).collect(Collectors.toSet());
        ALLOWED_MULTIPLE_SLOTS.put(queryType, slotNames);
    }

    private QueryParameterValidation[] getValidators(ChPharm1QueryType queryType, ValidationProfile profile) {
        QueryParameterValidation[] queryParameterValidationArray;
        XdsIntegrationProfile.HomeCommunityIdOptionality homeCommunityIdOptionality = profile.getInteractionProfile().getHomeCommunityIdOptionality();
        switch (queryType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CH_FIND_MEDICATION_TREATMENT_PLANS: 
            case CH_FIND_PRESCRIPTIONS: 
            case CH_FIND_DISPENSES: 
            case CH_FIND_MEDICATION_ADMINISTRATIONS: 
            case CH_FIND_PRESCRIPTIONS_FOR_VALIDATION: 
            case CH_FIND_PRESCRIPTIONS_FOR_DISPENSE: {
                QueryParameterValidation[] queryParameterValidationArray2 = new QueryParameterValidation[18];
                queryParameterValidationArray2[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, (ValueValidator)cxValidator, false);
                queryParameterValidationArray2[1] = new ChoiceValidation(true, new QueryParameter[]{QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID});
                queryParameterValidationArray2[2] = new StringListValidation(QueryParameter.FOLDER_UUID, (ValueValidator)nopValidator);
                queryParameterValidationArray2[3] = new StringListValidation(QueryParameter.FOLDER_UNIQUE_ID, (ValueValidator)nopValidator);
                queryParameterValidationArray2[4] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray2[5] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM);
                queryParameterValidationArray2[6] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO);
                queryParameterValidationArray2[7] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM);
                queryParameterValidationArray2[8] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO);
                queryParameterValidationArray2[9] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM);
                queryParameterValidationArray2[10] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO);
                queryParameterValidationArray2[11] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray2[12] = new CodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE);
                queryParameterValidationArray2[13] = new CodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
                queryParameterValidationArray2[14] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, (ValueValidator)nopValidator);
                queryParameterValidationArray2[15] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray2[16] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray = queryParameterValidationArray2;
                queryParameterValidationArray2[17] = new CodeEnumValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, true, EnumSet.of(FormatCode.CH_EMED_MEDICATION_TREATMENT_PLAN_DOCUMENT, FormatCode.CH_EMED_MEDICATION_PRESCRIPTION_DOCUMENT, FormatCode.CH_EMED_MEDICATION_DISPENSE_DOCUMENT));
                break;
            }
            case CH_FIND_MEDICATION_LIST: {
                QueryParameterValidation[] queryParameterValidationArray3 = new QueryParameterValidation[8];
                queryParameterValidationArray3[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, (ValueValidator)cxValidator, false);
                queryParameterValidationArray3[1] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_FROM);
                queryParameterValidationArray3[2] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TO);
                queryParameterValidationArray3[3] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_END_FROM);
                queryParameterValidationArray3[4] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_END_TO);
                queryParameterValidationArray3[5] = new CodeEnumValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, true, EnumSet.of(FormatCode.CH_EMED_MEDICATION_TREATMENT_PLAN_DOCUMENT, FormatCode.CH_EMED_MEDICATION_PRESCRIPTION_DOCUMENT, FormatCode.CH_EMED_MEDICATION_DISPENSE_DOCUMENT));
                queryParameterValidationArray3[6] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray = queryParameterValidationArray3;
                queryParameterValidationArray3[7] = new DocumentEntryTypeValidation();
                break;
            }
            case CH_FIND_MEDICATION_CARD: {
                QueryParameterValidation[] queryParameterValidationArray4 = new QueryParameterValidation[8];
                queryParameterValidationArray4[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, (ValueValidator)cxValidator, false);
                queryParameterValidationArray4[1] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_FROM);
                queryParameterValidationArray4[2] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TO);
                queryParameterValidationArray4[3] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_END_FROM);
                queryParameterValidationArray4[4] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_END_TO);
                queryParameterValidationArray4[5] = new CodeEnumValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, true, EnumSet.of(FormatCode.CH_EMED_MEDICATION_CARD_DOCUMENT, FormatCode.UNSTRUCTURED_EPR_DOCUMENT));
                queryParameterValidationArray4[6] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray = queryParameterValidationArray4;
                queryParameterValidationArray4[7] = new DocumentEntryTypeValidation();
            }
        }
        return queryParameterValidationArray;
    }

    public void validate(EbXMLAdhocQueryRequest request, ValidationProfile profile) {
        Objects.requireNonNull(request, "request shall not be null in validate()");
        Objects.requireNonNull(profile, "profile shall not be null in validate()");
        ValidatorAssertions.metaDataAssert((QueryReturnType.LEAF_CLASS.getCode().equals(request.getReturnType()) || QueryReturnType.OBJECT_REF.getCode().equals(request.getReturnType()) ? 1 : 0) != 0, (ValidationMessage)ValidationMessage.UNKNOWN_RETURN_TYPE, (Object[])new Object[]{request.getReturnType()});
        ChPharm1QueryType queryType = ChPharm1QueryType.valueOfId(request.getId());
        ValidatorAssertions.metaDataAssert((queryType != null ? 1 : 0) != 0, (ValidationMessage)ValidationMessage.UNKNOWN_QUERY_TYPE, (Object[])new Object[]{request.getId()});
        EnumSet<ChPharm1QueryType[]> allowedQueryTypes = EnumSet.of(ChPharm1QueryType.CH_FIND_MEDICATION_TREATMENT_PLANS, new ChPharm1QueryType[]{ChPharm1QueryType.CH_FIND_PRESCRIPTIONS, ChPharm1QueryType.CH_FIND_DISPENSES, ChPharm1QueryType.CH_FIND_MEDICATION_ADMINISTRATIONS, ChPharm1QueryType.CH_FIND_PRESCRIPTIONS_FOR_VALIDATION, ChPharm1QueryType.CH_FIND_PRESCRIPTIONS_FOR_DISPENSE, ChPharm1QueryType.CH_FIND_MEDICATION_LIST, ChPharm1QueryType.CH_FIND_MEDICATION_CARD});
        ValidatorAssertions.metaDataAssert((boolean)allowedQueryTypes.contains((Object)queryType), (ValidationMessage)ValidationMessage.UNSUPPORTED_QUERY_TYPE, (Object[])new Object[]{queryType});
        SlotLengthAndNameUniquenessValidator.validateQuerySlots((List)request.getSlots(), ALLOWED_MULTIPLE_SLOTS.getOrDefault((Object)queryType, Collections.emptySet()));
        for (QueryParameterValidation validation : this.getValidators(queryType, profile)) {
            validation.validate(request);
        }
    }

    static {
        ChPharm1RequestValidator.addAllowedMultipleSlots(ChPharm1QueryType.CH_FIND_MEDICATION_TREATMENT_PLANS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        ChPharm1RequestValidator.addAllowedMultipleSlots(ChPharm1QueryType.CH_FIND_PRESCRIPTIONS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        ChPharm1RequestValidator.addAllowedMultipleSlots(ChPharm1QueryType.CH_FIND_DISPENSES, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        ChPharm1RequestValidator.addAllowedMultipleSlots(ChPharm1QueryType.CH_FIND_MEDICATION_ADMINISTRATIONS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        ChPharm1RequestValidator.addAllowedMultipleSlots(ChPharm1QueryType.CH_FIND_PRESCRIPTIONS_FOR_VALIDATION, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        ChPharm1RequestValidator.addAllowedMultipleSlots(ChPharm1QueryType.CH_FIND_PRESCRIPTIONS_FOR_DISPENSE, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
    }
}

