/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm1.transform.requests.query;

import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryList;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.projecthusky.communication.ch.camel.chpharm1.requests.query.ChPharmacyDocumentsQuery;

public class ChPharmacyDocumentsQueryTransformer<T extends ChPharmacyDocumentsQuery> {
    public void toEbXML(@Nullable T query, @Nullable EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        ebXML.setId(((ChPharmacyDocumentsQuery)query).getType().getId());
        ebXML.setHome(((ChPharmacyDocumentsQuery)query).getHomeCommunityId());
        QuerySlotHelper slotHelper = new QuerySlotHelper(ebXML);
        for (Map.Entry<String, QueryList<String>> entry : ((ChPharmacyDocumentsQuery)query).getExtraParameters().entrySet()) {
            slotHelper.fromStringList(entry.getKey(), entry.getValue());
        }
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromInteger(QueryParameter.METADATA_LEVEL, ((ChPharmacyDocumentsQuery)query).getMetadataLevel());
        slots.fromString(QueryParameter.DOC_ENTRY_PATIENT_ID, Hl7v2Based.render((Hl7v2Based)((ChPharmacyDocumentsQuery)query).getPatientId()));
        slots.fromStatus(QueryParameter.DOC_ENTRY_STATUS, ((ChPharmacyDocumentsQuery)query).getStatus());
    }

    public void fromEbXML(@Nullable T query, @Nullable EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        ((ChPharmacyDocumentsQuery)query).setHomeCommunityId(ebXML.getHome());
        QuerySlotHelper slotHelper = new QuerySlotHelper(ebXML);
        for (EbXMLSlot slot : ebXML.getSlots()) {
            QueryList queryList;
            String slotName = slot.getName();
            if (QueryParameter.valueOfSlotName((String)slotName) != null || ((ChPharmacyDocumentsQuery)query).getExtraParameters().containsKey(slotName) || (queryList = slotHelper.toStringQueryList(slotName)) == null) continue;
            ((ChPharmacyDocumentsQuery)query).getExtraParameters().put(slotName, (QueryList<String>)queryList);
        }
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        ((ChPharmacyDocumentsQuery)query).setMetadataLevel(slots.toInteger(QueryParameter.METADATA_LEVEL));
        ((ChPharmacyDocumentsQuery)query).setPatientId((Identifiable)Hl7v2Based.parse((String)slots.toString(QueryParameter.DOC_ENTRY_PATIENT_ID), Identifiable.class));
        ((ChPharmacyDocumentsQuery)query).setStatus(slots.toStatus(QueryParameter.DOC_ENTRY_STATUS));
    }
}

