/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm1.transform.requests.query;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.projecthusky.communication.ch.camel.chpharm1.requests.query.ChFindMedicationCardQuery;
import org.projecthusky.communication.ch.camel.chpharm1.transform.requests.query.ChPharmacyDocumentsQueryTransformer;

public class ChFindMedicationCardQueryTransformer
extends ChPharmacyDocumentsQueryTransformer<ChFindMedicationCardQuery> {
    public static final String DOC_ENTRY_LANGUAGE_CODE = "$XDSDocumentEntryLanguageCode";
    public static final String PMLC_QUERY_INCLUDE_NON_ACTIVE = "$PMLCIncludeNonActive";
    public static final String PMLC_QUERY_PAPER_FORMAT = "$PMLCPaperFormat";

    @Override
    public void toEbXML(@Nullable ChFindMedicationCardQuery query, @Nullable EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromCode(QueryParameter.DOC_ENTRY_FORMAT_CODE, query.getFormatCodes());
        slots.fromDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE, query.getDocumentEntryTypes());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_FROM, query.getServiceStart().getFrom());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_TO, query.getServiceStart().getTo());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_END_FROM, query.getServiceEnd().getFrom());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_END_TO, query.getServiceEnd().getTo());
        if (query.getLanguageCode() != null) {
            ebXML.addSlot(DOC_ENTRY_LANGUAGE_CODE, new String[]{QuerySlotHelper.encodeAsString((String)query.getLanguageCode())});
        }
        if (query.getIncludeNonActive() != null) {
            ebXML.addSlot(PMLC_QUERY_INCLUDE_NON_ACTIVE, new String[]{QuerySlotHelper.encodeAsString((String)query.getIncludeNonActive().toString())});
        }
        if (query.getPaperFormat() != null) {
            ebXML.addSlot(PMLC_QUERY_PAPER_FORMAT, new String[]{QuerySlotHelper.encodeAsString((String)Hl7v2Based.render((Hl7v2Based)query.getPaperFormat()))});
        }
    }

    @Override
    public void fromEbXML(@Nullable ChFindMedicationCardQuery query, @Nullable EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        query.setFormatCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_FORMAT_CODE));
        query.setDocumentEntryTypes(slots.toDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE));
        query.getServiceStart().setFrom(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_FROM));
        query.getServiceStart().setTo(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_TO));
        query.getServiceEnd().setFrom(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_END_FROM));
        query.getServiceEnd().setTo(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_END_TO));
        query.setLanguageCode(QuerySlotHelper.decodeString((String)ebXML.getSingleSlotValue(DOC_ENTRY_LANGUAGE_CODE)));
        query.setIncludeNonActive(Boolean.valueOf(QuerySlotHelper.decodeString((String)ebXML.getSingleSlotValue(PMLC_QUERY_INCLUDE_NON_ACTIVE))));
        query.setPaperFormat((Code)Hl7v2Based.parse((String)QuerySlotHelper.decodeString((String)ebXML.getSingleSlotValue(PMLC_QUERY_PAPER_FORMAT)), Code.class));
    }
}

