/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chpharm1.transform.requests;

import java.lang.reflect.InvocationTargetException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLFactory30;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryReturnType;
import org.projecthusky.communication.ch.camel.chpharm1.requests.ChQueryRegistry;
import org.projecthusky.communication.ch.camel.chpharm1.requests.query.ChPharm1QueryType;
import org.projecthusky.communication.ch.camel.chpharm1.requests.query.ChPharmacyDocumentsQuery;
import org.projecthusky.communication.ch.camel.chpharm1.transform.requests.FromEbXMLVisitor;
import org.projecthusky.communication.ch.camel.chpharm1.transform.requests.ToEbXMLVisitor;

public class ChQueryRegistryTransformer {
    private final EbXMLFactory factory30 = new EbXMLFactory30();

    public @Nullable EbXMLAdhocQueryRequest toEbXML(@Nullable ChQueryRegistry request) {
        if (request == null) {
            return null;
        }
        ChPharmacyDocumentsQuery query = request.getQuery();
        EbXMLAdhocQueryRequest ebXML = this.createAdhocQueryRequest();
        query.accept(new ToEbXMLVisitor(ebXML));
        ebXML.setReturnType(request.getReturnType().getCode());
        return ebXML;
    }

    public @Nullable ChQueryRegistry fromEbXML(@Nullable EbXMLAdhocQueryRequest ebXML) {
        if (ebXML == null) {
            return null;
        }
        String id = ebXML.getId();
        ChPharm1QueryType queryType = ChPharm1QueryType.valueOfId(id);
        if (queryType == null) {
            return null;
        }
        ChPharmacyDocumentsQuery query = this.createQuery(queryType);
        query.accept(new FromEbXMLVisitor(ebXML));
        ChQueryRegistry queryRegistry = new ChQueryRegistry(query);
        queryRegistry.setReturnType(QueryReturnType.valueOfCode((String)ebXML.getReturnType()));
        return queryRegistry;
    }

    private ChPharmacyDocumentsQuery createQuery(ChPharm1QueryType queryType) {
        try {
            return queryType.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Invalid query class for type: " + String.valueOf((Object)queryType), e);
        }
    }

    private EbXMLAdhocQueryRequest createAdhocQueryRequest() {
        return this.factory30.createAdhocQueryRequest();
    }
}

