/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.chmhd1;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IUpdateExecutable;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.DocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.ClientRequestFactory;
import org.projecthusky.communication.ch.camel.chmhd1.ChMhd1Parameters;

public class ChMhd1ClientRequestFactory
implements ClientRequestFactory<IUpdateExecutable> {
    public IUpdateExecutable getClientExecutable(IGenericClient client, Object requestData, Map parameters) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(requestData);
        Objects.requireNonNull(parameters);
        if (requestData instanceof DocumentReference) {
            DocumentReference docRef = (DocumentReference)requestData;
            if (parameters.containsKey("FhirRequestParameters")) {
                Object v = parameters.get("FhirRequestParameters");
                if (v instanceof ChMhd1Parameters) {
                    ChMhd1Parameters chMhd1Parameters = (ChMhd1Parameters)v;
                    return client.update().resource((IBaseResource)docRef).withId((IIdType)chMhd1Parameters.getId());
                }
                throw new IllegalArgumentException("FhirRequestParameters parameter is required and should contain a ChMhd1Parameters instance.");
            }
            throw new IllegalArgumentException("FhirRequestParameters parameter is required and should contain a ChMhd1Parameters instance.");
        }
        throw new IllegalArgumentException(String.format("Unsupported request data type " + String.valueOf(requestData.getClass()), new Object[0]));
    }
}

