/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryReturnType;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.projecthusky.common.ch.AuthorCh;
import org.projecthusky.common.ch.enums.stable.AuthorRole;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.common.communication.AtnaConfig;
import org.projecthusky.common.communication.DocumentMetadata;
import org.projecthusky.common.communication.SubmissionSetMetadata;
import org.projecthusky.common.enums.DocumentDescriptor;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.communication.ConvenienceCommunication;
import org.projecthusky.communication.ch.DocumentMetadataCh;
import org.projecthusky.communication.ch.enums.AvailabilityStatus;
import org.projecthusky.communication.ch.xd.storedquery.FindDocumentsQuery;
import org.projecthusky.communication.exceptions.DocumentNotAccessibleException;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConvenienceCommunicationCh
extends ConvenienceCommunication {
    private static Logger log = LoggerFactory.getLogger(ConvenienceCommunicationCh.class);

    public ConvenienceCommunicationCh() {
    }

    public ConvenienceCommunicationCh(AffinityDomain affinityDomain) {
        super(affinityDomain);
    }

    public ConvenienceCommunicationCh(AffinityDomain affinityDomain, AtnaConfig.AtnaConfigMode atnaConfigMode, DocumentMetadata.DocumentMetadataExtractionMode documentMetadataExtractionMode, SubmissionSetMetadata.SubmissionSetMetadataExtractionMode submissionSetMetadataExtractionMode) {
        super(affinityDomain, atnaConfigMode, documentMetadataExtractionMode, submissionSetMetadataExtractionMode);
    }

    public DocumentMetadataCh addChDocument(DocumentDescriptor desc, InputStream inputStream) {
        return this.addChDocument(desc, inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMetadataCh addChDocument(DocumentDescriptor desc, InputStream inputStream, InputStream inputStream4Metadata) {
        DocumentMetadataCh retVal = null;
        if (inputStream == null) {
            try {
                throw new DocumentNotAccessibleException();
            }
            catch (DocumentNotAccessibleException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Document doc = new Document();
        Document doc4Metadata = new Document();
        doc4Metadata.setDocumentEntry(new DocumentEntry());
        InputStream unicodeStream = null;
        try {
            ByteArrayDataSource dataSource;
            if (inputStream4Metadata != null) {
                unicodeStream = this.convertNonAsciiText2Unicode(inputStream4Metadata);
                dataSource = new ByteArrayDataSource(unicodeStream, desc.getMimeType());
                doc4Metadata.setDataHandler(new DataHandler((DataSource)dataSource));
            }
            dataSource = new ByteArrayDataSource(inputStream, desc.getMimeType());
            doc.setDataHandler(new DataHandler((DataSource)dataSource));
            retVal = new DocumentMetadataCh(this.addXdsDocument(doc, desc, doc4Metadata));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (unicodeStream != null) {
                try {
                    unicodeStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (retVal != null) {
            retVal.setDocumentDescriptor(desc);
        }
        return retVal;
    }

    public DocumentMetadataCh addChDocument(DocumentDescriptor desc, String filePath) throws IOException {
        try (FileInputStream is = new FileInputStream(new File(filePath));){
            DocumentMetadataCh documentMetadataCh = this.addChDocument(desc, is);
            return documentMetadataCh;
        }
    }

    public QueryResponse queryDocumentReferencesOnly(Identificator patientId, SecurityHeaderElement security) throws Exception {
        return this.queryDocumentQuery(new FindDocumentsQuery(patientId, AvailabilityStatus.APPROVED), security, QueryReturnType.OBJECT_REF, null);
    }

    public QueryResponse queryDocuments(Identificator patientId, SecurityHeaderElement security) throws Exception {
        return this.queryDocumentQuery(new FindDocumentsQuery(patientId, AvailabilityStatus.APPROVED), security, QueryReturnType.LEAF_CLASS, null);
    }

    public Response submit(AuthorRole authorRole, SecurityHeaderElement security) throws Exception {
        SubmissionSetMetadata subSet = new SubmissionSetMetadata(this.getTxnData().getSubmissionSet());
        AuthorCh author = new AuthorCh();
        author.setRoleFunction(authorRole);
        subSet.setAuthor((Author)author);
        return this.submit(subSet, security, null);
    }
}

