/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.projecthusky.common.utils.xml.XmlFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUnmarshaller {
    private XmlUnmarshaller() {
    }

    public static <T> T unmarshallStringAsType(String xmlContent, Class<T> returnType) throws DataBindingException, ParserConfigurationException {
        return XmlUnmarshaller.unmarshallAsType(new InputSource(new StringReader(xmlContent)), returnType);
    }

    public static <T> T unmarshallFileAsType(File xmlFile, Class<T> returnType) throws DataBindingException, IOException, ParserConfigurationException {
        try (FileInputStream is = new FileInputStream(xmlFile);){
            T t = XmlUnmarshaller.unmarshallAsType(new InputSource(is), returnType);
            return t;
        }
    }

    public static <T> T unmarshallAsType(InputSource inputSource, Class<T> returnType) throws DataBindingException, ParserConfigurationException {
        try {
            Document document = XmlFactories.newSafeDocumentBuilder().parse(inputSource);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{returnType});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement root = unmarshaller.unmarshal((Node)document, returnType);
            return (T)JAXBIntrospector.getValue((Object)root);
        }
        catch (IOException | JAXBException | SAXException exception) {
            throw new DataBindingException("Error while parsing", exception);
        }
    }
}

