/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.xml;

import java.net.URL;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.xml.sax.SAXException;

public class XmlFactories {
    private XmlFactories() {
    }

    public static DocumentBuilder newSafeDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://apache.org/xml/features/xinclude", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        return factory.newDocumentBuilder();
    }

    public static Schema newSafeSchema(URL schema) throws SAXException {
        Objects.requireNonNull(schema);
        SchemaFactory schemaFactory = SchemaFactory.newDefaultInstance();
        schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        return schemaFactory.newSchema(schema);
    }

    public static XPath newSafeXpath() throws XPathFactoryConfigurationException {
        XPathFactory xpathFactory = XPathFactory.newDefaultInstance();
        xpathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return xpathFactory.newXPath();
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newDefaultInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory.newTransformer();
    }

    public static Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Objects.requireNonNull(source);
        TransformerFactory transformerFactory = TransformerFactory.newDefaultInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        return transformerFactory.newTransformer(source);
    }
}

