/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.time;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.primitive.CommonTS;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Hl7Dtm {
    private static final Map<@NonNull Precision, @NonNull DateTimeFormatter> FORMATTERS = new EnumMap<Precision, DateTimeFormatter>(Precision.class);
    private OffsetDateTime dateTime;
    private Precision precision;

    public Hl7Dtm(@NonNull OffsetDateTime dateTime, @NonNull Precision precision) {
        this.dateTime = Objects.requireNonNull(dateTime);
        this.precision = Objects.requireNonNull(precision);
    }

    public static Hl7Dtm fromHl7(@NonNull String s) {
        Precision precision;
        int len;
        int pos = Math.max(Objects.requireNonNull(s).indexOf(45), s.indexOf(43));
        int n = len = pos >= 0 ? pos : s.length();
        if (len >= 16 && len <= 19) {
            precision = Precision.FRAC_SECOND;
        } else if (len == 14) {
            precision = Precision.SECOND;
        } else if (len == 12) {
            precision = Precision.MINUTE;
        } else if (len == 10) {
            precision = Precision.HOUR;
        } else if (len == 8) {
            precision = Precision.DAY;
        } else if (len == 6) {
            precision = Precision.MONTH;
        } else if (len == 4) {
            precision = Precision.YEAR;
        } else {
            throw new IllegalArgumentException("The passed HL7 DTM is invalid");
        }
        return new Hl7Dtm(Objects.requireNonNull(Hl7Dtm.toOffsetDateTime(s)), precision);
    }

    public static Hl7Dtm now() {
        return new Hl7Dtm(OffsetDateTime.now(), Precision.SECOND);
    }

    public static OffsetDateTime toOffsetDateTime(@NonNull String s) {
        CommonTS ts;
        if (((String)s).isBlank()) {
            throw new IllegalArgumentException("The passed HL7 DTM is empty");
        }
        int pos = Math.max(((String)s).indexOf(45), ((String)s).indexOf(43));
        if (pos < 0) {
            s = (String)s + "+0000";
        }
        try {
            ts = new CommonTS((String)s);
        }
        catch (DataTypeException e) {
            throw new IllegalArgumentException("Unparsable HL7 DTM format", e);
        }
        return OffsetDateTime.of(ts.getYear(), ts.getMonth() == 0 ? 1 : ts.getMonth(), ts.getDay() == 0 ? 1 : ts.getDay(), ts.getHour(), ts.getMinute(), ts.getSecond(), (int)Math.floor(ts.getFractSecond() * 1.0E9f), ZoneOffset.ofHoursMinutes(ts.getGMTOffset() / 100, ts.getGMTOffset() % 100));
    }

    public void setDateTime(@NonNull OffsetDateTime dateTime) {
        this.dateTime = Objects.requireNonNull(dateTime);
    }

    public @NonNull OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public void setPrecision(@NonNull Precision precision) {
        this.precision = Objects.requireNonNull(precision);
    }

    public @NonNull Precision getPrecision() {
        return this.precision;
    }

    public @NonNull Instant toInstant() {
        return this.dateTime.toInstant();
    }

    public @NonNull String toHl7() {
        return FORMATTERS.get((Object)this.getPrecision()).format(this.getDateTime());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hl7Dtm timestamp = (Hl7Dtm)o;
        return Objects.equals(this.toHl7(), timestamp.toHl7());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateTime, this.precision});
    }

    public String toString() {
        return "Timestamp(dateTime=" + this.dateTime + ", precision=" + this.precision + ")";
    }

    static {
        FORMATTERS.put(Precision.YEAR, DateTimeFormatter.ofPattern("yyyy"));
        FORMATTERS.put(Precision.MONTH, DateTimeFormatter.ofPattern("yyyyMM"));
        FORMATTERS.put(Precision.DAY, DateTimeFormatter.ofPattern("yyyyMMdd"));
        FORMATTERS.put(Precision.HOUR, DateTimeFormatter.ofPattern("yyyyMMddHHxxxx"));
        FORMATTERS.put(Precision.MINUTE, DateTimeFormatter.ofPattern("yyyyMMddHHmmxxxx"));
        FORMATTERS.put(Precision.SECOND, DateTimeFormatter.ofPattern("yyyyMMddHHmmssxxxx"));
        FORMATTERS.put(Precision.FRAC_SECOND, DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSSSxxxx"));
    }

    public static enum Precision {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        FRAC_SECOND;

    }
}

