/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.GregorianCalendar;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.utils.time.Hl7Dtm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimes {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimes.class);
    private static final DateTimeFormatter HL7_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter TS_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssZ").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter TS_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.systemDefault());

    private DateTimes() {
    }

    public static @NonNull Hl7Dtm completeToEarliestInstant(@NonNull Hl7Dtm hl7Dtm) {
        if (hl7Dtm.getPrecision() == Hl7Dtm.Precision.FRAC_SECOND) {
            return hl7Dtm;
        }
        GregorianCalendar calendar = GregorianCalendar.from(ZonedDateTime.from(hl7Dtm.getDateTime()));
        switch (hl7Dtm.getPrecision()) {
            case YEAR: {
                calendar.set(2, calendar.getActualMinimum(2));
            }
            case MONTH: {
                calendar.set(5, calendar.getActualMinimum(5));
            }
            case DAY: {
                calendar.set(11, calendar.getActualMinimum(11));
            }
            case HOUR: {
                calendar.set(12, calendar.getActualMinimum(12));
            }
            case MINUTE: {
                calendar.set(13, calendar.getActualMinimum(13));
            }
            case SECOND: {
                calendar.set(14, calendar.getActualMinimum(14));
            }
        }
        return new Hl7Dtm(OffsetDateTime.ofInstant(calendar.toInstant(), hl7Dtm.getDateTime().getOffset()), Hl7Dtm.Precision.FRAC_SECOND);
    }

    public static @NonNull Hl7Dtm completeToLatestInstant(@NonNull Hl7Dtm hl7Dtm) {
        if (hl7Dtm.getPrecision() == Hl7Dtm.Precision.FRAC_SECOND) {
            return hl7Dtm;
        }
        GregorianCalendar calendar = GregorianCalendar.from(ZonedDateTime.from(hl7Dtm.getDateTime()));
        switch (hl7Dtm.getPrecision()) {
            case YEAR: {
                calendar.set(2, calendar.getActualMaximum(2));
            }
            case MONTH: {
                calendar.set(5, calendar.getActualMaximum(5));
            }
            case DAY: {
                calendar.set(11, calendar.getActualMaximum(11));
            }
            case HOUR: {
                calendar.set(12, calendar.getActualMaximum(12));
            }
            case MINUTE: {
                calendar.set(13, calendar.getActualMaximum(13));
            }
            case SECOND: {
                calendar.set(14, calendar.getActualMaximum(14));
            }
        }
        return new Hl7Dtm(OffsetDateTime.ofInstant(calendar.toInstant(), hl7Dtm.getDateTime().getOffset()), Hl7Dtm.Precision.FRAC_SECOND);
    }

    public static @NonNull Hl7Dtm completeToEarliestInstant(@NonNull Timestamp timestamp) {
        GregorianCalendar calendar = GregorianCalendar.from(ZonedDateTime.from(timestamp.getDateTime()));
        switch (timestamp.getPrecision()) {
            case YEAR: {
                calendar.set(2, calendar.getActualMinimum(2));
            }
            case MONTH: {
                calendar.set(5, calendar.getActualMinimum(5));
            }
            case DAY: {
                calendar.set(11, calendar.getActualMinimum(11));
            }
            case HOUR: {
                calendar.set(12, calendar.getActualMinimum(12));
            }
            case MINUTE: {
                calendar.set(13, calendar.getActualMinimum(13));
            }
            case SECOND: {
                calendar.set(14, calendar.getActualMinimum(14));
            }
        }
        return new Hl7Dtm(OffsetDateTime.ofInstant(calendar.toInstant(), timestamp.getDateTime().getOffset()), Hl7Dtm.Precision.FRAC_SECOND);
    }

    public static @NonNull Hl7Dtm completeToLatestInstant(@NonNull Timestamp timestamp) {
        GregorianCalendar calendar = GregorianCalendar.from(ZonedDateTime.from(timestamp.getDateTime()));
        switch (timestamp.getPrecision()) {
            case YEAR: {
                calendar.set(2, calendar.getActualMaximum(2));
            }
            case MONTH: {
                calendar.set(5, calendar.getActualMaximum(5));
            }
            case DAY: {
                calendar.set(11, calendar.getActualMaximum(11));
            }
            case HOUR: {
                calendar.set(12, calendar.getActualMaximum(12));
            }
            case MINUTE: {
                calendar.set(13, calendar.getActualMaximum(13));
            }
            case SECOND: {
                calendar.set(14, calendar.getActualMaximum(14));
            }
        }
        return new Hl7Dtm(OffsetDateTime.ofInstant(calendar.toInstant(), timestamp.getDateTime().getOffset()), Hl7Dtm.Precision.FRAC_SECOND);
    }

    public static @NonNull Instant toInstant(@NonNull Hl7Dtm timestamp) {
        return timestamp.getDateTime().toInstant();
    }

    public static @NonNull ZonedDateTime getZonedDateTime(@NonNull Instant instant) {
        return ZonedDateTime.ofInstant(instant, ZoneId.of("Europe/Zurich"));
    }

    public static @NonNull String toHl7Dtm(@NonNull Instant instant) {
        return HL7_DATETIME_FORMATTER.format(instant);
    }

    public static @NonNull TS toDatetimeTs(@NonNull TemporalAccessor temporal) {
        TS ts = new TS();
        ts.setValue(TS_DATETIME_FORMATTER.format(temporal));
        return ts;
    }

    public static @NonNull TS toDateTs(@NonNull TemporalAccessor temporal) {
        TS ts = new TS();
        ts.setValue(TS_DATE_FORMATTER.format(temporal));
        return ts;
    }

    public static @NonNull TS toDateTs(@NonNull TemporalAccessor temporal, ZoneId zone) {
        TS ts = new TS();
        ts.setValue(DateTimeFormatter.ofPattern("yyyyMMdd").withZone(zone).format(temporal));
        return ts;
    }

    public static @Nullable LocalDate toLocalDate(@NonNull TS ts) {
        if (ts.getValue() == null || ts.getValue().isBlank()) {
            return null;
        }
        try {
            return LocalDate.parse(ts.getValue(), TS_DATETIME_FORMATTER);
        }
        catch (DateTimeParseException ignored) {
            LOGGER.debug("Date {} could not be parsed", (Object)ts);
            try {
                return LocalDate.parse(ts.getValue(), TS_DATE_FORMATTER);
            }
            catch (DateTimeParseException ignored2) {
                LOGGER.debug("Date {} could not be parsed", (Object)ts);
                return null;
            }
        }
    }
}

