/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.datatypes;

import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;

public class Uuids {
    public static final String URN_PREFIX = "urn:uuid:";
    public static final Pattern PATTERN = Pattern.compile("^[0-9A-Fa-f]{8}(?:-[0-9A-Fa-f]{4}){3}-[0-9A-Fa-f]{12}$");
    public static final Pattern PATTERN_WITH_URN = Pattern.compile("^urn:uuid:[0-9A-Fa-f]{8}(?:-[0-9A-Fa-f]{4}){3}-[0-9A-Fa-f]{12}$");

    private Uuids() {
    }

    public static String normalize(String uuid) {
        Objects.requireNonNull(uuid);
        if (uuid.startsWith(URN_PREFIX)) {
            return uuid.substring(9).toLowerCase();
        }
        return uuid.toLowerCase();
    }

    public static String generate() {
        return UUID.randomUUID().toString();
    }
}

