/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.datatypes;

import java.util.Objects;
import java.util.regex.Pattern;

public class Oids {
    public static final Pattern PATTERN = Pattern.compile("^(?:[0-2])(?:(?:\\.0)|(?:\\.[1-9][0-9]*+))*+$");
    public static final Pattern PATTERN_WITH_URN = Pattern.compile("^urn:oid:(?:[0-2])(?:(?:\\.0)|(?:\\.[1-9][0-9]*+))*+$");

    private Oids() {
    }

    public static String normalize(String oid) {
        Objects.requireNonNull(oid);
        if (oid.startsWith("urn:oid:")) {
            return oid.substring(8);
        }
        return oid;
    }

    public static boolean match(String string) {
        Objects.requireNonNull(string);
        return PATTERN.matcher(string).matches() || PATTERN_WITH_URN.matcher(string).matches();
    }
}

