/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.datatypes;

import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.projecthusky.common.utils.datatypes.Oids;

public class IheXon {
    private static final int MAX_LENGTH = 256;
    private @MonotonicNonNull String organizationName;
    private @Nullable String organizationId;
    private @Nullable String assigningAuthorityId;

    public IheXon(String organizationName, @Nullable String organizationId, @Nullable String assigningAuthorityId) {
        this.setOrganizationName(organizationName);
        this.setOrganizationId(organizationId, assigningAuthorityId);
    }

    public static @Nullable IheXon parse(String string) {
        if (!IheXon.validate(string)) {
            return null;
        }
        Organization xon = (Organization)Hl7v2Based.parse((String)string, Organization.class);
        return new IheXon(xon.getOrganizationName(), xon.getIdNumber(), xon.getAssigningAuthority() != null ? xon.getAssigningAuthority().getUniversalId() : null);
    }

    public static boolean validate(@Nullable String string) {
        if (string == null || string.isBlank() || string.length() > 256) {
            return false;
        }
        XON xon = (XON)((Organization)Hl7v2Based.parse((String)string, Organization.class)).getHapiObject();
        if (xon == null || xon.getXon1_OrganizationName().getValue() == null || xon.getXon2_OrganizationNameTypeCode().getValue() != null || xon.getXon3_IDNumber().getValue() != null || xon.getXon4_CheckDigit().getValue() != null || xon.getXon5_CheckDigitScheme().getValue() != null || xon.getXon6_AssigningAuthority().getHd1_NamespaceID().getValue() != null || xon.getXon7_IdentifierTypeCode().getValue() != null || xon.getXon8_AssigningFacility().getHd1_NamespaceID().getValue() != null || xon.getXon8_AssigningFacility().getHd2_UniversalID().getValue() != null || xon.getXon8_AssigningFacility().getHd3_UniversalIDType().getValue() != null || xon.getXon9_NameRepresentationCode().getValue() != null) {
            return false;
        }
        HD assigningAuthority = xon.getXon6_AssigningAuthority();
        if (xon.getXon10_OrganizationIdentifier().getValue() == null) {
            return assigningAuthority.getHd2_UniversalID().getValue() == null && assigningAuthority.getHd3_UniversalIDType().getValue() == null;
        }
        if (!(Oids.match(xon.getXon10_OrganizationIdentifier().getValue()) || assigningAuthority.getHd2_UniversalID().getValue() != null && assigningAuthority.getHd3_UniversalIDType().getValue() != null && "ISO".equals(assigningAuthority.getHd3_UniversalIDType().getValue()))) {
            return false;
        }
        return !Oids.match(xon.getXon10_OrganizationIdentifier().getValue()) || assigningAuthority.getHd2_UniversalID().getValue() == null && assigningAuthority.getHd3_UniversalIDType().getValue() == null;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        if (Objects.requireNonNull(organizationName).isBlank()) {
            throw new IllegalArgumentException("The organization name shall not be blank");
        }
        this.organizationName = organizationName;
    }

    public @Nullable String getOrganizationId() {
        return this.organizationId;
    }

    public @Nullable String getAssigningAuthorityId() {
        return this.assigningAuthorityId;
    }

    public void setOrganizationId(@Nullable String organizationId, @Nullable String assigningAuthorityId) {
        if (organizationId == null && assigningAuthorityId == null) {
            this.organizationId = null;
            this.assigningAuthorityId = null;
            return;
        }
        if (organizationId == null || organizationId.isBlank()) {
            throw new IllegalArgumentException("An IHE XON cannot have an assigning authority ID without an organization ID");
        }
        boolean isOrganizationOid = Oids.match(organizationId);
        if (isOrganizationOid && assigningAuthorityId != null) {
            throw new IllegalArgumentException("An IHE XON shall not have an assigning authority ID with an OID");
        }
        if (!isOrganizationOid && (assigningAuthorityId == null || assigningAuthorityId.isBlank())) {
            throw new IllegalArgumentException("An IHE XON shall have an assigning authority ID without an OID");
        }
        if (isOrganizationOid) {
            this.organizationId = Oids.normalize(organizationId);
            this.assigningAuthorityId = null;
        } else {
            this.organizationId = organizationId;
            this.assigningAuthorityId = assigningAuthorityId;
        }
    }

    public @Nullable String getAssigningAuthorityIdType() {
        return this.assigningAuthorityId != null ? "ISO" : null;
    }

    public String render() {
        Organization xon = new Organization();
        xon.setOrganizationName(this.organizationName);
        xon.setIdNumber(this.organizationId);
        if (this.assigningAuthorityId != null) {
            AssigningAuthority assigningAuthority = new AssigningAuthority();
            assigningAuthority.setUniversalId(this.assigningAuthorityId);
            assigningAuthority.setUniversalIdType("ISO");
            xon.setAssigningAuthority(assigningAuthority);
        }
        return Hl7v2Based.render((Hl7v2Based)xon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IheXon)) {
            return false;
        }
        IheXon that = (IheXon)o;
        return Objects.equals(this.organizationName, that.organizationName) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.assigningAuthorityId, that.assigningAuthorityId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationName, this.organizationId, this.assigningAuthorityId);
    }

    public String toString() {
        return "IheXon{organizationName='" + this.organizationName + "', organizationId='" + this.organizationId + "', assigningAuthorityId='" + this.assigningAuthorityId + "'}";
    }
}

