/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.datatypes;

import ca.uhn.hl7v2.model.v25.datatype.CX;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.projecthusky.common.utils.datatypes.Oids;

public class IheCx {
    private String idNumber;
    private String assigningAuthorityId;

    public IheCx(String idNumber, String assigningAuthorityId) {
        this.idNumber = Objects.requireNonNull(idNumber);
        this.assigningAuthorityId = Objects.requireNonNull(assigningAuthorityId);
    }

    public static @Nullable IheCx parse(@Nullable String string) {
        if (!IheCx.validate(string)) {
            return null;
        }
        Identifiable cx = (Identifiable)Hl7v2Based.parse((String)string, Identifiable.class);
        if (cx.getAssigningAuthority() == null) {
            return null;
        }
        return new IheCx(cx.getId(), cx.getAssigningAuthority().getUniversalId());
    }

    public static boolean validate(@Nullable String string) {
        if (string == null || string.isBlank()) {
            return false;
        }
        CX cx = (CX)((Identifiable)Hl7v2Based.parse((String)string, Identifiable.class)).getHapiObject();
        if (cx == null || cx.getCx1_IDNumber().getValue() == null || cx.getCx2_CheckDigit().getValue() != null || cx.getCx3_CheckDigitScheme().getValue() != null || cx.getCx4_AssigningAuthority().getHd1_NamespaceID().getValue() != null || cx.getCx4_AssigningAuthority().getHd2_UniversalID().getValue() == null || cx.getCx4_AssigningAuthority().getHd3_UniversalIDType().getValue() == null || cx.getCx5_IdentifierTypeCode().getValue() != null || cx.getCx6_AssigningFacility().getHd1_NamespaceID().getValue() != null || cx.getCx6_AssigningFacility().getHd2_UniversalID().getValue() != null || cx.getCx6_AssigningFacility().getHd3_UniversalIDType().getValue() != null || cx.getCx7_EffectiveDate().getValue() != null || cx.getCx8_ExpirationDate().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe1_Identifier().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe2_Text().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe3_NameOfCodingSystem().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe4_AlternateIdentifier().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe5_AlternateText().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe6_NameOfAlternateCodingSystem().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe7_CodingSystemVersionID().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe8_AlternateCodingSystemVersionID().getValue() != null || cx.getCx9_AssigningJurisdiction().getCwe9_OriginalText().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe1_Identifier().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe2_Text().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe3_NameOfCodingSystem().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe4_AlternateIdentifier().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe5_AlternateText().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe6_NameOfAlternateCodingSystem().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe7_CodingSystemVersionID().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe8_AlternateCodingSystemVersionID().getValue() != null || cx.getCx10_AssigningAgencyOrDepartment().getCwe9_OriginalText().getValue() != null) {
            return false;
        }
        if (!"ISO".equals(cx.getAssigningAuthority().getHd3_UniversalIDType().getValue())) {
            return false;
        }
        return Oids.PATTERN.matcher(cx.getCx4_AssigningAuthority().getHd2_UniversalID().getValue()).matches();
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        if (Objects.requireNonNull(idNumber).isBlank()) {
            throw new IllegalArgumentException("The id number shall not be blank");
        }
        this.idNumber = idNumber;
    }

    public String getAssigningAuthorityId() {
        return this.assigningAuthorityId;
    }

    public void setAssigningAuthorityId(String assigningAuthorityId) {
        if (Objects.requireNonNull(assigningAuthorityId).isBlank()) {
            throw new IllegalArgumentException("The assigning authority Id shall not be blank");
        }
        this.assigningAuthorityId = assigningAuthorityId;
    }

    public String getAssigningAuthorityTypeId() {
        return "ISO";
    }

    public String render() {
        Identifiable cx = new Identifiable();
        cx.setId(this.idNumber);
        AssigningAuthority aa = new AssigningAuthority();
        aa.setUniversalId(this.assigningAuthorityId);
        aa.setUniversalIdType(this.getAssigningAuthorityTypeId());
        cx.setAssigningAuthority(aa);
        return Hl7v2Based.render((Hl7v2Based)cx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IheCx)) {
            return false;
        }
        IheCx that = (IheCx)o;
        return this.idNumber.equals(that.idNumber) && this.assigningAuthorityId.equals(that.assigningAuthorityId);
    }

    public int hashCode() {
        return Objects.hash(this.idNumber, this.assigningAuthorityId);
    }

    public String toString() {
        return "IheCx{idNumber='" + this.idNumber + "', assigningAuthorityId='" + this.assigningAuthorityId + "'}";
    }
}

