/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils.datatypes;

import java.util.Objects;
import java.util.regex.Pattern;

public class Gln {
    public static final Pattern PATTERN = Pattern.compile("^\\d{13}$");

    private Gln() {
    }

    public static boolean match(String string) {
        Objects.requireNonNull(string);
        return PATTERN.matcher(string).matches() && Gln.validateCheckDigit(string);
    }

    private static boolean validateCheckDigit(String gln) {
        int checkDigit = gln.charAt(12) - 48;
        int sum = 0;
        for (int i = 0; i < gln.length() - 1; ++i) {
            int n = gln.charAt(i) - 48;
            sum += n + (n + n) * (i & 1);
        }
        int expectedCheckDigit = (10 - sum % 10) % 10;
        return checkDigit == expectedCheckDigit;
    }
}

