/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipCreator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final byte[] buffer = new byte[1024];
    private ZipOutputStream out = null;

    public ZipCreator(OutputStream outputStream) {
        this.out = new ZipOutputStream(outputStream);
    }

    public ZipCreator(String filePath) {
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(filePath));
            this.out = new ZipOutputStream(outputStream);
        }
        catch (FileNotFoundException e) {
            this.log.error("Failed to create target file for zip outputstream.", (Throwable)e);
        }
    }

    public void addZipItem(InputStream data, String pathInZipFile) throws IOException {
        this.log.debug("Adding to Zip-file: {}", (Object)pathInZipFile);
        if (data == null) {
            this.out.putNextEntry(new ZipEntry(pathInZipFile));
            this.out.closeEntry();
        } else {
            int length;
            this.out.putNextEntry(new ZipEntry(pathInZipFile));
            while ((length = data.read(this.buffer)) > 0) {
                this.out.write(this.buffer, 0, length);
            }
            this.out.closeEntry();
        }
    }

    public void addZipItem(String pathInZipFile) throws IOException {
        this.out.putNextEntry(new ZipEntry(pathInZipFile));
        this.out.closeEntry();
    }

    public void addZipItem(String filePath, String pathInZipFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(filePath);
        this.addZipItem(inputStream, pathInZipFile);
    }

    public void closeZip() throws IOException {
        this.out.close();
    }
}

