/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Address;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.PatientInfo;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XpnName;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryList;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.basetypes.OrganizationBaseType;
import org.projecthusky.common.enums.AdministrativeGender;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Patient;
import org.projecthusky.common.model.Telecom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdsMetadataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XdsMetadataUtil.class);
    public static final String DTM_FMT_Y = "yyyy";
    public static final String DTM_FMT_YM = "yyyyMM";
    public static final String DTM_FMT_YMD = "yyyyMMdd";
    public static final String DTM_FMT_YMDH = "yyyyMMddHH";
    public static final String DTM_FMT_YMDHM = "yyyyMMddHHmm";
    public static final String DTM_FMT_YMDHMS = "yyyyMMddHHmmss";
    protected static final String[] DTM_FMT = new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMddHH", "yyyyMMdd", "yyyyMM", "yyyy"};

    private XdsMetadataUtil() {
    }

    public static String convertDateToDtmString(Date dateTime) {
        String retVal = null;
        if (dateTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DTM_FMT_YMDHMS);
            retVal = sdf.format(dateTime);
        }
        return retVal;
    }

    public static Date convertDtmStringToDate(String dateTimeString) {
        Date retVal = null;
        if (dateTimeString != null && !"".equals(dateTimeString)) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            for (int count = 0; retVal == null && count < DTM_FMT.length; ++count) {
                sdf.applyPattern(DTM_FMT[count]);
                try {
                    retVal = sdf.parse(dateTimeString);
                    continue;
                }
                catch (ParseException e) {
                    LOGGER.info("Date {} could not be parsed", (Object)dateTimeString);
                }
            }
        }
        return retVal;
    }

    public static org.openehealth.ipf.commons.ihe.xds.core.metadata.Code convertEhcCodeToCode(Code code) {
        return XdsMetadataUtil.createCodedMetadata(code.getCodeSystem(), code.getCode(), code.getDisplayName());
    }

    public static org.openehealth.ipf.commons.ihe.xds.core.metadata.Code convertEhcCodeToCode(ValueSetEnumInterface code) {
        return XdsMetadataUtil.createCodedMetadata(code.getCodeSystemId(), code.getCodeValue(), code.getDisplayName());
    }

    public static org.openehealth.ipf.commons.ihe.xds.core.metadata.Code convertEhcCodeToIpfCode(Code code, String language) {
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Code retVal = XdsMetadataUtil.createCodedMetadata(code.getCodeSystem(), code.getCode(), code.getDisplayName());
        retVal.getDisplayName().setLang(language);
        return retVal;
    }

    public static List<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> convertEhcCodeToCode(List<Code> codeList) {
        if (codeList == null) {
            return new LinkedList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code>();
        }
        LinkedList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> cmtArray = new LinkedList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code>();
        for (Code cme : codeList) {
            cmtArray.add(XdsMetadataUtil.convertEhcCodeToCode(cme));
        }
        return cmtArray;
    }

    public static List<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> convertEhcCodeToCode(ValueSetEnumInterface[] codeList) {
        if (codeList == null) {
            return new LinkedList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code>();
        }
        LinkedList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> cmtArray = new LinkedList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code>();
        for (ValueSetEnumInterface cme : codeList) {
            cmtArray.add(XdsMetadataUtil.convertEhcCodeToCode(cme));
        }
        return cmtArray;
    }

    public static QueryList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> convertEhcCodeToQueryListCode(List<Code> codeList) {
        if (codeList == null) {
            return null;
        }
        QueryList cmtArray = new QueryList();
        for (Code cme : codeList) {
            cmtArray.getOuterList().add(List.of(XdsMetadataUtil.convertEhcCodeToCode(cme)));
        }
        return cmtArray;
    }

    public static QueryList<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> convertEhcCodeToQueryListCode(ValueSetEnumInterface[] codeList) {
        if (codeList == null) {
            return null;
        }
        QueryList cmtArray = new QueryList();
        for (ValueSetEnumInterface cme : codeList) {
            cmtArray.getOuterList().add(List.of(XdsMetadataUtil.convertEhcCodeToCode(cme)));
        }
        return cmtArray;
    }

    public static Identifiable convertEhcIdentificator(Identificator id) {
        if (id == null) {
            return null;
        }
        return new Identifiable(id.getExtension(), new AssigningAuthority(id.getRoot()));
    }

    public static Organization convertIpfOrganization(List<org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization> authorInstitutions) {
        if (authorInstitutions == null) {
            return null;
        }
        for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization xon : authorInstitutions) {
            if (xon == null) continue;
            OrganizationBaseType org = new OrganizationBaseType();
            org.addIdentificator(XdsMetadataUtil.convertOhtXcnIdToEhc(xon.getAssigningAuthority(), xon.getIdNumber()));
            org.addName(new Name(xon.getOrganizationName()));
            return new Organization(org);
        }
        return null;
    }

    public static String convertInternationalStringType(LocalizedString ist) {
        if (ist != null) {
            return ist.getValue();
        }
        return null;
    }

    public static org.projecthusky.common.model.Author convertIpfAuthor(Author at) {
        org.projecthusky.common.model.Author a = new org.projecthusky.common.model.Author();
        Person ap = null;
        if (at != null) {
            if (at.getAuthorPerson() != null) {
                ap = at.getAuthorPerson();
                a.addId(XdsMetadataUtil.convertIpfIdentifiableToEhc(ap.getId()));
                a.addName(new Name(ap.getName()));
            }
            if (!at.getAuthorInstitution().isEmpty()) {
                a.setOrganization(XdsMetadataUtil.convertIpfOrganization(at.getAuthorInstitution()));
            }
            if (!at.getAuthorRole().isEmpty() && at.getAuthorRole().get(0) != null) {
                a.setRoleFunction(XdsMetadataUtil.convertIpfAuthorRole((Identifiable)at.getAuthorRole().get(0)));
            }
            if (!at.getAuthorSpecialty().isEmpty() && at.getAuthorSpecialty().get(0) != null) {
                a.setSpeciality(new Code(((Identifiable)at.getAuthorSpecialty().get(0)).getId(), ((Identifiable)at.getAuthorSpecialty().get(0)).getAssigningAuthority().getUniversalId(), null));
            }
            if (!at.getAuthorTelecom().isEmpty()) {
                a.setTelecoms(XdsMetadataUtil.convertIpfTelecoms(at.getAuthorTelecom()));
            }
        }
        return a;
    }

    private static Code convertIpfAuthorRole(Identifiable authorRole) {
        String codeSystem = "";
        if (authorRole.getAssigningAuthority() != null) {
            codeSystem = authorRole.getAssigningAuthority().getUniversalId();
        }
        return new Code(authorRole.getId(), codeSystem, null);
    }

    public static List<Telecom> convertIpfTelecoms(List<org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom> xtnList) {
        LinkedList<Telecom> t = new LinkedList<Telecom>();
        for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom xtn : xtnList) {
            if (xtn == null || xtn.getType() == null) continue;
            Telecom telecom = new Telecom();
            String number = XdsMetadataUtil.extractPhoneNumber(xtn);
            if ("FX".equalsIgnoreCase(xtn.getType())) {
                telecom.setFax(number);
            } else if ("PH".equalsIgnoreCase(xtn.getType())) {
                telecom.setPhone(number);
            } else {
                telecom.setMail(xtn.getEmail());
            }
            if (xtn.getUse() != null) {
                telecom.setUsage(TelecomAddressUse.getEnum(xtn.getUse()));
            }
            t.add(telecom);
        }
        return t;
    }

    private static String extractPhoneNumber(org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom xtn) {
        if (xtn.getUnformattedPhoneNumber() != null && !xtn.getUnformattedPhoneNumber().isEmpty()) {
            return xtn.getUnformattedPhoneNumber();
        }
        return String.format("%d%d%d%d", xtn.getCountryCode(), xtn.getAreaCityCode(), xtn.getLocalNumber(), xtn.getExtension());
    }

    public static Author converteHCAuthor(org.projecthusky.common.model.Author at) {
        Author a = new Author();
        Person ap = new Person();
        if (at != null) {
            if (at.getName() != null) {
                ap.setName((org.openehealth.ipf.commons.ihe.xds.core.metadata.Name)new XpnName(at.getName().getFamily(), at.getName().getGiven(), null, at.getName().getSuffix(), at.getName().getPrefix(), null));
            }
            if (at.getIds() != null && !at.getIds().isEmpty() && at.getIds().get(0) != null) {
                ap.setId(XdsMetadataUtil.convertEhcIdentificator(at.getIds().get(0)));
            }
            a.setAuthorPerson(ap);
            Organization xon = null;
            if (at.getOrganization() != null) {
                xon = at.getOrganization();
                a.getAuthorInstitution().add(XdsMetadataUtil.convertXonToIpfOrganization(xon));
            }
            Identifiable role = null;
            if (at.getRoleFunction() != null) {
                role = new Identifiable(at.getRoleFunction().getCode(), new AssigningAuthority(at.getRoleFunction().getCodeSystem()));
                a.getAuthorRole().add(role);
            }
            Identifiable speciality = null;
            if (at.getSpeciality() != null) {
                speciality = new Identifiable(at.getSpeciality().getCode(), new AssigningAuthority(at.getSpeciality().getCodeSystem()));
                a.getAuthorSpecialty().add(speciality);
            }
        }
        return a;
    }

    public static org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization convertXonToIpfOrganization(Organization xon) {
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization org = new org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization();
        if (xon.getPrimaryName() != null) {
            org.setOrganizationName(xon.getPrimaryName().getFullName());
        }
        if (xon.getPrimaryIdentificator() != null) {
            org.setIdNumber(xon.getPrimaryIdentificator().getExtension());
            AssigningAuthority assigningAuthority = new AssigningAuthority();
            assigningAuthority.setUniversalId(xon.getPrimaryIdentificator().getExtension());
            org.setAssigningAuthority(assigningAuthority);
        }
        return org;
    }

    public static Code convertOhtCodedMetadataType(org.openehealth.ipf.commons.ihe.xds.core.metadata.Code cmt) {
        Code code = new Code();
        code.setCode(cmt.getCode());
        code.setDisplayName(XdsMetadataUtil.convertInternationalStringType(cmt.getDisplayName()));
        code.setCodeSystem(cmt.getSchemeName());
        return code;
    }

    public static Identificator convertOhtCx(Identifiable cx) {
        if (cx == null) {
            return null;
        }
        return new Identificator(cx.getAssigningAuthority().getUniversalId(), cx.getId());
    }

    public static Patient convertOhtSourcePatientInfoType(PatientInfo spit) {
        ListIterator ids;
        ListIterator addresses;
        Patient p = new Patient();
        ListIterator names = spit.getNames();
        if (names.hasNext()) {
            while (names.hasNext()) {
                p.addName(XdsMetadataUtil.convertOhtXpn((org.openehealth.ipf.commons.ihe.xds.core.metadata.Name)names.next()));
            }
        }
        if (spit.getDateOfBirth() != null) {
            p.setBirthday(spit.getDateOfBirth().getDateTime());
        }
        if (spit.getGender() != null) {
            p.setAdministrativeGender(AdministrativeGender.getEnum(spit.getGender()));
        }
        if ((addresses = spit.getAddresses()) != null) {
            while (addresses.hasNext()) {
                p.addAddress(XdsMetadataUtil.convertOhtXad((Address)addresses.next()));
            }
        }
        if ((ids = spit.getIds()) != null) {
            while (ids.hasNext()) {
                Identifiable cx = (Identifiable)ids.next();
                if (cx == null) continue;
                p.addId(XdsMetadataUtil.convertOhtCx(cx));
            }
        }
        return p;
    }

    public static org.projecthusky.common.model.Address convertOhtXad(Address xad) {
        if (xad == null) {
            return null;
        }
        org.projecthusky.common.model.Address address = new org.projecthusky.common.model.Address(new AddressBaseType());
        if (xad.getStreetAddress() != null && !xad.getStreetAddress().equals("")) {
            address.setStreetAddressLine1(xad.getStreetAddress());
        }
        if (xad.getZipOrPostalCode() != null) {
            address.setPostalCode(xad.getZipOrPostalCode());
        }
        if (xad.getCity() != null) {
            address.setCity(xad.getCity());
        }
        if (xad.getCountry() != null) {
            address.setCountry(xad.getCountry());
        }
        if (xad.getStateOrProvince() != null) {
            address.setState(xad.getStateOrProvince());
        }
        return address;
    }

    public static Identificator convertOhtXcnIdToEhc(AssigningAuthority assigningAuthorityUniversalId, String id) {
        if (assigningAuthorityUniversalId != null) {
            return new Identificator(assigningAuthorityUniversalId.getUniversalId(), id);
        }
        return new Identificator(null, id);
    }

    public static Identificator convertIpfIdentifiableToEhc(Identifiable id) {
        return new Identificator(id);
    }

    public static Name convertOhtXpn(org.openehealth.ipf.commons.ihe.xds.core.metadata.Name<?> xpn) {
        Name name = new Name();
        name.setGiven(xpn.getGivenName());
        name.setFamily(xpn.getFamilyName());
        name.setPrefix(xpn.getPrefix());
        name.setSuffix(xpn.getSuffix());
        return name;
    }

    public static org.openehealth.ipf.commons.ihe.xds.core.metadata.Code createCodedMetadata(String schemeName, String code, String displayName) {
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Code cmt = new org.openehealth.ipf.commons.ihe.xds.core.metadata.Code();
        cmt.setCode(code);
        if (displayName != null) {
            cmt.setDisplayName(null);
            cmt.setDisplayName(XdsMetadataUtil.createInternationalString(displayName));
        }
        if (schemeName != null) {
            cmt.setSchemeName(schemeName);
        }
        return cmt;
    }

    public static org.openehealth.ipf.commons.ihe.xds.core.metadata.Code createCodedMetadata(String schemeName, String code, String displayName, String language) {
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Code cmt = new org.openehealth.ipf.commons.ihe.xds.core.metadata.Code();
        cmt.setCode(code);
        if (displayName != null) {
            cmt.setDisplayName(XdsMetadataUtil.createInternationalString(displayName, language));
        }
        if (schemeName != null) {
            cmt.setSchemeName(schemeName);
        }
        return cmt;
    }

    public static LocalizedString createInternationalString(String text) {
        LocalizedString lst = new LocalizedString();
        lst.setValue(text);
        return lst;
    }

    public static LocalizedString createInternationalString(String text, String language) {
        LocalizedString lst = new LocalizedString();
        lst.setValue(text);
        lst.setLang(language);
        return lst;
    }
}

