/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.projecthusky.common.basetypes.OrganizationBaseType;
import org.projecthusky.common.enums.PostalAddressUse;
import org.projecthusky.common.enums.Signature;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.ADXP;
import org.projecthusky.common.hl7cdar2.AdxpCity;
import org.projecthusky.common.hl7cdar2.AdxpPostalCode;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.ENXP;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ON;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedAuthor;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedEntity;
import org.projecthusky.common.hl7cdar2.POCDMT000040Authenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040CustodianOrganization;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040LegalAuthenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organization;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class Util {
    private static Logger log = LoggerFactory.getLogger(Util.class);
    public static final String TELECOMS_EMAIL_PREFIX = "mailto:";
    public static final String TELECOMS_FAX_PREFIX = "fax:";
    public static final String TELECOMS_PHONE_PREFIX = "tel:";
    public static final String TELECOMS_WEBSITE_PREFIX = "http";
    public static final String NAMESPACE_HL7_V3 = "urn:hl7-org:v3";
    private static Random rand;

    private Util() {
        throw new IllegalStateException("This is a utility class!");
    }

    public static boolean atLeastOne(List<?> l) {
        return l != null && !l.isEmpty() && l.get(0) != null;
    }

    public static List<Identificator> convertIds(List<II> mII) {
        ArrayList<Identificator> il = new ArrayList<Identificator>();
        for (II mId : mII) {
            il.add(new Identificator(mId));
        }
        return il;
    }

    public static AD createAddress(String zip, String city, PostalAddressUse usage) {
        ADXP obj;
        AD retVal = new AD();
        if (city != null) {
            obj = new AdxpCity();
            obj.setXmlMixed(city);
            retVal.getContent().add((Serializable)new JAXBElement(new QName(NAMESPACE_HL7_V3, "city"), AdxpCity.class, (Object)obj));
        }
        if (zip != null) {
            obj = new AdxpPostalCode();
            obj.setXmlMixed(zip);
            retVal.getContent().add((Serializable)new JAXBElement(new QName(NAMESPACE_HL7_V3, "postalCode"), AdxpPostalCode.class, (Object)obj));
        }
        if (usage != null) {
            retVal.getUse().clear();
            retVal.getUse().add(usage.getCodeValue());
        }
        return retVal;
    }

    public static POCDMT000040AssignedAuthor createAssignedAuthorFromAssignedEntity(POCDMT000040AssignedEntity a) {
        POCDMT000040AssignedAuthor asAut = new POCDMT000040AssignedAuthor();
        asAut.getAddr().addAll(a.getAddr());
        asAut.getId().addAll(a.getId());
        asAut.getTelecom().addAll(a.getTelecom());
        asAut.setRepresentedOrganization(a.getRepresentedOrganization());
        asAut.setAssignedPerson(a.getAssignedPerson());
        return asAut;
    }

    public static POCDMT000040AssignedAuthor createAssignedAuthorFromOrganization(Organization organization) {
        POCDMT000040Organization o = organization.getHl7CdaR2Pocdmt000040Organization();
        POCDMT000040AssignedAuthor a = new POCDMT000040AssignedAuthor();
        if (!o.getAddr().isEmpty()) {
            a.getAddr().addAll(o.getAddr());
        }
        if (!o.getTelecom().isEmpty()) {
            a.getTelecom().addAll(o.getTelecom());
        }
        if (!o.getId().isEmpty()) {
            a.getId().addAll(o.getId());
        }
        return a;
    }

    public static POCDMT000040AssignedEntity createAssignedEntityFromAssignedAuthor(POCDMT000040AssignedAuthor a) {
        POCDMT000040AssignedEntity asEnt = new POCDMT000040AssignedEntity();
        asEnt.getAddr().addAll(a.getAddr());
        asEnt.getId().addAll(a.getId());
        asEnt.getTelecom().addAll(a.getTelecom());
        if (a.getRepresentedOrganization() != null) {
            asEnt.setRepresentedOrganization(a.getRepresentedOrganization());
        }
        if (a.getAssignedPerson() != null) {
            asEnt.setAssignedPerson(a.getAssignedPerson());
        }
        return asEnt;
    }

    public static POCDMT000040AssignedEntity createAssignedEntityFromOrganization(Organization organization) {
        POCDMT000040Organization o = organization.getHl7CdaR2Pocdmt000040Organization();
        POCDMT000040AssignedEntity a = new POCDMT000040AssignedEntity();
        if (!o.getAddr().isEmpty()) {
            a.getAddr().addAll(o.getAddr());
        }
        if (!o.getTelecom().isEmpty()) {
            a.getTelecom().addAll(o.getTelecom());
        }
        if (!o.getId().isEmpty()) {
            a.getId().addAll(o.getId());
        }
        return a;
    }

    public static POCDMT000040Authenticator createAuthenticatorFromAuthor(Author author) {
        POCDMT000040Author a = author.getAuthorMdht();
        POCDMT000040Authenticator auth = new POCDMT000040Authenticator();
        auth.setAssignedEntity(Util.createAssignedEntityFromAssignedAuthor(a.getAssignedAuthor()));
        CS cs = Signature.SIGNED.getCS();
        auth.setSignatureCode(cs);
        auth.setTime(a.getTime());
        return auth;
    }

    public static POCDMT000040Author createAuthorFromAuthenticator(POCDMT000040Authenticator authenticator) {
        POCDMT000040Author a = new POCDMT000040Author();
        a.setAssignedAuthor(Util.createAssignedAuthorFromAssignedEntity(authenticator.getAssignedEntity()));
        a.setTime(authenticator.getTime());
        return a;
    }

    public static POCDMT000040Author createAuthorFromLegalAuthenticator(POCDMT000040LegalAuthenticator authenticator) {
        POCDMT000040Author a = new POCDMT000040Author();
        a.setAssignedAuthor(Util.createAssignedAuthorFromAssignedEntity(authenticator.getAssignedEntity()));
        a.setTime(authenticator.getTime());
        return a;
    }

    public static POCDMT000040CustodianOrganization createCustodianOrganizationFromOrganization(Organization organization) {
        if (organization != null) {
            POCDMT000040CustodianOrganization mdhtCustOrg = new POCDMT000040CustodianOrganization();
            ON on = new ON();
            on.setXmlMixed(organization.getPrimaryName().getFullName());
            if (!organization.getHl7CdaR2Pocdmt000040Organization().getName().isEmpty()) {
                on.getUse().clear();
                for (String item : organization.getHl7CdaR2Pocdmt000040Organization().getName().get(0).getUse()) {
                    on.getUse().add(item);
                }
            }
            mdhtCustOrg.setName(on);
            if (!organization.getHl7CdaR2Pocdmt000040Organization().getAddr().isEmpty()) {
                mdhtCustOrg.setAddr(organization.getHl7CdaR2Pocdmt000040Organization().getAddr().get(0));
                mdhtCustOrg.getAddr().getUse().addAll(organization.getHl7CdaR2Pocdmt000040Organization().getAddr().get(0).getUse());
            }
            if (!organization.getHl7CdaR2Pocdmt000040Organization().getTelecom().isEmpty()) {
                mdhtCustOrg.setTelecom(organization.getHl7CdaR2Pocdmt000040Organization().getTelecom().get(0));
                mdhtCustOrg.getTelecom().getUse().add(organization.getHl7CdaR2Pocdmt000040Organization().getTelecom().get(0).getUse().get(0));
            }
            return mdhtCustOrg;
        }
        return null;
    }

    public static IVLTS createEffectiveTimeNullFlavorUnk() {
        IVLTS ivlts = new IVLTS();
        ivlts.nullFlavor = new LinkedList();
        ivlts.getNullFlavor().add("UNK");
        return ivlts;
    }

    public static TEL createEMail(String eMail, TelecomAddressUse usage) {
        TEL tel = new TEL();
        tel.getUse().add(usage.getCodeValue());
        tel.setValue(TELECOMS_EMAIL_PREFIX + eMail);
        return tel;
    }

    public static String createEurDateStrFromTS(String hl7Stimestamp) {
        return hl7Stimestamp.substring(6, 8) + "." + hl7Stimestamp.substring(4, 6) + "." + hl7Stimestamp.substring(0, 4);
    }

    public static TEL createFax(String faxNr, TelecomAddressUse usage) {
        TEL tel = new TEL();
        tel.getUse().add(usage.getCodeValue());
        tel.setValue(TELECOMS_FAX_PREFIX + faxNr);
        return tel;
    }

    public static POCDMT000040LegalAuthenticator createLegalAuthenticatorFromAuthor(Author author) {
        POCDMT000040Author a = author.getAuthorMdht();
        POCDMT000040LegalAuthenticator mdhtLegAuth = new POCDMT000040LegalAuthenticator();
        mdhtLegAuth.setAssignedEntity(Util.createAssignedEntityFromAssignedAuthor(a.getAssignedAuthor()));
        CS cs = Signature.SIGNED.getCS();
        mdhtLegAuth.setSignatureCode(cs);
        mdhtLegAuth.setTime(a.getTime());
        return mdhtLegAuth;
    }

    private static ON createOnFromPn(PN pn) {
        ON on = new ON();
        on.setXmlMixed(pn.getXmlMixed());
        return on;
    }

    public static POCDMT000040CustodianOrganization createOrganizationFromCustodianOrganization(POCDMT000040CustodianOrganization mdhtCO) {
        POCDMT000040CustodianOrganization o = new POCDMT000040CustodianOrganization();
        if (mdhtCO != null) {
            if (mdhtCO.getName() != null) {
                o.setName(mdhtCO.getName());
            }
            if (!mdhtCO.getId().isEmpty()) {
                o.getId().addAll(mdhtCO.getId());
            }
            if (mdhtCO.getAddr() != null) {
                o.setAddr(mdhtCO.getAddr());
            }
            if (mdhtCO.getTelecom() != null) {
                o.setTelecom(mdhtCO.getTelecom());
            }
        }
        return o;
    }

    public static Organization createOrganizationFromParticipant(Participant p) {
        Organization o = new Organization(new OrganizationBaseType());
        for (II id : p.getMdht().getParticipantRole().getId()) {
            if (id == null) continue;
            o.getHl7CdaR2Pocdmt000040Organization().getId().add(id);
        }
        for (AD ad : p.getMdht().getParticipantRole().getAddr()) {
            if (ad == null) continue;
            o.getHl7CdaR2Pocdmt000040Organization().getAddr().add(ad);
        }
        if (p.getMdht().getParticipantRole().getPlayingEntity().getName() != null && !p.getMdht().getParticipantRole().getPlayingEntity().getName().isEmpty()) {
            for (PN pn : p.getMdht().getParticipantRole().getPlayingEntity().getName()) {
                o.getHl7CdaR2Pocdmt000040Organization().getName().add(Util.createOnFromPn(pn));
            }
        }
        for (TEL tel : p.getMdht().getParticipantRole().getTelecom()) {
            o.getHl7CdaR2Pocdmt000040Organization().getTelecom().add(tel);
        }
        return o;
    }

    public static PN createPnFromOn(ON on) {
        PN pn = new PN();
        pn.setXmlMixed(on.getXmlMixed());
        return pn;
    }

    @Deprecated
    public static ED createReference(ED existingText, String reference) {
        ED ed = existingText;
        if (ed == null) {
            ed = new ED();
        }
        ed.setReference(Util.createReferenceTel(reference));
        return ed;
    }

    @Deprecated
    public static ED createReference(int contentId, String prefix) {
        ED text = new ED();
        TEL tel = new TEL();
        tel.setValue("#" + prefix + contentId);
        text.setReference(tel);
        return text;
    }

    @Deprecated
    public static ED createReference(String reference) {
        ED ed = new ED();
        ed.setReference(Util.createReferenceTel(reference));
        return ed;
    }

    @Deprecated
    public static ED createReference(String url, String narrativeText) {
        TEL tel = new TEL();
        ED ed = new ED();
        tel.setValue(url);
        ed.setXmlMixed(narrativeText);
        ed.setReference(tel);
        return ed;
    }

    @Deprecated
    public static TEL createReferenceTel(String value) {
        TEL tel = new TEL();
        if (!((String)value).startsWith("#")) {
            value = "#" + (String)value;
        }
        tel.setValue((String)value);
        return tel;
    }

    public static TEL createTel(String telNr, TelecomAddressUse usage) {
        TEL tel = new TEL();
        if (usage != null) {
            tel.getUse().add(usage.getCodeValue());
        }
        tel.setValue(TELECOMS_PHONE_PREFIX + telNr.replaceAll("\\s+", ""));
        return tel;
    }

    public static int getChecksum(Serializable object) {
        int retVal = -1;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] thedigest = md.digest(baos.toByteArray());
            retVal = Arrays.hashCode(thedigest);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return retVal;
    }

    public static String getCommentRef(List<POCDMT000040EntryRelationship> e) {
        for (POCDMT000040EntryRelationship er : e) {
            ED ed;
            if (!er.getTypeCode().equals((Object)XActRelationshipEntryRelationship.SUBJ) || er.getAct().getText() == null || (ed = er.getAct().getText()).getReference() == null) continue;
            return ed.getReference().getValue();
        }
        return null;
    }

    public static String getCommentText(List<POCDMT000040EntryRelationship> e) {
        for (POCDMT000040EntryRelationship er : e) {
            if (!er.getTypeCode().equals((Object)XActRelationshipEntryRelationship.SUBJ)) continue;
            ED ed = er.getAct().getText();
            return ed.getTextContent();
        }
        return null;
    }

    public static String getCommentText(List<POCDMT000040EntryRelationship> e, String contentId) {
        for (POCDMT000040EntryRelationship er : e) {
            if (!er.getTypeCode().equals((Object)XActRelationshipEntryRelationship.SUBJ)) continue;
            ED ed = er.getAct().getText();
            ed.setReference(Util.createReferenceTel(contentId));
            return ed.getTextContent();
        }
        return null;
    }

    public static String getCurrentDirectory() {
        Object retVal = "";
        File temp = new File((String)retVal);
        if (!((String)(retVal = temp.getAbsolutePath())).endsWith("/")) {
            retVal = (String)retVal + "/";
        }
        return retVal;
    }

    public static Map<String, TelecomAddressUse> getEMail(List<TEL> telecoms) {
        return Util.getTelecomType(telecoms, TELECOMS_EMAIL_PREFIX);
    }

    public static Map<String, TelecomAddressUse> getFax(List<TEL> telecoms) {
        return Util.getTelecomType(telecoms, TELECOMS_FAX_PREFIX);
    }

    public static Map<String, TelecomAddressUse> getPhones(List<TEL> telecoms) {
        return Util.getTelecomType(telecoms, TELECOMS_PHONE_PREFIX);
    }

    public static String getRscDir() {
        Object rscDir = new File("").getAbsoluteFile().getAbsolutePath() + "/rsc";
        if (!new File((String)rscDir).exists()) {
            rscDir = new File("").getAbsoluteFile().getAbsolutePath() + "/../rsc";
        }
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> vmArgs = runtimeMxBean.getInputArguments();
        for (String vmArg : vmArgs) {
            if (!vmArg.toLowerCase().startsWith("-drscdir=")) continue;
            rscDir = vmArg.substring(9, vmArg.length());
        }
        if (!((String)rscDir).endsWith("/")) {
            rscDir = (String)rscDir + "/";
        }
        if (!new File((String)rscDir).exists()) {
            throw new RuntimeException("rsc dir not found (" + (String)rscDir + ")");
        }
        return rscDir;
    }

    public static List<String> getSystemFontsPaths() {
        ArrayList<String> result = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            String path = System.getenv("WINDIR");
            result.add(path + "\\Fonts");
            return result;
        }
        if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_MAC) {
            result.add(System.getProperty("user.home") + File.separator + "Library/Fonts");
            result.add("/Library/Fonts");
            result.add("/System/Library/Fonts");
            return result;
        }
        if (SystemUtils.IS_OS_LINUX) {
            String[] pathsToCheck = new String[]{System.getProperty("user.home") + File.separator + ".fonts", "/usr/share/fonts/truetype", "/usr/share/fonts/TTF"};
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = pathsToCheck.length - 1; i >= 0; --i) {
                String path = pathsToCheck[i];
                File tmp = new File(path);
                if (!tmp.exists() || !tmp.isDirectory() || !tmp.canRead()) continue;
                resultList.add(path);
            }
        }
        return result;
    }

    private static Map<String, TelecomAddressUse> getTelecomType(List<TEL> telecoms, String type) {
        HashMap<String, TelecomAddressUse> tl = new HashMap<String, TelecomAddressUse>();
        for (TEL tel : telecoms) {
            if (!tel.getValue().toLowerCase().contains(type)) continue;
            tl.put(tel.getValue(), !tel.getUse().isEmpty() ? TelecomAddressUse.getEnum(tel.getUse().get(0)) : null);
        }
        return tl;
    }

    public static String getTempDirectory() {
        String envVariable = "eHCTempPath";
        String tempDirectoryPath = null;
        Logger log = LoggerFactory.getLogger(Util.class);
        try {
            String env = System.getenv("eHCTempPath");
            if (env != null) {
                tempDirectoryPath = env;
                log.debug("Trying to use temp folder set by environment variable '{}': {}", (Object)"eHCTempPath", (Object)tempDirectoryPath);
            } else {
                tempDirectoryPath = "/temp";
                log.debug("Trying to use hardcoded temp folder: {}", (Object)tempDirectoryPath);
            }
            File uniqueFile = File.createTempFile("eHC", ".tmp", new File(tempDirectoryPath));
            FileUtils.writeStringToFile((File)uniqueFile, (String)"write check");
            FileUtils.deleteQuietly((File)uniqueFile);
        }
        catch (Exception e) {
            tempDirectoryPath = FileUtils.getTempDirectoryPath();
            log.debug("failed... Will use system temp folder: {}", (Object)tempDirectoryPath);
        }
        log.info("Temp folder: {}", (Object)tempDirectoryPath);
        return tempDirectoryPath;
    }

    public static String getUsedMemoryString(String hint) {
        return hint + ": Used VM memory: " + Long.toString(Util.getVmMemoryUsedInMegaBytes()) + " MB\n";
    }

    public static InputStream getUtf8InputStream(File file) {
        try {
            return Util.getUtf8InputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getUtf8InputStream(FileInputStream fis) {
        try {
            return IOUtils.toInputStream((String)IOUtils.toString((Reader)new InputStreamReader((InputStream)fis, Charsets.UTF_8)), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getUtf8InputStream(InputStream is) {
        try {
            return IOUtils.toInputStream((String)IOUtils.toString((Reader)new InputStreamReader(is, Charsets.UTF_8)), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getUtf8InputStream(String fileName) {
        return Util.getUtf8InputStream(new File(fileName));
    }

    public static int getVmMemoryFreeInMegaBytes() {
        return (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
    }

    public static int getVmMemoryTotalInMegaBytes() {
        return (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
    }

    public static int getVmMemoryUsedInMegaBytes() {
        return (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
    }

    public static Map<String, TelecomAddressUse> getWebsites(List<TEL> telecoms) {
        return Util.getTelecomType(telecoms, TELECOMS_WEBSITE_PREFIX);
    }

    public static boolean isComment(POCDMT000040EntryRelationship er) {
        return er.getTypeCode().equals((Object)XActRelationshipEntryRelationship.SUBJ) && er.isInversionInd() != null && er.isInversionInd() != false;
    }

    public static String join(List<String> nameList, String delimiter) {
        if (nameList == null || nameList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : nameList) {
            if (builder.length() > 0) {
                builder.append(delimiter).append(string);
                continue;
            }
            builder.append(string);
        }
        return builder.toString();
    }

    public static String joinEListStr(List<ENXP> list) {
        if (list.isEmpty()) {
            return "";
        }
        String names = list.get(0).getTextContent();
        if (list.size() > 1) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                nameList.add(list.get(i).getTextContent());
            }
            return Util.join(nameList, " ");
        }
        return names;
    }

    public static void logAvailableMemory(Class theClass, String hint) {
        Logger log = LoggerFactory.getLogger((Class)theClass);
        log.info("{}: freeMemory: {} MB", (Object)hint, (Object)Util.getVmMemoryFreeInMegaBytes());
    }

    public static void runExternalCommand(String cmd) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(cmd);
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
        ExecutorService ex = Executors.newSingleThreadExecutor();
        ex.submit(streamGobbler);
        int exitCode = process.waitFor();
        ex.shutdown();
        assert (exitCode == 0);
    }

    public static ST st(String text) {
        ST value = new ST();
        value.setXmlMixed(text);
        return value;
    }

    public static InputStream string2InputStream(String inputStr) {
        return new ByteArrayInputStream(inputStr.getBytes(StandardCharsets.UTF_8));
    }

    public static Random getRand() {
        return rand;
    }

    public static void setRand(Random rand) {
        Util.rand = rand;
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

