/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class Sources {
    private Sources() {
    }

    public static Source fromFile(File file) {
        return new StreamSource(file);
    }

    public static Source fromInputStream(InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    public static Source fromByteArray(byte[] bytes) {
        return Sources.fromInputStream(new ByteArrayInputStream(bytes));
    }

    public static Source fromString(String string) {
        return Sources.fromByteArray(string.getBytes(StandardCharsets.UTF_8));
    }

    public static Source fromDomDocument(Document document) {
        return new DOMSource(document);
    }
}

