/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OptionalUtils {
    private OptionalUtils() {
    }

    public static <T> @Nullable T getListElementAtIndex(List<T> list, int index) {
        Objects.requireNonNull(list);
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public static <T> @Nullable T getListFirstElement(List<T> list) {
        return OptionalUtils.getListElementAtIndex(Objects.requireNonNull(list), 0);
    }

    public static <T> @Nullable T getListOnlyElement(List<T> list) {
        if (Objects.requireNonNull(list).size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public static <T> @Nullable T castOrNull(Object object, Class<T> type) {
        Objects.requireNonNull(object, "object shall not be null in castOrFilter()");
        Objects.requireNonNull(type, "type shall not be null in castOrFilter()");
        return type.isInstance(object) ? (T)type.cast(object) : null;
    }
}

