/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;

public class IoStreamUtils {
    private IoStreamUtils() {
    }

    public static long calculateSize(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        try {
            inputStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (CountingOutputStream counter = new CountingOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);){
            int b;
            while ((b = inputStream.read()) != -1) {
                counter.write(b);
            }
            long l = counter.getByteCount();
            return l;
        }
    }
}

