/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.TS;

@Deprecated(since="1.0", forRemoval=true)
public class DateUtil {
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd";
    public static final String LONG_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String ERRORMSG_CANNOT_PARSE_DATE_VAL = "Cannot parse date, value=[";

    private DateUtil() {
    }

    public static IVLTS date2Ivlts(Date value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new IVLTS(DateUtil.formatDateTime(value));
    }

    public static IVLTS date2IvltsDateOnly(Date value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new IVLTS(DateUtil.formatDateOnly(value));
    }

    public static IVLTS date2IvltsTzon(Date value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new IVLTS(DateUtil.formatDateTimeTzon(value));
    }

    public static TS date2Ts(Date value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new TS(DateUtil.formatDateTime(value));
    }

    public static TS date2TsDateOnly(Date value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new TS(DateUtil.formatDateOnly(value));
    }

    public static TS date2TsDateOnly(ZonedDateTime value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new TS(DateUtil.formatDateOnly(value));
    }

    public static TS date2TsTzon(Date value) {
        if (value == null) {
            return new IVLTS(NullFlavor.UNKNOWN_L1);
        }
        return new TS(DateUtil.formatDateTimeTzon(value));
    }

    public static String formatDateOnly(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_DATE_FORMAT);
        return sdf.format(value);
    }

    public static String formatDateOnly(ZonedDateTime value) {
        return value.format(DateTimeFormatter.ofPattern(SHORT_DATE_FORMAT));
    }

    public static String formatDateTime(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat(LONG_DATE_FORMAT);
        return sdf.format(value);
    }

    public static String formatDateTime(ZonedDateTime value) {
        return value.format(DateTimeFormatter.ofPattern(LONG_DATE_FORMAT).withZone(ZoneId.systemDefault()));
    }

    public static String formatDateTimeTzon(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssZ");
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(value);
    }

    public static String formatDateTimeTzon(ZonedDateTime value) {
        return value.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssZ").withZone(ZoneId.systemDefault()));
    }

    public static Date parseDate(ZonedDateTime date) {
        return Date.from(date.toInstant());
    }

    public static ZonedDateTime parseZonedDate(Date date) {
        return ZonedDateTime.from(date.toInstant().atZone(ZoneId.systemDefault()));
    }

    public static Date parseDate(String dateSt) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            return sdf.parse(dateSt);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Date parseDateAndTime(String dateSt) {
        try {
            SimpleDateFormat sdf = dateSt.length() > 16 ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("dd.MM.yyyy HH:mm");
            return sdf.parse(dateSt);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Date parseDateyyyyMM(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyyMM.", e);
        }
    }

    public static Date parseDateyyyyMMdd(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(SHORT_DATE_FORMAT);
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyyMMdd.", e);
        }
    }

    public static Date parseDateyyyyMMdd2(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyy-MM-dd.", e);
        }
    }

    public static Date parseDateyyyyMMddHHmm(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyyMMddHHmm.", e);
        }
    }

    public static Date parseDateyyyyMMddHHmmss(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(LONG_DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getDefault());
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyyMMddHHmmss.", e);
        }
    }

    public static Date parseDateyyyyMMddHHmmZ(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmZ");
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyyMMdd.", e);
        }
    }

    public static Date parseDateyyyyMMddHHmmZZZZ(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmZZZZ");
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyyMMddHHmmZZZZ.", e);
        }
    }

    public static Date parseDateyyyyMMddTHHmmss(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return sdf.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERRORMSG_CANNOT_PARSE_DATE_VAL + value + "]. Expected format is yyyy-MM-ddTHH:mm:ss.", e);
        }
    }

    public static boolean equalsDateOnly(Date validFrom, Date validFrom2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SHORT_DATE_FORMAT);
        String validFromStr = dateFormat.format(validFrom);
        String validFromStr2 = dateFormat.format(validFrom2);
        return validFromStr.equals(validFromStr2);
    }
}

