/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.enums.Ucum;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLINT;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVXBINT;
import org.projecthusky.common.hl7cdar2.IVXBPQ;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.QTY;
import org.projecthusky.common.hl7cdar2.RTO;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Reference;

public class Value {
    private static final String NAMESPACE_HL7_V3 = "urn:hl7-org:v3";
    private static final String NOT_YET_IMPLEMENTED_TEXT = "*** TODO: This is not yet implemented value type...";
    private final ANY mValue;

    public Value(ANY value) {
        this.mValue = value;
    }

    public Value(ANY value, NullFlavor nullFlavor) {
        this.mValue = value;
        if (nullFlavor != null) {
            this.mValue.nullFlavor = List.of(nullFlavor.getCodeValue());
        }
    }

    public Value(BigDecimal value) {
        this(new PQ());
        PQ pq = (PQ)this.mValue;
        pq.setValue(value.toString());
    }

    public Value(BigDecimal low, String lowUnit, BigDecimal high, String highUnit) {
        IVLPQ ivlPq = new IVLPQ();
        IVXBPQ mlow = new IVXBPQ();
        IVXBPQ mhigh = new IVXBPQ();
        if (low != null && high != null) {
            mlow.setValue(low.toString());
            mlow.setUnit(lowUnit);
            ivlPq.getRest().add((JAXBElement<? extends PQ>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "low", ""), IVXBPQ.class, (Object)mlow));
            mhigh.setValue(high.toString());
            mhigh.setUnit(highUnit);
            ivlPq.getRest().add((JAXBElement<? extends PQ>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "high", ""), IVXBPQ.class, (Object)mhigh));
        }
        this.mValue = ivlPq;
    }

    public Value(BigDecimal low, Ucum lowUnit, BigDecimal high, Ucum highUnit) {
        this(low, lowUnit.getCodeValue(), high, highUnit.getCodeValue());
    }

    public Value(BigInteger low, BigInteger high) {
        IVLINT ivlInt = new IVLINT();
        IVXBINT mlow = new IVXBINT();
        IVXBINT mhigh = new IVXBINT();
        if (low != null && high != null) {
            mlow.setValue(low);
            ivlInt.getRest().add((JAXBElement<? extends INT>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "low", ""), IVXBINT.class, (Object)mlow));
            mhigh.setValue(high);
            ivlInt.getRest().add((JAXBElement<? extends INT>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "high", ""), IVXBINT.class, (Object)mhigh));
        }
        this.mValue = ivlInt;
    }

    public Value(BL bl) {
        this.mValue = bl;
    }

    public Value(boolean code) {
        BL bl = new BL();
        bl.setValue(code);
        this.mValue = bl;
    }

    public Value(CD cd) {
        this.mValue = cd;
    }

    public Value(Code code) {
        this.mValue = code.getHl7CdaR2Cd();
    }

    public Value(Double value) {
        this(new PQ());
        PQ pq = (PQ)this.mValue;
        pq.setValue(value.toString());
    }

    public Value(Double low, Double high) {
        IVLPQ ivlPq = new IVLPQ();
        IVXBPQ mlow = new IVXBPQ();
        IVXBPQ mhigh = new IVXBPQ();
        if (low != null && high != null) {
            mlow.setValue(low.toString());
            mlow.setUnit("");
            ivlPq.getRest().add((JAXBElement<? extends PQ>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "low", ""), IVXBPQ.class, (Object)mlow));
            mhigh.setValue(high.toString());
            mhigh.setUnit("");
            ivlPq.getRest().add((JAXBElement<? extends PQ>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "high", ""), IVXBPQ.class, (Object)mhigh));
        }
        this.mValue = ivlPq;
    }

    public Value(Double low, Double high, String unit) {
        IVLPQ ivlPq = new IVLPQ();
        IVXBPQ mlow = new IVXBPQ();
        IVXBPQ mhigh = new IVXBPQ();
        if (low != null && high != null) {
            mlow.setValue(low.toString());
            mlow.setUnit(unit);
            ivlPq.getRest().add((JAXBElement<? extends PQ>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "low", ""), IVXBPQ.class, (Object)mlow));
            mhigh.setValue(high.toString());
            mhigh.setUnit(unit);
            ivlPq.getRest().add((JAXBElement<? extends PQ>)new JAXBElement(new QName(NAMESPACE_HL7_V3, "high", ""), IVXBPQ.class, (Object)mhigh));
        }
        this.mValue = ivlPq;
    }

    public Value(Double numerator, Double denominator, Ucum ucumUnit) {
        RTO rto = new RTO();
        PQ pq1 = new PQ();
        pq1.setUnit(ucumUnit.getCodeValue());
        pq1.setValue(numerator.toString());
        PQ pq2 = new PQ();
        pq2.setUnit(ucumUnit.getCodeValue());
        pq2.setValue(denominator.toString());
        rto.setNumerator(pq1);
        rto.setDenominator(pq2);
        this.mValue = rto;
    }

    public Value(ED ed) {
        this.mValue = ed;
    }

    public Value(int value) {
        this(new INT());
        this.setIntValue(value);
    }

    public Value(Integer value) {
        this(new INT());
        this.setIntValue(value);
    }

    public Value(PQ pq) {
        this.mValue = pq;
    }

    public Value(RTO rto) {
        this.mValue = rto;
    }

    public Value(ST value) {
        this.mValue = value;
    }

    public Value(String text) {
        this.mValue = new ED(text);
    }

    public Value(String value, boolean isText) {
        ED ed = !isText ? Reference.createReference(value) : new ED(value);
        this.mValue = ed;
    }

    public Value(String codeSystem, String code) {
        CD cd = new CD();
        cd.setCodeSystem(codeSystem);
        cd.setCode(code);
        this.mValue = cd;
    }

    public Value(String value, Ucum unit) {
        this(new PQ());
        this.setPqValue(value);
        this.setUcumUnit(unit);
    }

    public String getBlText() {
        BL bl;
        if (this.isBl() && (bl = (BL)this.mValue).isValue() != null) {
            return bl.isValue().toString();
        }
        return null;
    }

    public boolean getBoolean() {
        if (this.isBl()) {
            BL bl = (BL)this.mValue;
            return bl.isValue();
        }
        return false;
    }

    public Code getCode() {
        return new Code((CD)this.mValue);
    }

    public String getEdReferenceValue() {
        if (this.isEd()) {
            ED ed = (ED)this.mValue;
            return ed.getReference().getValue();
        }
        return null;
    }

    public String getEdText() {
        if (this.isEd()) {
            ED ed = (ED)this.mValue;
            return ed.getTextContent();
        }
        return null;
    }

    public String getIntText() {
        INT val;
        if (this.isInt() && (val = (INT)this.mValue).getValue() != null) {
            return val.getValue().toString();
        }
        return null;
    }

    public String getOriginalTextReference() {
        Code code = new Code((CD)this.mValue);
        return code.getOriginalText();
    }

    public void setOriginalTextReference(String originalText) {
        Object code;
        ANY aNY = this.mValue;
        if (aNY instanceof CD) {
            CD cd = (CD)aNY;
            code = new Code(cd);
            ((CodeBaseType)code).setOriginalText((String)originalText);
        }
        if ((code = this.mValue) instanceof ED) {
            ED ed = (ED)code;
            TEL tel = new TEL();
            if (!((String)originalText).startsWith("#")) {
                originalText = "#" + (String)originalText;
            }
            tel.setValue((String)originalText);
            ed.setReference(tel);
        }
    }

    public PQ getPhysicalQuantity() {
        return (PQ)this.mValue;
    }

    public BigDecimal getPhysicalQuantityIntervalHighValue() {
        if (this.isPhysicalQuantityInterval()) {
            IVLPQ ivlPq = (IVLPQ)this.mValue;
            Map<String, PQ> elements = this.getPqElement(ivlPq);
            return new BigDecimal(elements.get("high").getValue());
        }
        return null;
    }

    public Map<String, PQ> getPqElement(IVLPQ range) {
        HashMap<String, PQ> pqElements = new HashMap<String, PQ>();
        if (range != null) {
            for (JAXBElement<? extends PQ> pq : range.getRest()) {
                PQ value = this.extractPqValue(pq);
                String elementName = "";
                if (pq != null && pq.getName() != null) {
                    elementName = pq.getName().getLocalPart();
                }
                if (value == null || elementName == null) continue;
                pqElements.put(elementName, value);
            }
        }
        return pqElements;
    }

    private PQ extractPqValue(JAXBElement<? extends QTY> pq) {
        PQ value = new PQ();
        if (pq != null && PQ.class.equals((Object)pq.getDeclaredType()) && pq.getValue() != null) {
            value = (PQ)pq.getValue();
        }
        if (pq != null && IVXBPQ.class.equals((Object)pq.getDeclaredType()) && pq.getValue() != null) {
            value = (IVXBPQ)pq.getValue();
        }
        return value;
    }

    public BigDecimal getPhysicalQuantityIntervalLowValue() {
        if (this.isPhysicalQuantityInterval()) {
            IVLPQ ivlPq = (IVLPQ)this.mValue;
            Map<String, PQ> elements = this.getPqElement(ivlPq);
            return new BigDecimal(elements.get("low").getValue());
        }
        return null;
    }

    public String getPhysicalQuantityUnit() {
        if (this.isPhysicalQuantity()) {
            PQ pq = (PQ)this.mValue;
            return pq.getUnit();
        }
        return null;
    }

    public String getPhysicalQuantityValue() {
        if (this.isPhysicalQuantity()) {
            PQ pq = (PQ)this.mValue;
            return String.valueOf(pq.getValue());
        }
        return null;
    }

    public String getRtoUnitText() {
        if (this.isRto()) {
            RTO rto = (RTO)this.mValue;
            Object retVal = "";
            String denominatorUnit = "";
            String numeratorUnit = "";
            if (rto != null) {
                QTY numerator = rto.getNumerator();
                QTY denominator = rto.getDenominator();
                numeratorUnit = this.extractUnit(numerator);
                denominatorUnit = this.extractUnit(denominator);
            }
            retVal = numeratorUnit.equals(denominatorUnit) ? numeratorUnit : numeratorUnit + " / " + denominatorUnit;
            return retVal;
        }
        return null;
    }

    private String extractUnit(QTY numerator) {
        Object unit = "";
        if (numerator instanceof PQ) {
            PQ pq = (PQ)numerator;
            unit = pq.getUnit();
        }
        if (!((String)unit).isEmpty()) {
            unit = " " + (String)unit;
        }
        return unit;
    }

    public String getRtoValueText() {
        if (this.isRto()) {
            RTO rto = (RTO)this.mValue;
            Object retVal = "";
            String numeratorValue = "";
            String denominatorValue = "";
            if (rto != null) {
                PQ pq;
                QTY numerator = rto.getNumerator();
                QTY denominator = rto.getDenominator();
                if (numerator instanceof PQ) {
                    pq = (PQ)numerator;
                    numeratorValue = pq.getValue();
                } else {
                    numeratorValue = NOT_YET_IMPLEMENTED_TEXT;
                }
                if (denominator instanceof PQ) {
                    pq = (PQ)denominator;
                    denominatorValue = pq.getValue();
                } else {
                    denominatorValue = NOT_YET_IMPLEMENTED_TEXT;
                }
            }
            retVal = numeratorValue + " / " + denominatorValue;
            return retVal;
        }
        return null;
    }

    public ANY getValue() {
        return this.mValue;
    }

    public boolean isBl() {
        return this.mValue instanceof BL;
    }

    public boolean isCode() {
        return this.mValue instanceof CD;
    }

    public boolean isEd() {
        return this.mValue instanceof ED;
    }

    public boolean isInt() {
        return this.mValue instanceof INT;
    }

    public boolean isPhysicalQuantity() {
        return this.mValue instanceof PQ;
    }

    private boolean isPhysicalQuantityInterval() {
        return this.mValue instanceof IVLPQ;
    }

    public boolean isRto() {
        return this.mValue instanceof RTO;
    }

    public boolean isSt() {
        return this.mValue instanceof ST;
    }

    private void setIntValue(int value) {
        INT i = (INT)this.mValue;
        i.setValue(BigInteger.valueOf(value));
    }

    private void setPqValue(String value) {
        ANY aNY = this.mValue;
        if (aNY instanceof PQ) {
            PQ pq = (PQ)aNY;
            pq.setValue(value);
        }
    }

    public void setUcumUnit(String unit) {
        ANY aNY = this.mValue;
        if (aNY instanceof PQ) {
            PQ pq = (PQ)aNY;
            pq.setUnit(unit);
        }
    }

    private void setUcumUnit(Ucum unit) {
        PQ pq = (PQ)this.mValue;
        pq.setUnit(unit.getCodeValue());
    }

    public String toString() {
        Object resultText = "";
        if (this.isCode()) {
            if (this.getCode().getOriginalText() != null) {
                resultText = this.getCode().getOriginalText();
            }
            if ("".equals(resultText)) {
                resultText = this.getCode().getDisplayName();
            }
        } else {
            resultText = this.isPhysicalQuantity() ? this.getPhysicalQuantityValue() + " " + this.getPhysicalQuantityUnit() : (this.isEd() ? this.getEdText() : (this.isBl() ? this.getBlText() : (this.isRto() ? this.getRtoValueText() + " " + this.getRtoUnitText() : (this.isInt() ? this.getIntText() : NOT_YET_IMPLEMENTED_TEXT))));
        }
        if (resultText == null) {
            resultText = "";
        }
        resultText = ((String)resultText).replace("&lt;", "<");
        resultText = ((String)resultText).replace("&gt;", ">");
        return resultText;
    }
}

