/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.common.hl7cdar2.TEL;

public class Telecoms {
    public static final String TELECOMS_EMAIL_PREFIX = "mailto:";
    public static final String TELECOMS_FAX_PREFIX = "fax:";
    public static final String TELECOMS_PHONE_PREFIX = "tel:";
    public static final String TELECOMS_WEBSITE_PREFIX = "http";
    private List<TEL> mTels = new ArrayList<TEL>();

    public Telecoms() {
    }

    public Telecoms(List<TEL> telecoms) {
        this();
        for (TEL tel : telecoms) {
            this.mTels.add(tel);
        }
    }

    public void add(String type, String endpointIdentifier, TelecomAddressUse usage) {
        TEL tel = null;
        if (type.equals(TELECOMS_EMAIL_PREFIX) || type.equals(TELECOMS_EMAIL_PREFIX.substring(0, TELECOMS_EMAIL_PREFIX.length() - 1))) {
            tel = this.createTel(endpointIdentifier, usage);
        }
        if (type.equals(TELECOMS_FAX_PREFIX) || type.equals(TELECOMS_FAX_PREFIX.substring(0, TELECOMS_FAX_PREFIX.length() - 1))) {
            tel = this.createTel(endpointIdentifier, usage);
        }
        if (type.equals(TELECOMS_PHONE_PREFIX) || type.equals(TELECOMS_PHONE_PREFIX.substring(0, TELECOMS_PHONE_PREFIX.length() - 1))) {
            tel = this.createTel(endpointIdentifier, usage);
        }
        if (type.equals(TELECOMS_WEBSITE_PREFIX) || type.equals(TELECOMS_WEBSITE_PREFIX.substring(0, TELECOMS_WEBSITE_PREFIX.length() - 1))) {
            tel = this.createTel(endpointIdentifier, usage);
        }
        this.mTels.add(tel);
    }

    public TEL createTel(String telNr, TelecomAddressUse usage) {
        TEL tel = new TEL();
        if (usage != null) {
            tel.getUse().add(usage.getCodeValue());
        }
        tel.setValue(TELECOMS_PHONE_PREFIX + telNr.replaceAll("\\s+", ""));
        return tel;
    }

    public void addEMail(String eMail, TelecomAddressUse usage) {
        this.mTels.add(this.createEMail(eMail, usage));
    }

    public TEL createEMail(String eMail, TelecomAddressUse usage) {
        TEL tel = new TEL();
        if (usage != null) {
            tel.getUse().add(usage.getCodeValue());
        }
        tel.setValue(TELECOMS_EMAIL_PREFIX + eMail);
        return tel;
    }

    public void addFax(String fax, TelecomAddressUse usage) {
        this.mTels.add(this.createTel(fax, usage));
    }

    public void addPhone(String phoneNr, TelecomAddressUse usage) {
        this.mTels.add(this.createTel(phoneNr, usage));
    }

    public void addWebsite(String url, TelecomAddressUse usage) {
        TEL t = new TEL();
        t.getUse().add(usage.getCodeValue());
        t.setValue(url);
        this.mTels.add(t);
    }

    public Map<String, TelecomAddressUse> getEMails() {
        return new HashMap<String, TelecomAddressUse>();
    }

    public Map<String, TelecomAddressUse> getFaxes() {
        return new HashMap<String, TelecomAddressUse>();
    }

    public List<TEL> getMdhtTelecoms() {
        return this.mTels;
    }

    public Map<String, TelecomAddressUse> getPhones() {
        return new HashMap<String, TelecomAddressUse>();
    }

    public Map<String, TelecomAddressUse> getTelecoms() {
        HashMap<String, TelecomAddressUse> pm = new HashMap<String, TelecomAddressUse>();
        for (TEL mName : this.mTels) {
            pm.put(mName.getValue(), TelecomAddressUse.getEnum(mName.getUse().get(0)));
        }
        return pm;
    }

    public Map<String, TelecomAddressUse> getWebsites() {
        return new HashMap<String, TelecomAddressUse>();
    }
}

