/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import org.projecthusky.common.basetypes.TelecomBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.common.hl7cdar2.TEL;

public class Telecom
extends TelecomBaseType {
    private static final long serialVersionUID = -8468062608880568287L;

    public Telecom() {
    }

    public Telecom(TEL hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Telecom(TelecomBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public static TEL createHl7CdaR2Tel(TelecomBaseType baseType) {
        TEL retVal = null;
        if (baseType != null) {
            retVal = new TEL();
            NullFlavor nf = baseType.getNullFlavor();
            if (nf != null) {
                if (retVal.nullFlavor == null) {
                    retVal.nullFlavor = new ArrayList();
                }
                retVal.nullFlavor.add(nf.getCodeValue());
            } else {
                String value;
                TelecomAddressUse usage = baseType.getUsage();
                if (usage != null) {
                    retVal.getUse().add(usage.getCodeValue());
                }
                if ((value = baseType.getValue()) != null) {
                    retVal.setValue(value);
                }
            }
        }
        return retVal;
    }

    public static TelecomBaseType createTelecomBaseType(TEL hl7CdaR2Value) {
        TelecomBaseType retVal = new TelecomBaseType();
        if (hl7CdaR2Value != null) {
            String usage = null;
            String nullFlavor = null;
            if (hl7CdaR2Value.nullFlavor != null && !hl7CdaR2Value.nullFlavor.isEmpty()) {
                nullFlavor = (String)hl7CdaR2Value.nullFlavor.get(0);
            }
            if (nullFlavor != null) {
                retVal.setNullFlavor(NullFlavor.getEnum(nullFlavor));
            } else {
                if (!hl7CdaR2Value.getUse().isEmpty()) {
                    usage = hl7CdaR2Value.getUse().get(0);
                }
                if (usage != null) {
                    retVal.setUsage(TelecomAddressUse.getEnum(usage));
                }
                retVal.setValue(hl7CdaR2Value.getValue());
            }
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    public TEL getHl7CdaR2Tel() {
        return Telecom.createHl7CdaR2Tel(this);
    }

    private void initFromBaseType(TelecomBaseType baseType) {
        if (baseType != null) {
            this.setUsage(baseType.getUsage());
            this.setValue(baseType.getValue());
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(TEL hl7CdaR2Value) {
        this.initFromBaseType(Telecom.createTelecomBaseType(hl7CdaR2Value));
    }

    public void set(TEL hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public void set(TelecomBaseType baseType) {
        this.initFromBaseType(baseType);
    }
}

