/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import javax.xml.bind.JAXBElement;
import org.projecthusky.common.enums.ObservationInterpretation;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.POCDMT000040ReferenceRange;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.model.ObservationRange;
import org.projecthusky.common.model.Value;

public class ReferenceRange
extends ObservationRange {
    private POCDMT000040ReferenceRange mRr;

    public ReferenceRange() {
        this.mRr = new POCDMT000040ReferenceRange();
        this.mRr.setObservationRange(this.getObsR());
        this.mRr.getTypeCode().clear();
        this.mRr.getTypeCode().add("REFV");
        this.setInterpretation(ObservationInterpretation.NORMAL);
    }

    public ReferenceRange(POCDMT000040ReferenceRange mdht) {
        super(mdht.getObservationRange());
        this.mRr = mdht;
    }

    public ReferenceRange(Value value, ObservationInterpretation interpretationCode) {
        this();
        this.setValue(value);
        this.setInterpretation(interpretationCode);
    }

    public POCDMT000040ReferenceRange getMdht() {
        return this.mRr;
    }

    public String toNarrativeString() {
        String retVal = "";
        String value = "";
        IVLPQ tempIvl = null;
        if (this.mRr != null && this.mRr.getObservationRange() != null && this.mRr.getObservationRange().getValue() != null) {
            ANY obj;
            ANY aNY = this.mRr.getObservationRange().getValue();
            if (aNY instanceof IVLPQ) {
                obj = (IVLPQ)aNY;
                tempIvl = obj;
            }
            if ((aNY = this.mRr.getObservationRange().getValue()) instanceof BL) {
                obj = (BL)aNY;
                value = ((BL)obj).isValue().toString();
            }
        }
        if (tempIvl != null) {
            value = this.extractValueFromIvlpq(tempIvl);
        }
        if (!value.isEmpty()) {
            retVal = value;
        }
        return retVal;
    }

    private String extractValueFromIvlpq(IVLPQ tempIvl) {
        String lowValue = "";
        Object lowUnit = "";
        String highValue = "";
        Object highUnit = "";
        for (JAXBElement<? extends PQ> pqEl : tempIvl.getRest()) {
            if (pqEl == null || pqEl.getName() == null) continue;
            if ("low".equalsIgnoreCase(pqEl.getName().getLocalPart())) {
                lowValue = tempIvl.getValue();
                lowUnit = tempIvl.getUnit();
                continue;
            }
            if (!"high".equalsIgnoreCase(pqEl.getName().getLocalPart())) continue;
            highValue = tempIvl.getValue();
            highUnit = tempIvl.getUnit();
        }
        if (((String)lowUnit).isEmpty()) {
            lowUnit = tempIvl.getUnit();
        }
        if (((String)highUnit).isEmpty()) {
            highUnit = tempIvl.getUnit();
        }
        if (!((String)lowUnit).isEmpty()) {
            lowUnit = " " + (String)lowUnit;
        }
        if (!((String)highUnit).isEmpty()) {
            highUnit = " " + (String)highUnit;
        }
        String retVal = ((String)lowUnit).equals(highUnit) ? lowValue + " - " + highValue + (String)lowUnit : lowValue + (String)lowUnit + " - " + highValue + (String)highUnit;
        return retVal;
    }
}

