/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.TEL;

public class Reference {
    private static final long serialVersionUID = 6963042793314704003L;
    private NullFlavor nullFlavor;
    private String value;
    private List<String> narrativeText;

    public Reference() {
    }

    public Reference(String value, List<String> narrativeText) {
        this.value = value;
        if (narrativeText != null) {
            this.narrativeText = narrativeText;
        }
    }

    public Reference(ED hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public static Reference createReferenceType(ED hl7CdaR2Value) {
        Reference retVal = new Reference();
        if (hl7CdaR2Value != null) {
            String nullFlavor = null;
            if (hl7CdaR2Value.nullFlavor != null && !hl7CdaR2Value.nullFlavor.isEmpty()) {
                nullFlavor = (String)hl7CdaR2Value.nullFlavor.get(0);
            }
            if (nullFlavor != null) {
                retVal.setNullFlavor(NullFlavor.getEnum(nullFlavor));
            }
            if (hl7CdaR2Value.getReference() != null) {
                retVal.setValue(hl7CdaR2Value.getReference().getValue());
            }
            if (hl7CdaR2Value.getXmlMixed() != null) {
                retVal.setNarrativeText(hl7CdaR2Value.getXmlMixed());
            }
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    public static ED createHl7CdaR2Ed(Reference baseType) {
        ED retVal = null;
        if (baseType != null) {
            retVal = new ED();
            NullFlavor nf = baseType.getNullFlavor();
            if (nf != null) {
                if (retVal.nullFlavor == null) {
                    retVal.nullFlavor = new ArrayList();
                }
                retVal.nullFlavor.add(nf.getCodeValue());
            } else {
                String value = baseType.getValue();
                if (value != null) {
                    TEL tel = new TEL();
                    tel.setValue(value);
                    retVal.setReference(tel);
                }
                if (baseType.getNarrativeText() != null) {
                    retVal.setXmlMixed(baseType.getNarrativeText());
                }
            }
        }
        return retVal;
    }

    public static ED createReference(ED existingText, String reference) {
        ED ed = existingText;
        if (ed == null) {
            ed = new ED();
        }
        ed.setReference(Reference.createReferenceTel(reference));
        return ed;
    }

    public static ED createReference(int contentId, String prefix) {
        ED text = new ED();
        TEL tel = new TEL();
        tel.setValue("#" + prefix + contentId);
        text.setReference(tel);
        return text;
    }

    public static ED createReference(String reference) {
        ED ed = new ED();
        ed.setReference(Reference.createReferenceTel(reference));
        return ed;
    }

    public static ED createReference(String url, String narrativeText) {
        TEL tel = new TEL();
        ED ed = new ED();
        tel.setValue(url);
        ed.setXmlMixed(narrativeText);
        ed.setReference(tel);
        return ed;
    }

    public static TEL createReferenceTel(String value) {
        TEL tel = new TEL();
        if (!((String)value).startsWith("#")) {
            value = "#" + (String)value;
        }
        tel.setValue((String)value);
        return tel;
    }

    public ED getHl7CdaR2Ed() {
        return Reference.createHl7CdaR2Ed(this);
    }

    private void init(Reference baseType) {
        if (baseType != null) {
            this.setValue(baseType.getValue());
            this.setNarrativeText(baseType.getNarrativeText());
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(ED hl7CdaR2Value) {
        this.init(Reference.createReferenceType(hl7CdaR2Value));
    }

    public void set(Reference baseType) {
        this.init(baseType);
    }

    public void set(ED hl7CdaR2Value) {
        this.init(Reference.createReferenceType(hl7CdaR2Value));
    }

    public NullFlavor getNullFlavor() {
        return this.nullFlavor;
    }

    public void setNullFlavor(NullFlavor nullFlavor) {
        this.nullFlavor = nullFlavor;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<String> getNarrativeText() {
        return this.narrativeText;
    }

    public void setNarrativeText(List<String> narrativeText) {
        this.narrativeText = narrativeText;
    }
}

