/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.POCDMT000040Person;
import org.projecthusky.common.model.Name;

public class Person {
    private POCDMT000040Person mPerson;

    public Person() {
        this.mPerson = new POCDMT000040Person();
    }

    public Person(Name name) {
        this.mPerson = new POCDMT000040Person();
        this.mPerson.getName().add(name.getHl7CdaR2Pn());
    }

    public Person(POCDMT000040Person person) {
        this.mPerson = person;
    }

    public Person(org.openehealth.ipf.commons.ihe.xds.core.metadata.Person person) {
        this();
        this.setIpfPerson(person);
    }

    public void addName(Name name) {
        this.mPerson.getName().add(name.getHl7CdaR2Pn());
    }

    public String getCompleteName() {
        String retVal = "";
        if (!this.mPerson.getName().isEmpty()) {
            Name name = new Name(this.mPerson.getName().get(0));
            retVal = name.getFullName();
        }
        return retVal;
    }

    public POCDMT000040Person getHl7CdaPerson() {
        return this.mPerson;
    }

    public Name getName() {
        return new Name(this.mPerson.getName().get(0));
    }

    public List<Name> getNames() {
        ArrayList<Name> nl = new ArrayList<Name>();
        for (PN mName : this.mPerson.getName()) {
            nl.add(new Name(mName));
        }
        return nl;
    }

    public org.openehealth.ipf.commons.ihe.xds.core.metadata.Person getIpfPerson() {
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Person person = new org.openehealth.ipf.commons.ihe.xds.core.metadata.Person();
        if (!this.mPerson.getName().isEmpty()) {
            person.setName((org.openehealth.ipf.commons.ihe.xds.core.metadata.Name)Name.getIpfXpnName(this.mPerson.getName().get(0)));
        }
        return person;
    }

    public void setIpfPerson(org.openehealth.ipf.commons.ihe.xds.core.metadata.Person ipfPerson) {
        if (ipfPerson != null && ipfPerson.getName() != null) {
            Name persName = new Name(ipfPerson.getName());
            this.mPerson.getName().add(persName.getHl7CdaR2Pn());
        }
    }
}

