/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.projecthusky.common.basetypes.IdentificatorBaseType;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedEntity;
import org.projecthusky.common.hl7cdar2.POCDMT000040Performer2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Person;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Person;
import org.projecthusky.common.model.Telecom;
import org.projecthusky.common.utils.time.DateTimes;

public class Performer {
    private final POCDMT000040Performer2 mPerfomer;
    private final POCDMT000040AssignedEntity mAsEntity;
    private POCDMT000040Person mPerson;

    public Performer() {
        this.mPerfomer = new POCDMT000040Performer2();
        this.mAsEntity = new POCDMT000040AssignedEntity();
        this.mPerson = new POCDMT000040Person();
        this.mAsEntity.setAssignedPerson(this.mPerson);
        this.mPerfomer.setAssignedEntity(this.mAsEntity);
        this.setTimeValue(new Date());
    }

    public Performer(Author author) {
        this();
        this.addName(author.getName());
        for (Identificator id : author.getIds()) {
            this.mAsEntity.getId().add(id.getHl7CdaR2Ii());
        }
        this.setTimeValue(author.getTimeAsDate());
        if (author.getOrganization() != null) {
            this.setOrganization(author.getOrganization());
        }
    }

    public Performer(Name name) {
        this();
        this.addName(name);
    }

    public Performer(Name name, String gln) {
        this(name);
        II id = new II();
        id.setRoot(CodeSystems.GLN.getCodeSystemId());
        id.setExtension(gln);
        this.mAsEntity.getId().add(id);
    }

    public Performer(POCDMT000040Performer2 performerMdht) {
        this.mPerfomer = performerMdht;
        this.mAsEntity = performerMdht.getAssignedEntity();
        this.mPerson = performerMdht.getAssignedEntity().getAssignedPerson();
    }

    public Performer(Organization organization) {
        this.mPerfomer = new POCDMT000040Performer2();
        this.mAsEntity = new POCDMT000040AssignedEntity();
        this.mPerfomer.setAssignedEntity(this.mAsEntity);
        this.setTimeValue(new Date());
        this.setOrganization(organization);
        for (IdentificatorBaseType idBaseType : organization.getIdentificatorList()) {
            if (idBaseType == null) continue;
            this.mAsEntity.getId().add(new Identificator(idBaseType).getHl7CdaR2Ii());
        }
    }

    public Performer(Person person) {
        this();
        this.addName(person.getName());
    }

    public void addAddress(Address address) {
        this.mAsEntity.getAddr().add(address.getHl7CdaR2Ad());
    }

    public void addId(Identificator identificator) {
        this.mAsEntity.getId().add(identificator.getHl7CdaR2Ii());
    }

    public void addName(Name name) {
        this.mAsEntity.getAssignedPerson().getName().add(name.getHl7CdaR2Pn());
    }

    public POCDMT000040Performer2 getHl7Cdar2Perfomer() {
        return this.mPerfomer;
    }

    public Address getAddress() {
        return new Address(this.mAsEntity.getAddr().get(0));
    }

    public List<Address> getAddresses() {
        ArrayList<Address> al = new ArrayList<Address>();
        for (AD mAddress : this.mAsEntity.getAddr()) {
            al.add(new Address(mAddress));
        }
        return al;
    }

    public String getCompleteName() {
        String retVal = "";
        if (this.mAsEntity != null && this.mAsEntity.getAssignedPerson() != null) {
            if (!this.mAsEntity.getAssignedPerson().getName().isEmpty()) {
                Name name = new Name(this.mAsEntity.getAssignedPerson().getName().get(0));
                retVal = name.getFullName();
            } else if (this.mAsEntity.getRepresentedOrganization() != null && !this.mAsEntity.getRepresentedOrganization().getName().isEmpty()) {
                Name name = new Name(this.mAsEntity.getRepresentedOrganization().getName().get(0));
                retVal = name.getFullName();
            }
        }
        return retVal;
    }

    public String getGln() {
        for (II id : this.mAsEntity.getId()) {
            if (id == null || !CodeSystems.GLN.getCodeSystemId().equalsIgnoreCase(id.getRoot())) continue;
            return id.getExtension();
        }
        return null;
    }

    public void setGln(String gln) {
        this.addId(new Identificator(CodeSystems.GLN.getCodeSystemId(), gln));
    }

    public Identificator getGlnAsIdentificator() {
        II ii = this.mAsEntity.getId().get(0);
        return new Identificator(ii);
    }

    public List<Identificator> getIds() {
        return Identificator.getIdentificatorList(this.mAsEntity.getId());
    }

    public Name getName() {
        return new Name(this.mAsEntity.getAssignedPerson().getName().get(0));
    }

    public List<Name> getNames() {
        ArrayList<Name> nl = new ArrayList<Name>();
        for (PN mName : this.mAsEntity.getAssignedPerson().getName()) {
            nl.add(new Name(mName));
        }
        return nl;
    }

    public Organization getOrganization() {
        return new Organization(this.mAsEntity.getRepresentedOrganization());
    }

    public void setOrganization(Organization organization) {
        this.mAsEntity.setRepresentedOrganization(organization.getHl7CdaR2Pocdmt000040Organization());
    }

    public List<Telecom> getTelecoms() {
        LinkedList<Telecom> telecoms = new LinkedList<Telecom>();
        for (TEL tel : this.mAsEntity.getTelecom()) {
            if (tel == null) continue;
            telecoms.add(new Telecom(tel));
        }
        return telecoms;
    }

    public void setTelecoms(List<TEL> telecoms) {
        this.mAsEntity.getTelecom().addAll(telecoms);
    }

    public IVLTS getTimeAsIVLTS() {
        return new IVLTS(Optional.ofNullable(this.mPerfomer.getTime()).map(TS::getValue).orElse(null));
    }

    public void setTimeValue(Date eurDate) {
        if (eurDate == null) {
            this.mPerfomer.setTime(new IVLTS(NullFlavor.UNKNOWN_L1));
        } else {
            this.mPerfomer.setTime(new IVLTS(DateTimes.toHl7Dtm(eurDate.toInstant())));
        }
    }
}

