/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.enums.AdministrativeGender;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.POCDMT000040Patient;
import org.projecthusky.common.hl7cdar2.POCDMT000040PatientRole;
import org.projecthusky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Person;
import org.projecthusky.common.model.Telecom;
import org.projecthusky.common.utils.time.DateTimes;

public class Patient
extends Person {
    private final POCDMT000040RecordTarget mRecordTarget;
    protected POCDMT000040PatientRole mPatientRole;
    protected POCDMT000040Patient mPatient;
    private Boolean isNonHumenSubject = false;
    private Boolean multipleBirthInd;
    private Integer multipleBirthOrderNumber;
    private Boolean deceasedInd;
    private Date deceasedTime;
    private String mothersMaidenName;
    private String nation;
    private String employeeOccupation;
    private String religiousAffiliation;

    public Patient() {
        this.mRecordTarget = new POCDMT000040RecordTarget();
        this.mPatientRole = new POCDMT000040PatientRole();
        this.mPatient = new POCDMT000040Patient();
        this.mPatientRole.setPatient(this.mPatient);
        this.mRecordTarget.setPatientRole(this.mPatientRole);
    }

    public Patient(Name name, AdministrativeGender sex, Calendar birthDay) {
        this();
        if (sex != null) {
            this.mPatient.setAdministrativeGenderCode(sex.getCE());
        }
        this.mPatient.getName().add(name.getHl7CdaR2Pn());
        if (birthDay != null) {
            this.mPatient.setBirthTime(DateTimes.toDateTs(birthDay.toInstant(), birthDay.getTimeZone().toZoneId()));
        }
    }

    public Patient(Name name, AdministrativeGender sex, Calendar birthDay, Identificator id) {
        this.mRecordTarget = new POCDMT000040RecordTarget();
        this.mPatientRole = new POCDMT000040PatientRole();
        this.mPatient = new POCDMT000040Patient();
        this.mPatientRole.setPatient(this.mPatient);
        this.mRecordTarget.setPatientRole(this.mPatientRole);
        this.setAdministrativeGender(sex);
        this.addName(name);
        this.setBirthday(birthDay);
        this.addId(id);
    }

    public Patient(POCDMT000040RecordTarget recordTarget) {
        this.mRecordTarget = recordTarget;
        this.mPatientRole = recordTarget.getPatientRole();
        this.mPatient = recordTarget.getPatientRole().getPatient();
    }

    public void addAddress(Address address) {
        this.mPatientRole.getAddr().add(address.getHl7CdaR2Ad());
    }

    public void addId(Identificator identificator) {
        II id = new II();
        id.setRoot(identificator.getRoot());
        id.setExtension(identificator.getExtension());
        this.mPatientRole.getId().add(id);
    }

    public void setIds(List<Identificator> identificators) {
        for (Identificator identificator : identificators) {
            if (identificator == null) continue;
            II id = new II();
            id.setRoot(identificator.getRoot());
            id.setExtension(identificator.getExtension());
            this.mPatientRole.getId().add(id);
        }
    }

    @Override
    public void addName(Name name) {
        this.mPatient.getName().add(name.getHl7CdaR2Pn());
    }

    public Address getAddress() {
        AD mAd = this.mPatientRole.getAddr().get(0);
        return new Address(mAd);
    }

    public List<Address> getAddresses() {
        ArrayList<Address> al = new ArrayList<Address>();
        for (AD mAddress : this.mPatientRole.getAddr()) {
            al.add(new Address(mAddress));
        }
        return al;
    }

    public AdministrativeGender getAdministrativeGenderCode() {
        CE code = this.getMdhtPatient().getAdministrativeGenderCode();
        if (code == null) {
            return null;
        }
        return AdministrativeGender.getEnum(code.getCode());
    }

    public Date getBirthday() {
        try {
            TS birthTime = this.getMdhtPatient().getBirthTime();
            if (birthTime == null) {
                return null;
            }
            String value = birthTime.getValue();
            return this.parseDate(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot convert birthdate", e);
        }
    }

    public LocalDate getBirthdayAsLocalDate() {
        TS birthTime = this.getMdhtPatient().getBirthTime();
        if (birthTime == null) {
            return null;
        }
        return DateTimes.toLocalDate(birthTime);
    }

    public void setBirthday(Calendar birthDay) {
        this.mPatient.setBirthTime(DateTimes.toDateTs(birthDay.toInstant(), birthDay.getTimeZone().toZoneId()));
    }

    public void setBirthday(ZonedDateTime birthDay) {
        this.mPatient.setBirthTime(DateTimes.toDateTs(birthDay));
    }

    @Override
    public String getCompleteName() {
        String retVal = "";
        if (!this.mPatient.getName().isEmpty()) {
            Name name = new Name(this.mPatient.getName().get(0));
            retVal = name.getFullName();
        }
        return retVal;
    }

    public Boolean getDeceasedInd() {
        return this.deceasedInd;
    }

    public void setDeceasedInd(Boolean deceasedInd) {
        this.deceasedInd = deceasedInd;
    }

    public Date getDeceasedTime() {
        return this.deceasedTime;
    }

    public void setDeceasedTime(Date deceasedTime) {
        this.deceasedTime = deceasedTime;
    }

    public String getEmployeeOccupation() {
        return this.employeeOccupation;
    }

    public void setEmployeeOccupation(String employeeOccupation) {
        this.employeeOccupation = employeeOccupation;
    }

    public List<Identificator> getIds() {
        LinkedList<Identificator> ids = new LinkedList<Identificator>();
        for (II id : this.mPatientRole.getId()) {
            ids.add(new Identificator(id));
        }
        return ids;
    }

    public POCDMT000040Patient getMdhtPatient() {
        return this.mPatient;
    }

    public POCDMT000040PatientRole getMdhtPatientRole() {
        return this.mPatientRole;
    }

    public POCDMT000040RecordTarget getMdhtRecordTarget() {
        return this.mRecordTarget;
    }

    public String getMothersMaidenName() {
        return this.mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public Boolean getMultipleBirthInd() {
        return this.multipleBirthInd;
    }

    public void setMultipleBirthInd(Boolean multipleBirthInd) {
        this.multipleBirthInd = multipleBirthInd;
    }

    public Integer getMultipleBirthOrderNumber() {
        return this.multipleBirthOrderNumber;
    }

    public void setMultipleBirthOrderNumber(Integer multipleBirthOrderNumber) {
        this.multipleBirthOrderNumber = multipleBirthOrderNumber;
    }

    @Override
    public Name getName() {
        return new Name(this.mPatient.getName().get(0));
    }

    @Override
    public List<Name> getNames() {
        ArrayList<Name> nl = new ArrayList<Name>();
        for (PN mName : this.mPatient.getName()) {
            nl.add(new Name(mName));
        }
        return nl;
    }

    public String getNation() {
        return this.nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public Organization getProviderOrganization() {
        return new Organization(this.mPatientRole.getProviderOrganization());
    }

    public void setProviderOrganization(Organization organization) {
        this.mPatientRole.setProviderOrganization(organization.getHl7CdaR2Pocdmt000040Organization());
    }

    public String getReligiousAffiliation() {
        return this.religiousAffiliation;
    }

    public void setReligiousAffiliation(String religiousAffiliation) {
        this.religiousAffiliation = religiousAffiliation;
    }

    public List<Telecom> getTelecoms() {
        LinkedList<Telecom> telecoms = new LinkedList<Telecom>();
        for (TEL tel : this.mPatientRole.getTelecom()) {
            telecoms.add(new Telecom(tel));
        }
        return telecoms;
    }

    public void setTelecoms(List<Telecom> telecoms) {
        for (Telecom tel : telecoms) {
            if (tel == null) continue;
            this.mPatientRole.getTelecom().add(tel.getHl7CdaR2Tel());
        }
    }

    public Boolean isNonHumenSubject() {
        return this.isNonHumenSubject;
    }

    private Date parseDate(String value) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.parse(value);
    }

    public void setAdministrativeGender(AdministrativeGender sex) {
        this.mPatient.setAdministrativeGenderCode(sex.getCE());
    }

    public void setIsHumanPatient() {
        this.isNonHumenSubject = false;
    }

    public void setIsNonHumenSubject() {
        this.isNonHumenSubject = true;
    }
}

