/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.POCDMT000040ParticipantRole;
import org.projecthusky.common.hl7cdar2.POCDMT000040PlayingEntity;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.PlayingEntity;
import org.projecthusky.common.model.Telecom;

public class ParticipantRole {
    private POCDMT000040ParticipantRole mParticipantRole;

    public ParticipantRole() {
        this.mParticipantRole = new POCDMT000040ParticipantRole();
    }

    public ParticipantRole(POCDMT000040ParticipantRole mdht) {
        this.mParticipantRole = mdht;
    }

    public void addAddress(Address address) {
        this.mParticipantRole.getAddr().add(address.getHl7CdaR2Ad());
    }

    public void addId(Identificator id) {
        this.mParticipantRole.getId().add(id.getHl7CdaR2Ii());
    }

    public List<Address> getAddresses() {
        ArrayList<Address> al = new ArrayList<Address>();
        for (AD mAddress : this.mParticipantRole.getAddr()) {
            al.add(new Address(mAddress));
        }
        return al;
    }

    public List<String> getClassCode() {
        return this.mParticipantRole.getClassCode();
    }

    public void setClassCode(String classCode) {
        this.mParticipantRole.getClassCode().clear();
        this.mParticipantRole.getClassCode().add(classCode);
    }

    public List<Identificator> getIdList() {
        return Identificator.getIdentificatorList(this.mParticipantRole.getId());
    }

    public POCDMT000040ParticipantRole getMdht() {
        return this.mParticipantRole;
    }

    public POCDMT000040PlayingEntity getPlayingEntity() {
        return this.mParticipantRole.getPlayingEntity();
    }

    public void setPlayingEntity(PlayingEntity playingEntity) {
        this.mParticipantRole.setPlayingEntity(playingEntity.getPlayingEntity());
    }

    public List<Telecom> getTelecoms() {
        LinkedList<Telecom> telecoms = new LinkedList<Telecom>();
        for (TEL tel : this.mParticipantRole.getTelecom()) {
            if (tel == null) continue;
            telecoms.add(new Telecom(tel));
        }
        return telecoms;
    }

    public void setTelecoms(List<Telecom> telecoms) {
        for (Telecom telecom : telecoms) {
            if (telecom == null) continue;
            this.mParticipantRole.getTelecom().add(telecom.getHl7CdaR2Tel());
        }
    }
}

