/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.model.ParticipantRole;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class Participant {
    private POCDMT000040Participant2 mParticipant;

    public Participant() {
        this.mParticipant = new POCDMT000040Participant2();
    }

    public Participant(POCDMT000040Participant2 mdht) {
        this.mParticipant = mdht;
    }

    public POCDMT000040Participant2 getMdht() {
        return this.mParticipant;
    }

    public ParticipantRole getParticipantRole() {
        return new ParticipantRole(this.mParticipant.getParticipantRole());
    }

    public void setParticipantRole(ParticipantRole p) {
        this.mParticipant.setParticipantRole(p.getMdht());
    }

    public @Nullable Hl7Dtm getTimeAsHl7Dtm() {
        if (this.mParticipant.getTime() != null && this.mParticipant.getTime().getValue() != null) {
            return Hl7Dtm.fromHl7(this.mParticipant.getTime().getValue());
        }
        return null;
    }

    public @Nullable Instant getTimeAsInstant() {
        return Optional.ofNullable(this.getTimeAsHl7Dtm()).map(Hl7Dtm::toInstant).orElse(Hl7Dtm.now().toInstant());
    }

    public Date getTime() {
        return Optional.ofNullable(this.getTimeAsInstant()).map(Date::from).orElse(null);
    }

    public void setTime(Date date) {
        if (date == null) {
            this.mParticipant.setTime(new IVLTS(NullFlavor.UNKNOWN_L1));
        } else {
            this.mParticipant.setTime(new IVLTS(DateTimes.toHl7Dtm(date.toInstant())));
        }
    }

    public List<String> getTypeCode() {
        return this.mParticipant.getTypeCode();
    }

    public void setTypeCode(String typeCode) {
        this.mParticipant.getTypeCode().clear();
        this.mParticipant.getTypeCode().add(typeCode);
    }
}

