/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.basetypes.IdentificatorBaseType;
import org.projecthusky.common.basetypes.NameBaseType;
import org.projecthusky.common.basetypes.OrganizationBaseType;
import org.projecthusky.common.basetypes.TelecomBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ON;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedAuthor;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedCustodian;
import org.projecthusky.common.hl7cdar2.POCDMT000040Custodian;
import org.projecthusky.common.hl7cdar2.POCDMT000040CustodianOrganization;
import org.projecthusky.common.hl7cdar2.POCDMT000040InformationRecipient;
import org.projecthusky.common.hl7cdar2.POCDMT000040IntendedRecipient;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organization;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Telecom;

public class Organization
extends OrganizationBaseType {
    private static final long serialVersionUID = 3468258613512445510L;

    public Organization(POCDMT000040CustodianOrganization hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Organization(POCDMT000040Organization hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Organization(OrganizationBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public static ON createHl7CdaR2On(NameBaseType baseType) {
        ON retVal = new ON();
        NullFlavor nf = baseType.getNullFlavor();
        if (nf != null) {
            if (retVal.nullFlavor == null) {
                retVal.nullFlavor = new ArrayList();
            }
            retVal.nullFlavor.add(nf.getCodeValue());
        } else {
            retVal.setXmlMixed(baseType.getName());
            if (baseType.getUsage() == null) {
                retVal.getUse().add("L");
            } else {
                retVal.getUse().add(baseType.getUsage().getCodeValue());
            }
        }
        return retVal;
    }

    public static OrganizationBaseType createOrganizationBaseType(POCDMT000040CustodianOrganization hl7CdaR2Value) {
        OrganizationBaseType retVal = new OrganizationBaseType();
        if (hl7CdaR2Value != null) {
            retVal.addAddress(Address.createAddressBaseType(hl7CdaR2Value.getAddr()));
            for (II item : hl7CdaR2Value.getId()) {
                retVal.addIdentificator(Identificator.createIdentificatorBaseType(item));
            }
            retVal.addName(NameBaseType.builder().withName(hl7CdaR2Value.getName().getMergedXmlMixed()).build());
            retVal.addTelecom(Telecom.createTelecomBaseType(hl7CdaR2Value.getTelecom()));
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    public static OrganizationBaseType createOrganizationBaseType(POCDMT000040Organization hl7CdaR2Value) {
        OrganizationBaseType retVal = new OrganizationBaseType();
        if (hl7CdaR2Value != null) {
            for (AD aD : hl7CdaR2Value.getAddr()) {
                retVal.addAddress(Address.createAddressBaseType(aD));
            }
            for (II iI : hl7CdaR2Value.getId()) {
                retVal.addIdentificator(Identificator.createIdentificatorBaseType(iI));
            }
            for (ON oN : hl7CdaR2Value.getName()) {
                retVal.addName(NameBaseType.builder().withName(oN.getMergedXmlMixed()).build());
            }
            for (TEL tEL : hl7CdaR2Value.getTelecom()) {
                retVal.addTelecom(Telecom.createTelecomBaseType(tEL));
            }
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    public POCDMT000040Custodian createHl7CdaR2Pocdmt000040Custodian(OrganizationBaseType baseType) {
        POCDMT000040Custodian retVal = null;
        ObjectFactory factory = new ObjectFactory();
        if (baseType != null) {
            retVal = this.createHl7CdaR2Pocdmt000040Custodian(factory.createPOCDMT000040Custodian(), baseType);
        }
        return retVal;
    }

    public POCDMT000040Custodian createHl7CdaR2Pocdmt000040Custodian(POCDMT000040Custodian base, OrganizationBaseType baseType) {
        POCDMT000040Custodian retVal = base;
        ObjectFactory factory = new ObjectFactory();
        if (baseType != null) {
            POCDMT000040AssignedCustodian assignedCustodian = factory.createPOCDMT000040AssignedCustodian();
            POCDMT000040CustodianOrganization org = factory.createPOCDMT000040CustodianOrganization();
            assignedCustodian.setRepresentedCustodianOrganization(org);
            retVal.setAssignedCustodian(assignedCustodian);
            if (!baseType.getAddressList().isEmpty()) {
                org.setAddr(Address.createHl7CdaR2Ad(baseType.getAddressList().get(0)));
            }
            for (IdentificatorBaseType item : baseType.getIdentificatorList()) {
                if (item == null) continue;
                org.getId().add(Identificator.createHl7CdaR2Ii(item));
            }
            if (!baseType.getNameList().isEmpty()) {
                org.setName(Organization.createHl7CdaR2On(baseType.getNameList().get(0)));
            }
            if (!baseType.getTelecomList().isEmpty()) {
                org.setTelecom(Telecom.createHl7CdaR2Tel(baseType.getTelecomList().get(0)));
            }
        }
        return retVal;
    }

    public POCDMT000040InformationRecipient createHl7CdaR2Pocdmt000040InformationRecipient(OrganizationBaseType baseType) {
        POCDMT000040InformationRecipient retVal = null;
        ObjectFactory factory = new ObjectFactory();
        if (baseType != null) {
            retVal = this.createHl7CdaR2Pocdmt000040InformationRecipient(factory.createPOCDMT000040InformationRecipient(), baseType);
        }
        return retVal;
    }

    public POCDMT000040InformationRecipient createHl7CdaR2Pocdmt000040InformationRecipient(POCDMT000040InformationRecipient base, OrganizationBaseType baseType) {
        POCDMT000040InformationRecipient retVal = base;
        ObjectFactory factory = new ObjectFactory();
        if (baseType != null) {
            POCDMT000040IntendedRecipient intendedRecipient = factory.createPOCDMT000040IntendedRecipient();
            POCDMT000040Organization org = factory.createPOCDMT000040Organization();
            intendedRecipient.setReceivedOrganization(org);
            retVal.setIntendedRecipient(intendedRecipient);
            List<AD> addresses = this.createHl7AdList(baseType.getAddressList());
            org.getAddr().addAll(addresses);
            retVal.getIntendedRecipient().getAddr().addAll(addresses);
            org.getId().addAll(this.createHl7IiList(baseType.getIdentificatorList()));
            for (NameBaseType item : baseType.getNameList()) {
                if (item == null) continue;
                org.getName().add(Organization.createHl7CdaR2On(item));
            }
            List<TEL> tels = this.createHl7TelList(baseType.getTelecomList());
            org.getTelecom().addAll(tels);
            retVal.getIntendedRecipient().getTelecom().addAll(tels);
        }
        return retVal;
    }

    public POCDMT000040Organization createHl7CdaR2Pocdmt000040Organization(OrganizationBaseType baseType) {
        POCDMT000040Organization retVal = null;
        ObjectFactory factory = new ObjectFactory();
        if (baseType != null) {
            retVal = this.createHl7CdaR2Pocdmt000040Organization(factory.createPOCDMT000040Organization(), baseType);
        }
        return retVal;
    }

    public POCDMT000040Organization createHl7CdaR2Pocdmt000040Organization(POCDMT000040Organization base, OrganizationBaseType baseType) {
        POCDMT000040Organization retVal = base;
        if (baseType != null) {
            retVal.getAddr().addAll(this.createHl7AdList(baseType.getAddressList()));
            retVal.getId().addAll(this.createHl7IiList(baseType.getIdentificatorList()));
            retVal.getTelecom().addAll(this.createHl7TelList(baseType.getTelecomList()));
            for (NameBaseType item : baseType.getNameList()) {
                if (item == null) continue;
                retVal.getName().add(Organization.createHl7CdaR2On(item));
            }
        }
        return retVal;
    }

    public POCDMT000040AssignedAuthor createHl7CdaR2Pocdmt000040AssignedAuthor() {
        POCDMT000040AssignedAuthor retVal = null;
        ObjectFactory factory = new ObjectFactory();
        retVal = this.createHl7CdaR2Pocdmt000040AssignedAuthor(factory.createPOCDMT000040AssignedAuthor());
        return retVal;
    }

    public POCDMT000040AssignedAuthor createHl7CdaR2Pocdmt000040AssignedAuthor(POCDMT000040AssignedAuthor base) {
        POCDMT000040AssignedAuthor retVal = base;
        retVal.getAddr().addAll(this.createHl7AdList(this.getAddressList()));
        retVal.getId().addAll(this.createHl7IiList(this.getIdentificatorList()));
        retVal.getTelecom().addAll(this.createHl7TelList(this.getTelecomList()));
        return retVal;
    }

    private List<II> createHl7IiList(List<IdentificatorBaseType> listIdent) {
        LinkedList<II> ids = new LinkedList<II>();
        for (IdentificatorBaseType item : listIdent) {
            if (item == null) continue;
            ids.add(Identificator.createHl7CdaR2Ii(item));
        }
        return ids;
    }

    private List<TEL> createHl7TelList(List<TelecomBaseType> listTelecom) {
        LinkedList<TEL> tels = new LinkedList<TEL>();
        for (TelecomBaseType item : listTelecom) {
            if (item == null) continue;
            tels.add(Telecom.createHl7CdaR2Tel(item));
        }
        return tels;
    }

    private List<AD> createHl7AdList(List<AddressBaseType> listAddresses) {
        LinkedList<AD> addresses = new LinkedList<AD>();
        for (AddressBaseType item : listAddresses) {
            if (item == null) continue;
            addresses.add(Address.createHl7CdaR2Ad(item));
        }
        return addresses;
    }

    public POCDMT000040Custodian getHl7CdaR2Pocdmt000040Custodian() {
        return this.createHl7CdaR2Pocdmt000040Custodian(this);
    }

    public POCDMT000040Custodian getHl7CdaR2Pocdmt000040Custodian(POCDMT000040Custodian base) {
        return this.createHl7CdaR2Pocdmt000040Custodian(base, this);
    }

    public POCDMT000040InformationRecipient getHl7CdaR2Pocdmt000040InformationRecipient() {
        return this.createHl7CdaR2Pocdmt000040InformationRecipient(this);
    }

    public POCDMT000040InformationRecipient getHl7CdaR2Pocdmt000040InformationRecipient(POCDMT000040InformationRecipient base) {
        return this.createHl7CdaR2Pocdmt000040InformationRecipient(base, this);
    }

    public POCDMT000040Organization getHl7CdaR2Pocdmt000040Organization() {
        return this.createHl7CdaR2Pocdmt000040Organization(this);
    }

    public POCDMT000040Organization getHl7CdaR2Pocdmt000040Organization(POCDMT000040Organization base) {
        return this.createHl7CdaR2Pocdmt000040Organization(base, this);
    }

    private void initFromBaseType(OrganizationBaseType baseType) {
        if (baseType != null) {
            this.setAddressList(baseType.getAddressList());
            this.setIdentificatorList(baseType.getIdentificatorList());
            this.setNameList(baseType.getNameList());
            this.setPrimaryAddress(baseType.getPrimaryAddress());
            this.setPrimaryIdentificator(baseType.getPrimaryIdentificator());
            this.setPrimaryName(baseType.getPrimaryName());
            this.setPrimaryTelecom(baseType.getPrimaryTelecom());
            this.setTelecomList(baseType.getTelecomList());
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(POCDMT000040CustodianOrganization hl7CdaR2Value) {
        this.initFromBaseType(Organization.createOrganizationBaseType(hl7CdaR2Value));
    }

    private void initFromHl7CdaR2(POCDMT000040Organization hl7CdaR2Value) {
        this.initFromBaseType(Organization.createOrganizationBaseType(hl7CdaR2Value));
    }

    public void set(POCDMT000040Organization hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public void set(OrganizationBaseType baseType) {
        this.initFromBaseType(baseType);
    }
}

