/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.Map;
import org.projecthusky.common.enums.ObservationInterpretation;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.POCDMT000040ObservationRange;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Value;

public class ObservationRange {
    private POCDMT000040ObservationRange mObsR;

    public ObservationRange() {
        this.mObsR = new POCDMT000040ObservationRange();
        this.mObsR.getClassCode().clear();
        this.mObsR.getClassCode().add("OBS");
        this.mObsR.getMoodCode().clear();
        this.mObsR.getMoodCode().add("EVNCRT");
    }

    public ObservationRange(POCDMT000040ObservationRange mdht) {
        this.mObsR = mdht;
    }

    public ObservationInterpretation getInterpretation() {
        if (this.mObsR.getInterpretationCode() != null) {
            return ObservationInterpretation.getEnum(this.mObsR.getInterpretationCode().getCode());
        }
        return null;
    }

    public void setInterpretation(ObservationInterpretation code) {
        this.mObsR.setInterpretationCode(code.getCE());
    }

    public Code getInterpretationCode() {
        if (this.mObsR.getInterpretationCode() != null) {
            return new Code(this.mObsR.getInterpretationCode());
        }
        return null;
    }

    public void setInterpretationCode(Code code) {
        this.mObsR.setInterpretationCode(code.getHl7CdaR2Ce());
    }

    public Value getValue() {
        if (this.mObsR.getValue() != null) {
            return new Value(this.mObsR.getValue());
        }
        return null;
    }

    public void setValue(Value value) {
        ANY val = value.getValue();
        if (val instanceof IVLPQ) {
            IVLPQ valIvlPq = (IVLPQ)val;
            Map<String, PQ> elements = value.getPqElement(valIvlPq);
            if (elements.get("low") != null && !elements.get("low").getUnit().isEmpty()) {
                elements.get("low").setUnit(null);
            }
            if (elements.get("high") != null && !elements.get("high").getUnit().isEmpty()) {
                elements.get("high").setUnit(null);
            }
        }
        this.mObsR.setValue(val);
    }

    public POCDMT000040ObservationRange getObsR() {
        return this.mObsR;
    }

    public void setObsR(POCDMT000040ObservationRange obsR) {
        this.mObsR = obsR;
    }
}

