/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.NotImplementedException;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XpnName;
import org.projecthusky.common.basetypes.NameBaseType;
import org.projecthusky.common.enums.EntityNameUse;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.EN;
import org.projecthusky.common.hl7cdar2.ENXP;
import org.projecthusky.common.hl7cdar2.EnDelimiter;
import org.projecthusky.common.hl7cdar2.EnFamily;
import org.projecthusky.common.hl7cdar2.EnGiven;
import org.projecthusky.common.hl7cdar2.EnPrefix;
import org.projecthusky.common.hl7cdar2.EnSuffix;
import org.projecthusky.common.hl7cdar2.ON;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.TN;

public class Name
extends NameBaseType {
    private static final long serialVersionUID = 1233422782853908534L;
    private static final String ELEMENT_NAME_NAMESPACE_DELIMITER = "hl7:delimiter";
    private static final String ELEMENT_NAME_NAMESPACE_FAMILY = "hl7:family";
    private static final String ELEMENT_NAME_NAMESPACE_GIVEN = "hl7:given";
    private static final String ELEMENT_NAME_NAMESPACE_SUFFIX = "hl7:suffix";
    private static final String ELEMENT_NAME_NAMESPACE_PREFIX = "hl7:prefix";

    public Name() {
    }

    public Name(NameBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public Name(EN hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Name(ON hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Name(PN hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Name(org.openehealth.ipf.commons.ihe.xds.core.metadata.Name<?> ipfName) {
        this.initFromIpfType(ipfName);
    }

    public Name(String name) {
        this.setName(name);
    }

    public static EN createHl7CdaR2En(NameBaseType baseType) {
        EN retVal = null;
        if (baseType != null) {
            retVal = new EN();
            Name.createName(retVal, baseType);
        }
        return retVal;
    }

    public static ON createHl7CdaR2On(NameBaseType baseType) {
        ON retVal = null;
        if (baseType != null) {
            retVal = new ON();
            Name.createName(retVal, baseType);
            EntityNameUse usage = baseType.getUsage();
            if (usage != null) {
                retVal.getUse().clear();
                retVal.getUse().add(usage.getCode().getCode());
            }
        }
        return retVal;
    }

    public static PN createHl7CdaR2Pn(NameBaseType baseType) {
        PN retVal = null;
        if (baseType != null) {
            retVal = new PN();
            Name.createName(retVal, baseType);
            EntityNameUse usage = baseType.getUsage();
            if (usage != null) {
                retVal.getUse().clear();
                retVal.getUse().add(usage.getCode().getCode());
            }
        }
        return retVal;
    }

    public static TN createHl7CdaR2Tn(NameBaseType baseType) {
        TN retVal = null;
        if (baseType != null) {
            retVal = new TN();
            Name.createName(retVal, baseType);
        }
        return retVal;
    }

    private static void createName(EN retVal, NameBaseType baseType) {
        NullFlavor nf = baseType.getNullFlavor();
        if (nf != null) {
            if (retVal.nullFlavor == null) {
                retVal.nullFlavor = new ArrayList();
            }
            retVal.nullFlavor.add(nf.getCodeValue());
        }
        List<Serializable> content = Name.createNameContent(baseType);
        String value = baseType.getName();
        if (value != null && content.isEmpty()) {
            retVal.setXmlMixed(value);
        } else {
            retVal.getContent().addAll(content);
        }
    }

    private static List<Serializable> createNameContent(NameBaseType baseType) {
        ENXP obj;
        ArrayList<Serializable> content = new ArrayList<Serializable>();
        String value = baseType.getDelimiter();
        if (value != null) {
            obj = new EnDelimiter();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(ELEMENT_NAME_NAMESPACE_DELIMITER), EnDelimiter.class, (Object)obj));
        }
        if ((value = baseType.getFamily()) != null) {
            obj = new EnFamily();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(ELEMENT_NAME_NAMESPACE_FAMILY), EnFamily.class, (Object)obj));
        }
        if ((value = baseType.getGiven()) != null) {
            obj = new EnGiven();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(ELEMENT_NAME_NAMESPACE_GIVEN), EnGiven.class, (Object)obj));
        }
        if ((value = baseType.getPrefix()) != null) {
            obj = new EnPrefix();
            obj.setXmlMixed(value);
            obj.getQualifier().add("AC");
            content.add((Serializable)new JAXBElement(new QName(ELEMENT_NAME_NAMESPACE_PREFIX), EnPrefix.class, (Object)obj));
        }
        if ((value = baseType.getSuffix()) != null) {
            obj = new EnSuffix();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(ELEMENT_NAME_NAMESPACE_SUFFIX), EnSuffix.class, (Object)obj));
        }
        return content;
    }

    public static NameBaseType createNameBaseType(EN hl7CdaR2Value) {
        NameBaseType retVal = new NameBaseType();
        if (hl7CdaR2Value != null) {
            String nullFlavor = null;
            if (hl7CdaR2Value.nullFlavor != null && !hl7CdaR2Value.nullFlavor.isEmpty()) {
                nullFlavor = (String)hl7CdaR2Value.nullFlavor.get(0);
            }
            if (nullFlavor != null) {
                retVal.setNullFlavor(NullFlavor.getEnum(nullFlavor));
            }
            if (!hl7CdaR2Value.getUse().isEmpty()) {
                retVal.setUsage(EntityNameUse.getEnum(hl7CdaR2Value.getUse().get(0)));
            }
            if (!hl7CdaR2Value.getContent().isEmpty()) {
                Name.extractNameFieldsFromContent(retVal, hl7CdaR2Value);
            } else {
                retVal.setName(hl7CdaR2Value.getMergedXmlMixed());
            }
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    private static void extractNameFieldsFromContent(NameBaseType retVal, EN hl7CdaR2Value) {
        for (Serializable element : hl7CdaR2Value.getContent()) {
            if (!(element instanceof JAXBElement)) continue;
            JAXBElement elem = (JAXBElement)element;
            Object object = elem.getValue();
            if (object instanceof EnDelimiter) {
                EnDelimiter obj = (EnDelimiter)object;
                retVal.setDelimiter(obj.getTextContent());
                continue;
            }
            object = elem.getValue();
            if (object instanceof EnFamily) {
                EnFamily obj = (EnFamily)object;
                retVal.setFamily(obj.getTextContent());
                continue;
            }
            object = elem.getValue();
            if (object instanceof EnGiven) {
                EnGiven obj = (EnGiven)object;
                retVal.setGiven(obj.getTextContent());
                continue;
            }
            object = elem.getValue();
            if (object instanceof EnPrefix) {
                EnPrefix obj = (EnPrefix)object;
                retVal.setPrefix(obj.getTextContent());
                continue;
            }
            object = elem.getValue();
            if (object instanceof EnSuffix) {
                EnSuffix obj = (EnSuffix)object;
                retVal.setSuffix(obj.getTextContent());
                continue;
            }
            throw new NotImplementedException(elem.getValue().getClass().getName());
        }
    }

    public static XpnName getIpfXpnName(PN hl7CdaR2Value) {
        NameBaseType nameBase = Name.createNameBaseType(hl7CdaR2Value);
        return new XpnName(nameBase.getFamily(), nameBase.getGiven(), null, nameBase.getSuffix(), nameBase.getPrefix(), null);
    }

    public EN getHl7CdaR2En() {
        return Name.createHl7CdaR2En(this);
    }

    public PN getHl7CdaR2Pn() {
        return Name.createHl7CdaR2Pn(this);
    }

    public TN getHl7CdaR2Tn() {
        return Name.createHl7CdaR2Tn(this);
    }

    private void initFromBaseType(NameBaseType baseType) {
        if (baseType != null) {
            this.setDelimiter(baseType.getDelimiter());
            this.setFamily(baseType.getFamily());
            this.setGiven(baseType.getGiven());
            this.setPrefix(baseType.getPrefix());
            this.setSuffix(baseType.getSuffix());
            this.setName(baseType.getName());
            if (baseType.getUsage() != null) {
                this.setUsage(baseType.getUsage());
            } else {
                this.setUsage(EntityNameUse.LEGAL);
            }
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromIpfType(org.openehealth.ipf.commons.ihe.xds.core.metadata.Name<?> ipfType) {
        if (ipfType != null) {
            this.setFamily(ipfType.getFamilyName());
            this.setGiven(ipfType.getGivenName());
            this.setPrefix(ipfType.getPrefix());
            this.setSuffix(ipfType.getSuffix());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(EN hl7CdaR2Value) {
        this.initFromBaseType(Name.createNameBaseType(hl7CdaR2Value));
    }

    public void set(NameBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public void set(EN hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }
}

