/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.POCDMT000040IntendedRecipient;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organization;
import org.projecthusky.common.hl7cdar2.POCDMT000040Person;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Person;
import org.projecthusky.common.model.Telecom;

public class IntendedRecipient {
    private POCDMT000040IntendedRecipient mIntendedRecipient;

    public IntendedRecipient() {
        this.setIntendedRecipient(new POCDMT000040IntendedRecipient());
    }

    public IntendedRecipient(Name name, Identificator id, Address address, List<Telecom> telecoms) {
        this();
        Person p = new Person();
        p.addName(name);
        this.setInformationRecipient(p);
        this.addId(id);
        this.addAddress(address);
        this.setTelecoms(telecoms);
    }

    public IntendedRecipient(POCDMT000040IntendedRecipient mdht) {
        this.setIntendedRecipient(mdht);
    }

    public IntendedRecipient(Organization organization) {
        this();
        POCDMT000040Organization mdht = organization.getHl7CdaR2Pocdmt000040Organization();
        if (!mdht.getAddr().isEmpty()) {
            this.getIntendedRecipient().getAddr().addAll(mdht.getAddr());
        }
        if (!mdht.getId().isEmpty()) {
            this.getIntendedRecipient().getId().addAll(mdht.getId());
        }
        if (!mdht.getTelecom().isEmpty()) {
            this.getIntendedRecipient().getTelecom().addAll(mdht.getTelecom());
        }
        if (!mdht.getName().isEmpty()) {
            POCDMT000040Person p = new POCDMT000040Person();
            p.getName().add(new Name(mdht.getName().get(0)).getHl7CdaR2Pn());
            this.getIntendedRecipient().setInformationRecipient(p);
        }
        this.setOrganization(organization);
    }

    public void addAddress(Address address) {
        this.getIntendedRecipient().getAddr().add(address.getHl7CdaR2Ad());
    }

    public void addId(Identificator identificator) {
        this.getIntendedRecipient().getId().add(identificator.getHl7CdaR2Ii());
    }

    public List<Address> getAddresses() {
        ArrayList<Address> al = new ArrayList<Address>();
        for (AD mAddress : this.getIntendedRecipient().getAddr()) {
            al.add(new Address(mAddress));
        }
        return al;
    }

    public List<Identificator> getIds() {
        return Identificator.getIdentificatorList(this.getIntendedRecipient().getId());
    }

    public POCDMT000040IntendedRecipient getIntendedRecipient() {
        return this.mIntendedRecipient;
    }

    public void setIntendedRecipient(POCDMT000040IntendedRecipient intendedRecipient) {
        this.mIntendedRecipient = intendedRecipient;
    }

    public Person getMdhtInformationRecipient() {
        return new Person(this.getIntendedRecipient().getInformationRecipient());
    }

    public POCDMT000040IntendedRecipient getMdhtIntendedRecipient() {
        return this.getIntendedRecipient();
    }

    public Organization getOrganization() {
        return new Organization(this.getIntendedRecipient().getReceivedOrganization());
    }

    public void setOrganization(Organization organization) {
        this.getIntendedRecipient().setReceivedOrganization(organization.getHl7CdaR2Pocdmt000040Organization());
    }

    public List<Telecom> getTelecoms() {
        LinkedList<Telecom> telecoms = new LinkedList<Telecom>();
        for (TEL tel : this.getIntendedRecipient().getTelecom()) {
            if (tel == null) continue;
            telecoms.add(new Telecom(tel));
        }
        return telecoms;
    }

    public void setTelecoms(List<Telecom> telecoms) {
        for (Telecom telecom : telecoms) {
            if (telecom == null) continue;
            this.getIntendedRecipient().getTelecom().add(telecom.getHl7CdaR2Tel());
        }
    }

    public void setInformationRecipient(Person person) {
        this.getIntendedRecipient().setInformationRecipient(person.getHl7CdaPerson());
    }
}

