/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.projecthusky.common.basetypes.IdentificatorBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.II;

public class Identificator
extends IdentificatorBaseType {
    private static final long serialVersionUID = 6963042793314704003L;

    public Identificator() {
    }

    public Identificator(IdentificatorBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public Identificator(II hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Identificator(String root) {
        super.setRoot(root);
    }

    public Identificator(String root, String extension) {
        super.setRoot(root);
        super.setExtension(extension);
    }

    public Identificator(Identifiable id) {
        if (id != null) {
            super.setExtension(id.getId());
            if (id.getAssigningAuthority() != null) {
                super.setRoot(id.getAssigningAuthority().getUniversalId());
            }
        }
    }

    public static II createHl7CdaR2Ii(IdentificatorBaseType baseType) {
        II retVal = null;
        if (baseType != null) {
            retVal = new II();
            NullFlavor nf = baseType.getNullFlavor();
            if (nf != null) {
                if (retVal.nullFlavor == null) {
                    retVal.nullFlavor = new ArrayList();
                }
                retVal.nullFlavor.add(nf.getCodeValue());
            } else {
                Identificator.createIdentificator(retVal, baseType);
            }
        }
        return retVal;
    }

    private static void createIdentificator(II retVal, IdentificatorBaseType baseType) {
        Boolean bValue;
        String value = baseType.getAssigningAuthorityName();
        if (value != null) {
            retVal.setAssigningAuthorityName(value);
        }
        if ((bValue = baseType.isDisplayable()) != null) {
            retVal.setDisplayable(bValue);
        }
        if ((value = baseType.getExtension()) != null) {
            retVal.setExtension(value);
        }
        if ((value = baseType.getRoot()) != null) {
            retVal.setRoot(value);
        }
    }

    public static IdentificatorBaseType createIdentificatorBaseType(II hl7CdaR2Value) {
        IdentificatorBaseType retVal = new IdentificatorBaseType();
        if (hl7CdaR2Value != null) {
            String nullFlavor = null;
            if (hl7CdaR2Value.nullFlavor != null && !hl7CdaR2Value.nullFlavor.isEmpty()) {
                nullFlavor = (String)hl7CdaR2Value.nullFlavor.get(0);
            }
            if (nullFlavor != null) {
                retVal.setNullFlavor(NullFlavor.getEnum(nullFlavor));
            }
            retVal.setAssigningAuthorityName(hl7CdaR2Value.getAssigningAuthorityName());
            if (hl7CdaR2Value.isDisplayable() != null) {
                retVal.setDisplayable(hl7CdaR2Value.isDisplayable());
            }
            retVal.setExtension(hl7CdaR2Value.getExtension());
            retVal.setRoot(hl7CdaR2Value.getRoot());
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    public static Identificator getIdentificator(List<II> iiList, String root) {
        for (II i : iiList) {
            if (!i.getRoot().equals(root)) continue;
            return new Identificator(i);
        }
        return null;
    }

    public static List<Identificator> getIdentificatorList(List<II> iiList) {
        ArrayList<Identificator> il = new ArrayList<Identificator>();
        for (II mId : iiList) {
            il.add(new Identificator(mId));
        }
        return il;
    }

    public II getHl7CdaR2Ii() {
        return Identificator.createHl7CdaR2Ii(this);
    }

    private void initFromBaseType(IdentificatorBaseType baseType) {
        if (baseType != null) {
            this.setAssigningAuthorityName(baseType.getAssigningAuthorityName());
            this.setDisplayable(baseType.isDisplayable());
            this.setExtension(baseType.getExtension());
            this.setRoot(baseType.getRoot());
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(II hl7CdaR2Value) {
        this.initFromBaseType(Identificator.createIdentificatorBaseType(hl7CdaR2Value));
    }

    public void set(IdentificatorBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public void set(II hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }
}

