/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;

public class Code
extends CodeBaseType {
    private static final long serialVersionUID = 5410972500384690838L;

    public Code() {
    }

    public Code(CodeBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public Code(String code, String codeSystem, String display) {
        this.setCode(code);
        this.setCodeSystem(codeSystem);
        this.setDisplayName(display);
    }

    public Code(String code, String codeSystem, String codeSystemName, String display) {
        this.setCode(code);
        this.setCodeSystem(codeSystem);
        this.setCodeSystemName(codeSystemName);
        this.setDisplayName(display);
    }

    public Code(NullFlavor nf) {
        this.setNullFlavor(nf);
    }

    public Code(CD hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Code(CE hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Code(CS hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public Code(ValueSetEnumInterface enumValue) {
        CodeBaseType codeBt = CodeBaseType.builder().withCode(enumValue.getCodeValue()).withCodeSystem(enumValue.getCodeSystemId()).build();
        if (!enumValue.getCodeSystemName().isEmpty()) {
            codeBt.setCodeSystemName(enumValue.getCodeSystemName());
        }
        if (!enumValue.getDisplayName().isEmpty()) {
            codeBt.setDisplayName(enumValue.getDisplayName());
        }
        this.initFromBaseType(codeBt);
    }

    public static CodeBaseType createCodeBaseType(CD hl7CdaR2Value) {
        CodeBaseType retVal = new CodeBaseType();
        if (hl7CdaR2Value != null) {
            String nullFlavor = null;
            if (hl7CdaR2Value.nullFlavor != null && !hl7CdaR2Value.nullFlavor.isEmpty()) {
                nullFlavor = (String)hl7CdaR2Value.nullFlavor.get(0);
            }
            if (nullFlavor != null) {
                retVal.setNullFlavor(NullFlavor.getEnum(nullFlavor));
            } else {
                retVal.setCode(hl7CdaR2Value.getCode());
                retVal.setCodeSystem(hl7CdaR2Value.getCodeSystem());
                retVal.setCodeSystemName(hl7CdaR2Value.getCodeSystemName());
                retVal.setCodeSystemVersion(hl7CdaR2Value.getCodeSystemVersion());
                retVal.setDisplayName(hl7CdaR2Value.getDisplayName());
                ED ed = hl7CdaR2Value.getOriginalText();
                if (ed != null) {
                    retVal.setOriginalText(ed.getTextContent());
                }
            }
            for (CD item : hl7CdaR2Value.getTranslation()) {
                retVal.addCodeTranslation(Code.createCodeBaseType(item));
            }
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    public static CD createHl7CdaR2Cd(CodeBaseType baseType) {
        CD retVal = null;
        if (baseType != null) {
            retVal = new CD();
            Code.createCode(retVal, baseType);
        }
        return retVal;
    }

    public static CE createHl7CdaR2Ce(CodeBaseType baseType) {
        CE retVal = null;
        if (baseType != null) {
            retVal = new CE();
            Code.createCode(retVal, baseType);
        }
        return retVal;
    }

    public static CS createHl7CdaR2Cs(CodeBaseType baseType) {
        CS retVal = null;
        if (baseType != null) {
            retVal = new CS();
            Code.createCode(retVal, baseType);
        }
        return retVal;
    }

    private static void createCode(CD retVal, CodeBaseType baseType) {
        NullFlavor nf = baseType.getNullFlavor();
        if (nf != null) {
            if (retVal.nullFlavor == null) {
                retVal.nullFlavor = new ArrayList();
            }
            retVal.nullFlavor.add(nf.getCodeValue());
        } else {
            Code.setCodeValues(retVal, baseType);
        }
        for (CodeBaseType item : baseType.getCodeTranslationList()) {
            retVal.getTranslation().add(Code.createHl7CdaR2Cd(item));
        }
    }

    private static void setCodeValues(CD retVal, CodeBaseType baseType) {
        if (baseType.getCode() != null) {
            retVal.setCode(baseType.getCode());
        }
        if (baseType.getCodeSystem() != null) {
            retVal.setCodeSystem(baseType.getCodeSystem());
        }
        if (baseType.getCodeSystemName() != null) {
            retVal.setCodeSystemName(baseType.getCodeSystemName());
        }
        if (baseType.getCodeSystemVersion() != null) {
            retVal.setCodeSystemVersion(baseType.getCodeSystemVersion());
        }
        if (baseType.getDisplayName() != null) {
            retVal.setDisplayName(baseType.getDisplayName());
        }
        if (baseType.getOriginalText() != null) {
            ED ed = new ED();
            ed.setXmlMixed(List.of(baseType.getOriginalText()));
            retVal.setOriginalText(ed);
        }
    }

    public CD getHl7CdaR2Cd() {
        return Code.createHl7CdaR2Cd(this);
    }

    public CE getHl7CdaR2Ce() {
        return Code.createHl7CdaR2Ce(this);
    }

    public CS getHl7CdaR2Cs() {
        return Code.createHl7CdaR2Cs(this);
    }

    private void initFromBaseType(CodeBaseType baseType) {
        if (baseType != null) {
            this.setCode(baseType.getCode());
            this.setCodeSystem(baseType.getCodeSystem());
            this.setCodeSystemName(baseType.getCodeSystemName());
            this.setCodeSystemVersion(baseType.getCodeSystemVersion());
            this.setCodeTranslationList(baseType.getCodeTranslationList());
            this.setDisplayName(baseType.getDisplayName());
            this.setDisplayNameTranslationList(baseType.getDisplayNameTranslationList());
            this.setOriginalText(baseType.getOriginalText());
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(CD hl7CdaR2Value) {
        this.initFromBaseType(Code.createCodeBaseType(hl7CdaR2Value));
    }

    public void set(CodeBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public void set(CD hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }
}

