/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.Isco08;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedAuthor;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040AuthoringDevice;
import org.projecthusky.common.hl7cdar2.POCDMT000040Person;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.AuthoringDevice;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Patient;
import org.projecthusky.common.model.Person;
import org.projecthusky.common.model.Telecom;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class Author {
    public static final Code FUNCTION_CODE_AUTHOR_PATIENT = new Code(NullFlavor.NOT_APPLICABLE_L1);
    public static final Code FUNCTION_CODE_AUTHORDEVICE = new Code("TASST", "2.16.756.5.30.2.1.1.1", null);
    private POCDMT000040Author mAuthor;

    public Author() {
        this.mAuthor = new POCDMT000040Author();
        POCDMT000040AssignedAuthor asAuthor = new POCDMT000040AssignedAuthor();
        POCDMT000040Person person = new POCDMT000040Person();
        asAuthor.setAssignedPerson(person);
        this.mAuthor.setAssignedAuthor(asAuthor);
        this.mAuthor.setFunctionCode(Isco08.MEDICAL_DOCTORS.getCE());
        Date dateTime = this.getTimeAsDate();
        if (dateTime != null) {
            this.mAuthor.setTime(DateTimes.toDateTs(dateTime.toInstant()));
        }
        this.setTime(null);
    }

    public Author(POCDMT000040AuthoringDevice device) {
        this();
        this.setAssignedAuthoringDevice(device);
    }

    public Author(AuthoringDevice device) {
        this();
        this.setAssignedAuthoringDevice(device.getMdht());
    }

    public Author(boolean nullFlavored) {
        this.mAuthor = new POCDMT000040Author();
        POCDMT000040AssignedAuthor asAuthor = new POCDMT000040AssignedAuthor();
        POCDMT000040Person person = new POCDMT000040Person();
        asAuthor.setAssignedPerson(person);
        this.mAuthor.setAssignedAuthor(asAuthor);
        this.mAuthor.getNullFlavor().add("NA");
        this.mAuthor.getAssignedAuthor().getNullFlavor().add("NA");
        II ii = new II();
        ii.getNullFlavor().add("NA");
        this.mAuthor.getAssignedAuthor().getId().add(ii);
        TS tsTime = new TS();
        tsTime.getNullFlavor().add("NA");
        this.mAuthor.setTime(tsTime);
    }

    public Author(Code functionCode) {
        Date dateTime;
        this.mAuthor = new POCDMT000040Author();
        POCDMT000040AssignedAuthor asAuthor = new POCDMT000040AssignedAuthor();
        POCDMT000040Person person = new POCDMT000040Person();
        asAuthor.setAssignedPerson(person);
        this.mAuthor.setAssignedAuthor(asAuthor);
        if (functionCode != null) {
            this.mAuthor.setFunctionCode(functionCode.getHl7CdaR2Ce());
        }
        if ((dateTime = this.getTimeAsDate()) != null) {
            this.mAuthor.setTime(DateTimes.toDateTs(dateTime.toInstant()));
        }
        this.setTime(null);
    }

    public Author(Name name) {
        this();
        this.addName(name);
    }

    public Author(Name name, String gln) {
        this(name);
        II id = new II();
        id.setRoot(CodeSystems.GLN.getCodeSystemId());
        id.setExtension(gln);
        this.mAuthor.getAssignedAuthor().getId().add(id);
    }

    public Author(POCDMT000040Author authorMdht) {
        this.mAuthor = authorMdht;
    }

    public Author(Organization organizationAsAuthor) {
        this.mAuthor = new POCDMT000040Author();
        if (organizationAsAuthor.getHl7CdaR2Pocdmt000040Organization() != null) {
            this.mAuthor.setAssignedAuthor(organizationAsAuthor.createHl7CdaR2Pocdmt000040AssignedAuthor());
        }
        this.setTime(null);
    }

    public Author(Patient patientAsAuthor) {
        this();
        if (patientAsAuthor.getHl7CdaPerson() != null) {
            POCDMT000040Person person = patientAsAuthor.getHl7CdaPerson();
            this.mAuthor.getAssignedAuthor().setAssignedPerson(person);
        }
        if (!patientAsAuthor.getHl7CdaPerson().getName().isEmpty()) {
            for (Name name : patientAsAuthor.getNames()) {
                this.mAuthor.getAssignedAuthor().getAssignedPerson().getName().add(name.getHl7CdaR2Pn());
            }
        }
        if (patientAsAuthor.getIds() != null && !patientAsAuthor.getIds().isEmpty()) {
            this.mAuthor.getAssignedAuthor().getId().addAll(patientAsAuthor.getMdhtPatientRole().getId());
        }
        this.setFunctionCodePatient();
    }

    public Author(Person person) {
        this();
        this.addName(person.getName());
    }

    public Author(Person person, String gln) {
        this(person);
        II id = new II();
        id.setRoot(CodeSystems.GLN.getCodeSystemId());
        id.setExtension(gln);
        this.mAuthor.getAssignedAuthor().getId().add(id);
    }

    public void addAddress(Address address) {
        this.mAuthor.getAssignedAuthor().getAddr().add(address.getHl7CdaR2Ad());
    }

    public void addId(Identificator identificator) {
        this.mAuthor.getAssignedAuthor().getId().add(identificator.getHl7CdaR2Ii());
    }

    public void addName(Name name) {
        this.mAuthor.getAssignedAuthor().getAssignedPerson().getName().add(name.getHl7CdaR2Pn());
    }

    public Address getAddress() {
        return new Address(this.mAuthor.getAssignedAuthor().getAddr().get(0));
    }

    public List<Address> getAddresses() {
        ArrayList<Address> al = new ArrayList<Address>();
        for (AD mAddress : this.mAuthor.getAssignedAuthor().getAddr()) {
            Address address = new Address(mAddress);
            al.add(address);
        }
        return al;
    }

    public POCDMT000040AssignedAuthor getAsAuthor() {
        return this.mAuthor.getAssignedAuthor();
    }

    public void setAsAuthor(POCDMT000040AssignedAuthor asAuthor) {
        this.mAuthor.setAssignedAuthor(asAuthor);
    }

    public POCDMT000040Author getAuthorMdht() {
        return this.mAuthor;
    }

    public String getCompleteName() {
        Name name;
        String retVal = "";
        if (this.mAuthor.getAssignedAuthor() != null && this.mAuthor.getAssignedAuthor().getAssignedPerson() != null && !this.mAuthor.getAssignedAuthor().getAssignedPerson().getName().isEmpty()) {
            name = new Name(this.mAuthor.getAssignedAuthor().getAssignedPerson().getName().get(0));
            retVal = name.getFullName();
        }
        if (retVal.equals("") && this.mAuthor.getAssignedAuthor() != null && this.mAuthor.getAssignedAuthor().getRepresentedOrganization() != null && !this.mAuthor.getAssignedAuthor().getRepresentedOrganization().getName().isEmpty()) {
            name = new Name(this.mAuthor.getAssignedAuthor().getRepresentedOrganization().getName().get(0));
            retVal = name.getFullName();
        }
        if (retVal.equals("") && this.mAuthor.getAssignedAuthor() != null && this.mAuthor.getAssignedAuthor().getAssignedAuthoringDevice() != null && this.mAuthor.getAssignedAuthor().getAssignedAuthoringDevice().getSoftwareName() != null) {
            return this.mAuthor.getAssignedAuthor().getAssignedAuthoringDevice().getSoftwareName().getTextContent();
        }
        return retVal;
    }

    public Code getFunctionCode() {
        if (this.mAuthor.getFunctionCode() != null) {
            return new Code(this.mAuthor.getFunctionCode());
        }
        return null;
    }

    public void setFunctionCode(Code code) {
        if (code != null) {
            this.mAuthor.setFunctionCode(code.getHl7CdaR2Ce());
        }
    }

    public String getGln() {
        if (!this.mAuthor.getAssignedAuthor().getId().isEmpty()) {
            Identificator gln = Identificator.getIdentificator(this.mAuthor.getAssignedAuthor().getId(), CodeSystems.GLN.getCodeSystemId());
            return gln.getExtension();
        }
        return null;
    }

    public void setGln(String gln) {
        if (gln != null) {
            this.addId(new Identificator(CodeSystems.GLN.getCodeSystemId(), gln));
        } else {
            II ii = new II();
            ii.getNullFlavor().add("NA");
            this.mAuthor.getAssignedAuthor().getId().add(ii);
        }
    }

    public Identificator getGlnAsIdentificator() {
        if (!this.mAuthor.getAssignedAuthor().getId().isEmpty()) {
            II ii = this.mAuthor.getAssignedAuthor().getId().get(0);
            return new Identificator(ii);
        }
        return null;
    }

    public List<Identificator> getIds() {
        return Identificator.getIdentificatorList(this.mAuthor.getAssignedAuthor().getId());
    }

    public List<TEL> getMdhtTelecoms() {
        return this.mAuthor.getAssignedAuthor().getTelecom();
    }

    public Name getName() {
        return new Name(this.mAuthor.getAssignedAuthor().getAssignedPerson().getName().get(0));
    }

    public List<Name> getNames() {
        ArrayList<Name> nl = new ArrayList<Name>();
        for (PN mName : this.mAuthor.getAssignedAuthor().getAssignedPerson().getName()) {
            nl.add(new Name(mName));
        }
        return nl;
    }

    public Organization getOrganization() {
        return new Organization(this.mAuthor.getAssignedAuthor().getRepresentedOrganization());
    }

    public void setOrganization(Organization organization) {
        if (organization != null) {
            this.mAuthor.getAssignedAuthor().setRepresentedOrganization(organization.getHl7CdaR2Pocdmt000040Organization());
        }
    }

    public POCDMT000040Person getPerson() {
        return this.mAuthor.getAssignedAuthor().getAssignedPerson();
    }

    public void setPerson(POCDMT000040Person person) {
        this.mAuthor.getAssignedAuthor().setAssignedPerson(person);
    }

    public Code getRoleFunction() {
        return new Code(this.mAuthor.getFunctionCode());
    }

    public void setRoleFunction(Code code) {
        this.mAuthor.setFunctionCode(code.getHl7CdaR2Ce());
    }

    public Code getSpeciality() {
        CE code = this.mAuthor.getAssignedAuthor().getCode();
        return code != null ? new Code(this.mAuthor.getAssignedAuthor().getCode()) : null;
    }

    public void setSpeciality(Code code) {
        this.mAuthor.getAssignedAuthor().setCode(code.getHl7CdaR2Ce());
    }

    public List<Telecom> getTelecoms() {
        LinkedList<Telecom> telecoms = new LinkedList<Telecom>();
        for (TEL tel : this.mAuthor.getAssignedAuthor().getTelecom()) {
            telecoms.add(new Telecom(tel));
        }
        return telecoms;
    }

    public void setTelecoms(List<Telecom> telecoms) {
        for (Telecom tel : telecoms) {
            if (tel == null) continue;
            this.mAuthor.getAssignedAuthor().getTelecom().add(tel.getHl7CdaR2Tel());
        }
    }

    public Date getTimeAsDate() {
        return Optional.ofNullable(this.getTimeAsInstant()).map(Date::from).orElse(null);
    }

    public @Nullable Hl7Dtm getTimeAsHl7Dtm() {
        if (this.mAuthor.getTime() != null && this.mAuthor.getTime().getValue() != null) {
            return Hl7Dtm.fromHl7(this.mAuthor.getTime().getValue());
        }
        return null;
    }

    public @Nullable Instant getTimeAsInstant() {
        return Optional.ofNullable(this.getTimeAsHl7Dtm()).map(Hl7Dtm::toInstant).orElse(Hl7Dtm.now().toInstant());
    }

    public boolean isAuthorPatient() {
        CE functionCode = this.mAuthor.getFunctionCode();
        if (functionCode != null) {
            return FUNCTION_CODE_AUTHOR_PATIENT.equals(new Code(functionCode));
        }
        return false;
    }

    public void setAssignedAuthoringDevice(POCDMT000040AuthoringDevice device) {
        if (this.mAuthor.getAssignedAuthor() == null) {
            this.mAuthor.setAssignedAuthor(new POCDMT000040AssignedAuthor());
        }
        this.mAuthor.getAssignedAuthor().setAssignedAuthoringDevice(device);
        if (this.mAuthor.getAssignedAuthor().getAssignedPerson() != null) {
            this.mAuthor.getAssignedAuthor().setAssignedPerson(null);
        }
    }

    public void setAuthor(POCDMT000040Author author) {
        this.mAuthor = author;
    }

    public void setFunctionCodePatient() {
        this.mAuthor.setFunctionCode(FUNCTION_CODE_AUTHOR_PATIENT.getHl7CdaR2Ce());
    }

    public void setOtherFunctionCode(String codeSystem, String codeSystemName, String originalText) {
        if (originalText != null) {
            CE otherCode = new CE();
            otherCode.getNullFlavor().add("OTH");
            if (codeSystem != null) {
                otherCode.setCode(codeSystem);
            }
            if (codeSystemName != null) {
                otherCode.setCodeSystemName(codeSystemName);
            }
            ED ed = new ED();
            TEL tel = new TEL();
            tel.setValue(originalText);
            ed.setReference(null);
            otherCode.setOriginalText(ed);
            this.mAuthor.setFunctionCode(otherCode);
        }
    }

    public void setTime(Calendar date) {
        if (date != null) {
            this.mAuthor.setTime(DateTimes.toDateTs(date.toInstant(), date.getTimeZone().toZoneId()));
        } else {
            this.mAuthor.setTime(DateTimes.toDateTs(new Date().toInstant()));
        }
    }
}

