/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.NotImplementedException;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.enums.PostalAddressUse;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.ADXP;
import org.projecthusky.common.hl7cdar2.AdxpAdditionalLocator;
import org.projecthusky.common.hl7cdar2.AdxpCity;
import org.projecthusky.common.hl7cdar2.AdxpCountry;
import org.projecthusky.common.hl7cdar2.AdxpHouseNumber;
import org.projecthusky.common.hl7cdar2.AdxpPostBox;
import org.projecthusky.common.hl7cdar2.AdxpPostalCode;
import org.projecthusky.common.hl7cdar2.AdxpState;
import org.projecthusky.common.hl7cdar2.AdxpStreetAddressLine;
import org.projecthusky.common.hl7cdar2.AdxpStreetName;

public class Address
extends AddressBaseType {
    private static final long serialVersionUID = 8984600430220953028L;
    private static final String HL7_NAMESPACE = "urn:hl7-org:v3";

    public Address(AddressBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public Address(AD hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }

    public static AddressBaseType createAddressBaseType(AD hl7CdaR2Value) {
        AddressBaseType retVal = new AddressBaseType();
        if (hl7CdaR2Value != null) {
            String nullFlavor = null;
            if (hl7CdaR2Value.nullFlavor != null && !hl7CdaR2Value.nullFlavor.isEmpty()) {
                nullFlavor = (String)hl7CdaR2Value.nullFlavor.get(0);
            }
            if (nullFlavor != null) {
                retVal.setNullFlavor(NullFlavor.getEnum(nullFlavor));
            }
            if (!hl7CdaR2Value.getUse().isEmpty()) {
                retVal.setUsage(PostalAddressUse.getEnum(hl7CdaR2Value.getUse().get(0)));
            }
            for (Serializable element : hl7CdaR2Value.getContent()) {
                if (!(element instanceof JAXBElement)) continue;
                JAXBElement elem = (JAXBElement)element;
                Address.extractAddressFieldsFromContent(retVal, elem.getValue());
            }
        } else {
            retVal.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
        return retVal;
    }

    private static void extractAddressFieldsFromContent(AddressBaseType retVal, Object value) {
        if (value instanceof AdxpAdditionalLocator) {
            AdxpAdditionalLocator obj = (AdxpAdditionalLocator)value;
            retVal.setAdditionalLocator(obj.getTextContent());
        } else if (value instanceof AdxpStreetName) {
            AdxpStreetName obj = (AdxpStreetName)value;
            retVal.setStreetName(obj.getTextContent());
        } else if (value instanceof AdxpHouseNumber) {
            AdxpHouseNumber obj = (AdxpHouseNumber)value;
            retVal.setBuildingNumber(obj.getTextContent());
        } else if (value instanceof AdxpPostBox) {
            AdxpPostBox obj = (AdxpPostBox)value;
            retVal.setPostBox(obj.getTextContent());
        } else if (value instanceof AdxpPostalCode) {
            AdxpPostalCode obj = (AdxpPostalCode)value;
            retVal.setPostalCode(obj.getTextContent());
        } else if (value instanceof AdxpCity) {
            AdxpCity obj = (AdxpCity)value;
            retVal.setCity(obj.getTextContent());
        } else if (value instanceof AdxpState) {
            AdxpState obj = (AdxpState)value;
            retVal.setState(obj.getTextContent());
        } else if (value instanceof AdxpCountry) {
            AdxpCountry obj = (AdxpCountry)value;
            retVal.setCountry(obj.getTextContent());
        } else if (value instanceof AdxpStreetAddressLine) {
            AdxpStreetAddressLine obj = (AdxpStreetAddressLine)value;
            if (retVal.getStreetAddressLine1() == null) {
                retVal.setStreetAddressLine1(obj.getTextContent());
            } else if (retVal.getStreetAddressLine2() == null) {
                retVal.setStreetAddressLine2(obj.getTextContent());
            }
        } else {
            throw new NotImplementedException(value.getClass().getName());
        }
    }

    public static AD createHl7CdaR2Ad(AddressBaseType baseType) {
        AD retVal = null;
        if (baseType != null) {
            retVal = new AD();
            Address.createAddress(retVal, baseType);
        }
        return retVal;
    }

    private static void createAddress(AD retVal, AddressBaseType baseType) {
        NullFlavor nf = baseType.getNullFlavor();
        if (nf != null) {
            if (retVal.nullFlavor == null) {
                retVal.nullFlavor = new ArrayList();
            }
            retVal.nullFlavor.add(nf.getCodeValue());
        }
        retVal.getContent().addAll(Address.createAddressContent(baseType));
        PostalAddressUse usage = baseType.getUsage();
        if (usage != null) {
            retVal.getUse().clear();
            retVal.getUse().add(usage.getCode().getCode());
        }
    }

    private static List<Serializable> createAddressContent(AddressBaseType baseType) {
        ADXP obj;
        ArrayList<Serializable> content = new ArrayList<Serializable>();
        String value = baseType.getAdditionalLocator();
        if (value != null) {
            obj = new AdxpAdditionalLocator();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "additionalLocator"), AdxpAdditionalLocator.class, (Object)obj));
        }
        if ((value = baseType.getBuildingNumber()) != null) {
            obj = new AdxpHouseNumber();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "houseNumber"), AdxpHouseNumber.class, (Object)obj));
        }
        if ((value = baseType.getCity()) != null) {
            obj = new AdxpCity();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "city"), AdxpCity.class, (Object)obj));
        }
        if ((value = baseType.getCountry()) != null) {
            obj = new AdxpCountry();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "country"), AdxpCountry.class, (Object)obj));
        }
        if ((value = baseType.getPostalCode()) != null) {
            obj = new AdxpPostalCode();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "postalCode"), AdxpPostalCode.class, (Object)obj));
        }
        if ((value = baseType.getPostBox()) != null) {
            obj = new AdxpPostBox();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "postBox"), AdxpPostBox.class, (Object)obj));
        }
        if ((value = baseType.getState()) != null) {
            obj = new AdxpState();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "state"), AdxpState.class, (Object)obj));
        }
        if ((value = baseType.getStreetAddressLine1()) != null) {
            obj = new AdxpStreetAddressLine();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "streetAddressLine"), AdxpStreetAddressLine.class, (Object)obj));
        }
        if ((value = baseType.getStreetAddressLine2()) != null) {
            obj = new AdxpStreetAddressLine();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "streetAddressLine"), AdxpStreetAddressLine.class, (Object)obj));
        }
        if ((value = baseType.getStreetName()) != null) {
            obj = new AdxpStreetName();
            obj.setXmlMixed(value);
            content.add((Serializable)new JAXBElement(new QName(HL7_NAMESPACE, "streetName"), AdxpStreetName.class, (Object)obj));
        }
        return content;
    }

    public AD getHl7CdaR2Ad() {
        return Address.createHl7CdaR2Ad(this);
    }

    private void initFromBaseType(AddressBaseType baseType) {
        if (baseType != null) {
            this.setAdditionalLocator(baseType.getAdditionalLocator());
            this.setBuildingNumber(baseType.getBuildingNumber());
            this.setCity(baseType.getCity());
            this.setCountry(baseType.getCountry());
            this.setPostalCode(baseType.getPostalCode());
            this.setPostBox(baseType.getPostBox());
            this.setState(baseType.getState());
            this.setStreetAddressLine1(baseType.getStreetAddressLine1());
            this.setStreetAddressLine2(baseType.getStreetAddressLine2());
            this.setStreetName(baseType.getStreetName());
            this.setUsage(baseType.getUsage());
            this.setNullFlavor(baseType.getNullFlavor());
        } else {
            this.setNullFlavor(NullFlavor.NOT_AVAILABLE_L2);
        }
    }

    private void initFromHl7CdaR2(AD hl7CdaR2Value) {
        this.initFromBaseType(Address.createAddressBaseType(hl7CdaR2Value));
    }

    public void set(AddressBaseType baseType) {
        this.initFromBaseType(baseType);
    }

    public void set(AD hl7CdaR2Value) {
        this.initFromHl7CdaR2(hl7CdaR2Value);
    }
}

