/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.hl7cdar2;

import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.projecthusky.common.hl7cdar2.BIN;
import org.projecthusky.common.hl7cdar2.CompressionAlgorithm;
import org.projecthusky.common.hl7cdar2.IntegrityCheckAlgorithm;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.Thumbnail;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ED", propOrder={"reference", "thumbnail"})
@XmlSeeAlso(value={Thumbnail.class, ST.class})
public class ED
extends BIN {
    protected TEL reference;
    protected Thumbnail thumbnail;
    @XmlAttribute(name="mediaType")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String mediaType;
    @XmlAttribute(name="language")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String language;
    @XmlAttribute(name="compression")
    protected CompressionAlgorithm compression;
    @XmlAttribute(name="integrityCheck")
    protected byte[] integrityCheck;
    @XmlAttribute(name="integrityCheckAlgorithm")
    protected IntegrityCheckAlgorithm integrityCheckAlgorithm;

    public ED() {
    }

    public ED(String ed) {
        this.setXmlMixed(ed);
    }

    public ED(String ed, String language) {
        this.setXmlMixed(ed);
        this.language = language;
    }

    public ED(String ed, TEL reference) {
        this.setXmlMixed(ed);
        this.reference = reference;
    }

    public CompressionAlgorithm getCompression() {
        return this.compression;
    }

    public byte[] getIntegrityCheck() {
        return this.integrityCheck;
    }

    public @NonNull IntegrityCheckAlgorithm getIntegrityCheckAlgorithm() {
        if (this.integrityCheckAlgorithm == null) {
            return IntegrityCheckAlgorithm.SHA_1;
        }
        return this.integrityCheckAlgorithm;
    }

    public String getLanguage() {
        return this.language;
    }

    public @NonNull String getMediaType() {
        if (this.mediaType == null) {
            return "text/plain";
        }
        return this.mediaType;
    }

    public TEL getReference() {
        return this.reference;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public @NonNull String getTextContent() {
        if (this.getXmlMixed() == null) {
            return "";
        }
        List<String> strings = this.getXmlMixed().stream().filter(Objects::nonNull).map(String::strip).filter(string -> !string.isEmpty()).toList();
        if (strings.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)" ", strings).strip();
    }

    public void setCompression(CompressionAlgorithm value) {
        this.compression = value;
    }

    public void setIntegrityCheck(byte[] value) {
        this.integrityCheck = value;
    }

    public void setIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        this.integrityCheckAlgorithm = value;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public void setMediaType(String value) {
        this.mediaType = value;
    }

    public void setReference(TEL value) {
        this.reference = value;
    }

    public void setThumbnail(Thumbnail value) {
        this.thumbnail = value;
    }
}

