/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import java.util.Collection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.projecthusky.common.enums.CodedMetadataEnumInterface;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.utils.datatypes.Hl7v25;

public interface ValueSetEnumInterface
extends CodedMetadataEnumInterface {
    default public @NonNull CE getCE() {
        return this.getCE(null);
    }

    default public @NonNull CE getCE(@Nullable LanguageCode languageCode) {
        CE ce = new CE();
        ce.setCodeSystem(this.getCodeSystemId());
        ce.setCode(this.getCodeValue());
        if (!this.getCodeSystemName().isEmpty()) {
            ce.setCodeSystemName(this.getCodeSystemName());
        }
        if (!this.getDisplayName().isEmpty()) {
            ce.setDisplayName(this.getDisplayName(languageCode));
        }
        return ce;
    }

    default public @NonNull CD getCD() {
        return this.getCD(null);
    }

    default public @NonNull CD getCD(@Nullable LanguageCode languageCode) {
        CD cd = new CD();
        cd.setCodeSystem(this.getCodeSystemId());
        cd.setCode(this.getCodeValue());
        if (!this.getCodeSystemName().isEmpty()) {
            cd.setCodeSystemName(this.getCodeSystemName());
        }
        if (!this.getDisplayName().isEmpty()) {
            cd.setDisplayName(this.getDisplayName(languageCode));
        }
        return cd;
    }

    default public @NonNull org.projecthusky.common.model.Code getCode() {
        return this.getCode(null);
    }

    default public @NonNull org.projecthusky.common.model.Code getCode(@Nullable LanguageCode languageCode) {
        return new org.projecthusky.common.model.Code(this.getCodeValue(), this.getCodeSystemId(), this.getDisplayName(languageCode));
    }

    @Override
    default public @NonNull Code getIpfCode() {
        return new Code(this.getCodeValue(), new LocalizedString(this.getDisplayName(), "en", "UTF-8"), this.getCodeSystemId());
    }

    @Override
    default public boolean isEqualTo(@NonNull Code code) {
        return this.getCodeSystemId().equals(Objects.requireNonNull(code).getSchemeName()) && this.getCodeValue().equals(code.getCode());
    }

    @Override
    default public boolean isContainedIn(@NonNull Collection<Code> codes) {
        return Objects.requireNonNull(codes).stream().anyMatch(this::isEqualTo);
    }

    @Override
    default public @NonNull String getCodedString() {
        return String.format("%s^^^&%s&ISO", Hl7v25.encodeSt(this.getCodeValue()), this.getCodeSystemId());
    }

    public @NonNull String getCodeSystemId();

    public @NonNull String getCodeSystemName();

    public @NonNull String getCodeValue();

    default public @NonNull String getDisplayName() {
        return this.getDisplayName(null);
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode var1);

    public @NonNull String getValueSetId();

    public @NonNull String getValueSetName();
}

