/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.model.Code;

public enum Ucum {
    AHG_EQUIVALENTS_PER_MILLILITER("{AHG}eq/mL", "AHGEquivalentsPerMilliLiter [Substance Concentration Units]"),
    BILLION_PER_LITER("10*9/L", "BillionPerLiter [Number Concentration Units]"),
    BILLIONS_PER_MICROLITER("10*9/uL", "BillionsPerMicroLiter [Number Concentration Units]"),
    BILLIONS_PER_MILLILITER("10*9/mL", "BillionsPerMilliliter [Number Concentration Units]"),
    BONE_COLLAGEN_EQUIVALENTS_PER_MICRO_MOLE_CREATININE("{BoneCollagen}eq/umol{Cre}", "BoneCollagenEquivalentsPerMicroMoleCreatinine [Substance Ratio Or Substance Fraction Units]"),
    BONE_COLLAGEN_EQUIVALENTS_PER_MILLI_MOLE_CREATININE("{BoneCollagen}eq/mmol{Cre}", "BoneCollagenEquivalentsPerMilliMoleCreatinine [Substance Ratio Or Substance Fraction Units]"),
    CELLS_PER_MICROLITER("{Cells}/uL", "CellsPerMicroLiter [Number Concentration Units]"),
    CENTI_GRAM("cg", "CentiGram [SI Mass Units]"),
    CENTI_LITER("cL", "CentiLiter [SI Volume Units]"),
    CENTI_METER("cm", "CentiMeter [SI Length Units]"),
    COLONY_FORMING_UNITS_PER_MILLILITER("{cfu}/mL", "ColonyFormingUnitsPerMilliLiter [Number Concentration Units]"),
    COMPLEMENT_CH_50_UNITS_PER_MILLILITER("{ComplementCh50}U/mL", "ComplementCh50UnitsPerMilliLiter [Arbitrary Concentration Units]"),
    COPIES_PER_MILLILITER("{Copies}/mL", "CopiesPerMilliLiter [Number Concentration Units]"),
    CUBIC_INCH("[cin_i]", "CubicInch [English Volume Units]"),
    CUP("[cup_us]", "Cup [English Volume Units]"),
    DAY("d", "Day [Time Units]"),
    DECI_GRAM("dg", "DeciGram [SI Mass Units]"),
    DECI_LITER("dL", "DeciLiter [SI Volume Units]"),
    DECI_METER("dm", "DeciMeter [SI Length Units]"),
    DEGREES_CELSIUS("Cel", "DegreesCelsius [Temperature Units]"),
    DEGREES_FAHRENHEIT("[degF]", "DegreesFahrenheit [Temperature Units]"),
    DEGREES_KELVIN("K", "DegreesKelvin [Temperature Units]"),
    DEGREES_OF_ARC("deg", "DegreesOfArc [Plane Angle Units]"),
    DESCRIPTIVE("Code", "Descriptive Name"),
    DRAM("[dr_av]", "Dram [English Mass Units]"),
    EHRLICH_UNITS_PER_100_GRAM("{Ehrlich_U}/100g", "EhrlichUnitsPer100Gram [Arbitrary Concentration Content Units]"),
    EHRLICH_UNITS_PER_DECI_LITER("{Ehrlich_U}/dL", "EhrlichUnitsPerDeciLiter [Arbitrary Concentration Units]"),
    ELISA_UNITS_PER_MILLILITER("{Elisa_U}/mL", "ElisaUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    EQUIVALENT("eq", "Equivalent [Substance Units]"),
    EQUIVALENTS_PER_LITER("eq/L", "EquivalentsPerLiter [Substance Concentration Units]"),
    EQUIVALENTS_PER_MICRO_MOLE("eq/umol", "EquivalentsPerMicroMole [Substance Ratio Or Substance Fraction Units]"),
    EQUIVALENTS_PER_MILLILITER("eq/mL", "EquivalentsPerMilliLiter [Substance Concentration Units]"),
    EQUIVALENTS_PER_MILLIMOLE("eq/mmol", "EquivalentsPerMilliMole [Substance Ratio Or Substance Fraction Units]"),
    FATHOM("[fth_i]", "Fathom [English Length Units]"),
    FEET("[ft_i]", "Feet [English Length Units]"),
    FEMTO_GRAM("fg", "FemtoGram [SI Mass Units]"),
    FEMTO_LITER("fL", "FemtoLiter [Most Common Healthcare Units]"),
    FEMTO_METER("fm", "FemtoMeter [SI Length Units]"),
    FEMTO_MOLE("fmol", "Femtomole [Substance Units]"),
    FEMTO_MOLES_PER_GRAM("fmol/g", "FemtoMolesPerGram [Substance Content Units]"),
    FEMTO_MOLES_PER_MILLIGRAM("fmol/mg", "FemtoMolesPerMilliGram [Substance Content Units]"),
    FEMTO_MOLES_PER_MILLILITER("fmol/mL", "FemtoMolesPerMilliLiter [Substance Concentration Units]"),
    FLUID_DRAM("[fdr_us]", "FluidDram [English Volume Units]"),
    FLUID_OUNCE("[foz_us]", "FluidOunce [English Volume Units]"),
    FRENCH("[Ch]", "French [English Length Units]"),
    GALLON("[gal_us]", "Gallon [English Volume Units]"),
    GRAIN("[gr]", "Grain [English Mass Units]"),
    GRAM("g", "Gram [SI Mass Units]"),
    GRAM_METER("g.m", "GramMeter [Massive Distance Units]"),
    GRAM_METER_PER_HEARTBEAT("g.m/{hb}", "GramMeterPerHeartbeat [Massive Distance Units]"),
    GRAM_METER_PER_HEARTBEAT_PER_SQUARE_METER("g.m/({hb}.m2)", "GramMeterPerHeartbeatPerSquareMeter [Lineic Mass Units]"),
    GRAMS_PER_100_GRAM("g/[100]g", "GramsPer100Gram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    GRAMS_PER_DECI_LITER("g/dL", "GramsPerDeciLiter [Most Common Healthcare Units]"),
    GRAMS_PER_GRAM("g/g", "GramsPerGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    GRAMS_PER_GRAM_CREATININE("g/g{Cre}", "GramsPerGramCreatinine [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    GRAMS_PER_KILOGRAM("g/kg", "GramsPerKiloGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    GRAMS_PER_LITER("g/L", "GramsPerLiter [Most Common Healthcare Units]"),
    GRAMS_PER_MILLILITER("g/mL", "GramsPerMilliLiter [Most Common Healthcare Units]"),
    GRAM_PER_SQUARE_METER("g/m2", "GramsPerSquareMeter [Areic Mass Units]"),
    GRAM_PER_TOTAL_WEIGHT("g/{TotalWeight}", "GramsPerTotalWeight [SI Mass Units]"),
    HECTO_LITER("hL", "HectoLiter [SI Volume Units]"),
    HOUR("h", "Hour [Time Units]"),
    IGA_PHOSPHOLIPID_UNITS_PER_MILLILITER("{IgAPhospholipid}U/mL", "IgAPhospholipidUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    IGG_PHOSPHOLIPID_UNITS_PER_MILLILITER("{IgGPhospholipid}U/mL", "IgGPhospholipidUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    IGM_PHOSPHOLIPID_UNITS_PER_MILLILITER("{IgMPhospholipid}U/mL", "IgMPhospholipidUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    INCH("[in_i]", "Inch [English Length Units]"),
    INTERNATIONAL_UNIT("[iU]", "InternationalUnit [Arbitrary Units]"),
    INTERNATIONAL_UNITS_PER_DECILITER("[iU]/dL", "InternationalUnitsPerDeciLiter [Arbitrary Concentration Units]"),
    INTERNATIONAL_UNITS_PER_GRAM("[iU]/g", "InternationalUnitsPerGram [Arbitrary Concentration Content Units]"),
    INTERNATIONAL_UNITS_PER_GRAM_HEMOGLOBIN("[iU]/g{Hgb}", "InternationalUnitsPerGramHemoglobin [Arbitrary Concentration Content Units]"),
    INTERNATIONAL_UNITS_PER_KILOGRAM("[iU]/kg", "InternationalUnitsPerKilogram [Arbitrary Concentration Content Units]"),
    INTERNATIONAL_UNITS_PER_LITER("[iU]/L", "InternationalUnitsPerLiter [Most Common Healthcare Units]"),
    INTERNATIONAL_UNIT_PER_MILLILITER("[iU]/mL", "InternationalUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    KATAL_PER_KILOGRAM("kat/kg", "KatalPerKilogram [Substance Rate Content Units]"),
    KELVIN_PER_WATT("K/W", "KelvinPerWatt [Thermal Resistance Units]"),
    KILO_CALORIES_PER_OUNCE("kCal/[oz_av]", "KiloCaloriesPerOunce [Energy Content Units]"),
    KILOGRAM("kg", "KiloGram [SI Mass Units]"),
    KILOGRAMS_PER_CUBICMETER("kg/m3", "KiloGramsPerCubicMeter [Mass Concentration Units]"),
    KILOGRAMS_PER_LITER("kg/L", "KiloGramsPerLiter [Mass Concentration Units]"),
    KILOGRAMS_PER_MOLE("kg/mol", "KiloGramsPerMole [Molar Mass Units]"),
    KILOGRAMS_PER_SQUARE_METER("kg/m2", "KiloGramsPerSquareMeter [Areic Mass Units]"),
    KILO_INTERNATIONAL_UNITS_PER_MILLILITER("k[iU]/mL", "KiloInternationalUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    KILOLITER("kL", "KiloLiter [SI Volume Units]"),
    KILOMETER("km", "KiloMeter [SI Length Units]"),
    KILOPASCAL("kPa", "KiloPascal [Most Common Healthcare Units]"),
    KILOSECOND("ks", "KiloSecond [Time Units]"),
    KILO_UNITS_PER_GRAM("kU/g", "KiloUnitsPerGram [Substance Rate Content Units]"),
    LITER("L", "Liter [SI Volume Units]"),
    LITERS_PER_KILOGRAM("L/kg", "LitersPerKilogram [Volume Content Units]"),
    LITER_SQUARE_SECOND_PER_SECOND("L.s2/s", "LiterSquareSecondPerSecond [Volume Duration Units]"),
    LOG10("[lg]", "Log10 [Unity]"),
    MEGASECOND("Ms", "Megasecond [Time Units]"),
    METER("m", "Meter [SI Length Units]"),
    METRIC_TON("t", "MetricTon [SI Mass Units]"),
    MICRO_EQUIVALENT("ueq", "MicroEquivalent [Substance Units]"),
    MICRO_EQUIVALENT_PER_LITER("ueq/L", "MicroEquivalentsPerLiter [Substance Concentration Units]"),
    MICRO_EQUIVALENT_PER_MILLILITER("ueq/mL", "MicroEquivalentsPerMilliLiter [Substance Concentration Units]"),
    MICROGRAM("ug", "MicroGram [SI Mass Units]"),
    MICROGRAM_PER_100_GRAM("ug/[100]g", "MicroGramPer100Gram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAM_PER_GRAM_CREATININE("ug/g{Cre}", "MicroGramPerGramCreatinine [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAM_PER_GRAM_DRY_WEIGHT("ug/g{DryWeight}", "MicroGramPerGramDryWeight [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_DECILITER("ug/dL", "MicroGramsPerDeciLiter [Most Common Healthcare Units]"),
    MICROGRAMS_PER_DECILITER_RED_BLOOD_CELLS("ug/dL{rbc}", "MicroGramsPerDeciLiterRedBloodCells [Mass Concentration Units]"),
    MICROGRAMS_PER_GRAM("ug/g", "MicroGramsPerGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_GRAM_HEMOGLOBIN("ug/g{Hgb}", "MicroGramsPerGramHemoglobin [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_KILOGRAM("ug/kg", "MicroGramsPerKiloGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_LITER("ug/L", "MicroGramsPerLiter [Mass Concentration Units]"),
    MICROGRAMS_PER_MILLIGRAM("ug/mg", "MicroGramsPerMilliGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_MILLIGRAM_CREATININE("ug/mg{Cre}", "MicroGramsPerMilliGramCreatinine [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_MILLILITER("ug/mL", "MicroGramsPerMilliLiter [Most Common Healthcare Units]"),
    MICROGRAMS_PER_NANOGRAM("ug/ng", "MicroGramsPerNanoGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MICROGRAMS_PER_SPECIMEN("ug/{Specimen}", "MicroGramsPerSpecimen [SI Mass Units]"),
    MICROGRAMS_PER_SQUAREMETER("ug/m2", "MicroGramsPerSquareMeter [Areic Mass Units]"),
    MICROGRAMS_PER_TOTAL_VOLUME("ug/{TotalVolume}", "MicroGramsPerTotalVolume [SI Mass Units]"),
    MICRO_INTERNATIONAL_UNIT("u[iU]", "MicroInternationalUnit [Arbitrary Units]"),
    MICRO_INTERNATIONAL_UNITY_PER_MILLILITER("u[iU]/mL", "MicroInternationalUnitsPerMilliLiter [Arbitrary Concentration Units]"),
    MICROLITER("uL", "MicroLiter [SI Volume Units]"),
    MICROMETER("um", "MicroMeter [SI Length Units]"),
    MICROMOLE("umol", "MicroMole [Substance Units]"),
    MICROMOLES_PER_DECILITER("umol/dL", "MicroMolesPerDeciLiter [Substance Concentration Units]"),
    MICROMOLES_PER_GRAM("umol/g", "MicroMolesPerGram [Substance Content Units]"),
    MICROMOLES_PER_GRAM_CREATININE("umol/g{Cre}", "MicroMolesPerGramCreatinine [Substance Content Units]"),
    MICROMOLES_PER_GRAM_HEMOGLOBIN("umol/g{Hgb}", "MicroMolesPerGramHemoglobin [Substance Content Units]"),
    MICROMOLES_PER_LITER("umol/L", "MicroMolesPerLiter [Most Common Healthcare Units]"),
    MICROMOLES_PER_MILLIGRAM("umol/mg", "MicroMolesPerMilliGram [Substance Content Units]"),
    MICROMOLES_PER_MILLIGRAM_CREATININE("umol/mg{Cre}", "MicroMolesPerMilliGramCreatinine [Substance Content Units]"),
    MICROMOLES_PER_MILLILITER("umol/mL", "MicroMolesPerMilliLiter [Substance Concentration Units]"),
    MICROMOLES_PER_MINUTE_PER_GRAM("umol/min/g", "MicroMolesPerMinutePerGram [Substance Rate Content Units]"),
    MICROMOLES_PER_MOLE("umol/mol", "MicroMolesPerMole [Substance Ratio Or Substance Fraction Units]"),
    MICROMOLES_PER_MOLE_CREATININE("umol/mol{Cre}", "MicroMolesPerMoleCreatinine [Substance Ratio Or Substance Fraction Units]"),
    MICROSECOND("us", "MicroSecond [Time Units]"),
    MILLI_EQUIVALENT("meq", "MilliEquivalent [Substance Units]"),
    MILLI_EQUIVALENT_PER_MILLILITER("meq/mL", "MilliEquivalentPerMilliLiter [Substance Concentration Units]"),
    MILLI_EQUIVALENTS_PER_DECILITER("meq/dL", "MilliEquivalentsPerDeciLiter [Substance Concentration Units]"),
    MILLI_EQUIVALENTS_PER_GRAM("meq/g", "MilliEquivalentsPerGram [Substance Content Units]"),
    MILLI_EQUIVALENTS_PER_GRAM_CREATININE("meq/g{Cre}", "MilliEquivalentsPerGramCreatinine [Substance Content Units]"),
    MILLI_EQUIVALENTS_PER_KILOGRAM("meq/kg", "MilliEquivalentsPerKiloGram [Substance Content Units]"),
    MILLI_EQUIVALENTS_PER_LITER("meq/L", "MilliEquivalentsPerLiter [Most Common Healthcare Units]"),
    MILLI_EQUIVALENTS_PER_SPECIMEN("meq/{Specimen}", "MilliEquivalentsPerSpecimen [Substance Units]"),
    MILLI_EQUIVALENTS_PER_SQUARE_METER("meq/m2", "MilliEquivalentsPerSquareMeter [Areic Substance Units]"),
    MILLIGRAM("mg", "MilliGram [SI Mass Units]"),
    MILLIGRAM_PER_GRAM_CREATININE("mg/g{Cre}", "MilliGramPerGramCreatinine [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MILLIGRAM_PER_TOTAL_VOLUME("mg/{TotalVolume}", "MilliGramPerTotalVolume [SI Mass Units]"),
    MILLIGRAMS_PER_CUBICMETER("mg/m3", "MilliGramsPerCubicMeter [Mass Concentration Units]"),
    MILLIGRAMS_PER_DECILITER("mg/dL", "MilliGramsPerDeciLiter [Most Common Healthcare Units]"),
    MILLIGRAMS_PER_GRAM("mg/g", "MilliGramsPerGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MILLIGRAMS_PER_KILOGRAM("mg/kg", "MilliGramsPerKiloGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MILLIGRAMS_PER_LITER("mg/L", "MilliGramsPerLiter [Mass Concentration Units]"),
    MILLIGRAMS_PER_MILLIGRAM("mg/mg", "MilliGramsPerMilliGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MILLIGRAMS_PER_MILLIGRAM_CREATININE("mg/mg{Cre}", "MilligramsPerMilligramCreatinine [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    MILLIGRAMS_PER_MILLILITER("mg/mL", "MilliGramsPerMilliLiter [Mass Concentration Units]"),
    MILLIGRAMS_PER_SQUARE_METER("mg/m2", "MilliGramsPerSquareMeter [Areic Mass Units]"),
    MILLIGRAMS_PER_VOLUME("mg/{Volume}", "MilliGramsPerVolume [SI Mass Units]"),
    MILLIGRAMS_PER_PHENYLKETONES_PER_DECILITER("mg{Phenylketones}/dL", "MilliGramsPhenylketonesPerDeciLiter [Mass Concentration Units]"),
    MILLI_INTERNATIONAL_UNITS_PER_LITER("m[iU]/L", "MilliInternationalUnitsPerLiter [Arbitrary Concentration Units]"),
    MILLI_INTERNATIONAL_UNITS_PER_MILLILITER("m[iU]/mL", "MilliInternationalUnitsPerMilliLiter [Most Common Healthcare Units]"),
    MILLILITER("mL", "MilliLiter [SI Volume Units]"),
    MILLILITERS_PER_DECILITER("mL/dL", "MilliLitersPerDeciLiter [Volume Fraction Units]"),
    MILLILITERS_PER_HEARTBEAT("mL/{h`b}", "MilliLitersPerHeartbeat [SI Volume Units]"),
    MILLILITERS_PER_KILOGRAM("mL/kg", "MilliLitersPerKiloGram [Volume Content Units]"),
    MILLIMETER("mm", "MilliMeter [SI Length Units]"),
    MILLIMETERS_OF_MERCURY("mm[Hg]", "MilliMetersOfMercury [Most Common Healthcare Units]"),
    MILLIMOLE("mmol", "MilliMole [Substance Units]"),
    MILLIMOLES_PER_DECILITER("mmol/dL", "MilliMolesPerDeciLiter [Substance Concentration Units]"),
    MILLIMOLES_PER_GRAM("mmol/g", "MilliMolesPerGram [Substance Content Units]"),
    MILLIMOLES_PER_KILOGRAM("mmol/kg", "MilliMolesPerKiloGram [Most Common Healthcare Units]"),
    MILLIMOLES_PER_LITER("mmol/L", "MilliMolesPerLiter [Most Common Healthcare Units]"),
    MILLIMOLES_PER_MOLE("mmol/mol", "MilliMolesPerMole [Substance Ratio Or Substance Fraction Units]"),
    MILLIMOLES_PER_MOLE_CREATININE("mmol/mol{Cre}", "MilliMolesPerMoleCreatinine [Substance Ratio Or Substance Fraction Units]"),
    MILLIMOLES_PER_SQUARE_METER("mmol/m2", "MilliMolesPerSquareMeter [Areic Substance Units]"),
    MILLIMOLES_PER_TOTAL_VOLUME("mmol/{TotalVolume}", "MilliMolesPerTotalVolume [Substance Units]"),
    MILLION("10*6", "Million [Unity]"),
    MILLION_EQUIVALENTS_PER_MILLILITER("10*6.eq/mL", "MillionEquivalentsPerMilliLiter [Substance Concentration Units]"),
    MILLION_INTERNATIONAL_UNIT("10*6.[iU]", "MillionInternationalUnit [Arbitrary Units]"),
    MILLION_PER_LITER("10*6/L", "MillionPerLiter [Number Concentration Units]"),
    MILLION_PER_MILLILITER("10*6/mL", "MillionPerMilliLiter [Number Concentration Units]"),
    MILLION_PER_SPECIMEN("10*6/{Specimen}", "MillionPerSpecimen [Unity]"),
    MILLIONS_PER_MICROLITER("10*6/uL", "MillionsPerMicroLiter [Most Common Healthcare Units]"),
    MILLIOSMOLE("mosm", "MilliOsmole [Substance Units]"),
    MILLIOSMOLES_PER_KILOGRAM("mosm/kg", "MilliOsmolesPerKiloGram [Most Common Healthcare Units]"),
    MILLIOSMOLES_PER_LITER("mosm/L", "MilliOsmolesPerLiter [Substance Concentration Units]"),
    MILLISECOND("ms", "MilliSecond [Time Units]"),
    MILLI_UNITS_PER_GRAM("mU/g", "MilliUnitsPerGram [Substance Rate Content Units]"),
    MILLI_UNITS_PER_GRAM_HEMOGLOBIN("mU/g{Hgb}", "MilliUnitsPerGramHemoglobin [Substance Rate Content Units]"),
    MILLI_UNITS_PER_MILLIGRAM("mU/mg", "MilliUnitsPerMilligram [Substance Rate Content Units]"),
    MILLI_UNITS_PER_MILLIGRAM_CREATININE("mU/mg{Cre}", "MilliUnitsPerMilliGramCreatinine [Substance Rate Content Units]"),
    MINUTE("min", "Minute [Time Units]"),
    MOLE("mol", "Mole [Substance Units]"),
    MOLES_PER_CUBICMETER("mol/m3", "MolesPerCubicMeter [Substance Concentration Units]"),
    MOLES_PER_KILOGRAM("mol/kg", "MolesPerKiloGram [Substance Content Units]"),
    MOLES_PER_LITER("mol/L", "MolesPerLiter [Substance Concentration Units]"),
    MOLES_PER_MILLILITER("mol/mL", "MolesPerMilliLiter [Substance Concentration Units]"),
    MONTH("mo", "Month [Time Units]"),
    NANOGRAM("ng", "NanoGram [SI Mass Units]"),
    NANOGRAMS_PER_DECILITER("ng/dL", "NanoGramsPerDeciLiter [Mass Concentration Units]"),
    NANOGRAMS_PER_GRAM("ng/g", "NanoGramsPerGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    NANOGRAMS_PER_GRAM_CREATININE("ng/g{Cre}", "NanoGramsPerGramCreatinine [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    NANOGRAMS_PER_KILOGRAM("ng/kg", "NanoGramsPerKiloGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    NANOGRAMS_PER_LITER("ng/L", "NanoGramsPerLiter [Mass Concentration Units]"),
    NANOGRAMS_PER_MILLIGRAM("ng/mg", "NanoGramsPerMilliGram [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    NANOGRAMS_PER_MILLIGRAM_PROTEIN("ng/mg{Protein}", "NanoGramsPerMilliGramProtein [Mass Ratio Or Mass Fraction Or Mass Content Units]"),
    NANOGRAMS_PER_MILLILITER("ng/mL", "NanoGramsPerMilliLiter [Mass Concentration Units]"),
    NANOGRAMS_PER_MILLILITER_RED_BLOOD_CELLS("ng/mL{rbc}", "NanoGramsPerMilliLiterRedBloodCells [Mass Concentration Units]"),
    NANOGRAMS_PER_SQUARE_METER("ng/m2", "NanoGramsPerSquareMeter [Areic Mass Units]"),
    NANOLITER("nL", "NanoLiter [SI Volume Units]"),
    NANOMETER("nm", "NanoMeter [SI Length Units]"),
    NANOMOLE("nmol", "NanoMole [Substance Units]"),
    NANOMOLES_PER_DECILITER("nmol/dL", "NanoMolesPerDeciLiter [Substance Concentration Units]"),
    NANOMOLES_PER_GRAM("nmol/g", "NanoMolesPerGram [Substance Content Units]"),
    NANOMOLES_PER_GRAM_CREATININE("nmol/g{Cre}", "NanoMolesPerGramCreatinine [Substance Content Units]"),
    NANOMOLES_PER_LITER("nmol/L", "NanoMolesPerLiter [Most Common Healthcare Units]"),
    NANOMOLES_PER_MILLIGRAM("nmol/mg", "NanoMolesPerMilliGram [Substance Content Units]"),
    NANOMOLES_PER_MILLILITER("nmol/mL", "NanoMolesPerMilliLiter [Substance Concentration Units]"),
    NANOMOLES_PER_MILLIMOLE("nmol/mmol", "NanoMolesPerMilliMole [Substance Ratio Or Substance Fraction Units]"),
    NANOMOLES_PER_MILLIMOLE_CREATININE("nmol/mmol{Cre}", "NanoMolesPerMilliMoleCreatinine [Substance Ratio Or Substance Fraction Units]"),
    NANOMOLES_PER_MOLE("nmol/mol", "NanoMolesPerMole [Substance Ratio Or Substance Fraction Units]"),
    NANOSECOND("ns", "NanoSecond [Time Units]"),
    NAUTICAL_MILE("[nmi_i]", "NauticalMile [English Length Units]"),
    ONE_HUNDRED_THOUSAND("10*5", "OneHundredThousand [Unity]"),
    OSMOLES_PER_KILOGRAM("osm/kg", "OsmolesPerKiloGram [Substance Content Units]"),
    OSMOLES_PER_LITER("osm/L", "OsmolesPerLiter [Substance Concentration Units]"),
    OUNCE("[oz_av]", "Ounce [English Mass Units]"),
    PER100("/100", "Per100 [Entitic Number Units]"),
    PER100_SPERMATOZOA("/100{Spermatozoa}", "Per100Spermatozoa [Entitic Number Units]"),
    PER100_WBC("/100{WBC}", "Per100WBC [Entitic Number Units]"),
    PER_ARBITRARY_UNIT("/[arb`U]", "PerArbitraryUnit [Arbitrary Number Units]"),
    PER_BILLION("/10*9", "PerBillion [Number Fraction Units]"),
    PERCENT("%", "Percent [Most Common Healthcare Units]"),
    PERCENT_0_TO_3_HOURS("%{0to3Hours}", "Percent0to3Hours [General Fraction Unit]"),
    PERCENT_ABNORMAL("%{Abnormal}", "PercentAbnormal [Number Fraction Units]"),
    PERCENT_ACTIVITY("%{Activity}", "PercentActivity [Catalytic Fraction Or Arbitrary Fraction Units]"),
    PERCENT_BASAL_ACTIVITY("%{BasalActivity}", "PercentBasalActivity [Catalytic Fraction Or Arbitrary Fraction Units]"),
    PERCENT_BINDING("%{Binding}", "PercentBinding [Mass Or Substance Fraction Units]"),
    PERCENT_BLOCKADE("%{Blockade}", "PercentBlockade [Number Fraction Units]"),
    PERCENT_BOUND("%{Bound}", "PercentBound [Mass Or Substance Fraction Units]"),
    PERCENT_CARBOXY_HEMOGLOBIN("%{Carboxyhemoglobin}", "PercentCarboxyhemoglobin [Mass Or Substance Fraction Units]"),
    PERCENT_EOSINOPHILS_SEEN("%{EosSeen}", "PercentEosinophilsSeen [Number Fraction Units]"),
    PERCENT_EXCRETION("%{Excretion}", "PercentExcretion [Mass Or Substance Rate Fraction Units]"),
    PERCENT_FETAL_ERYTHROCYTES("%{FetalErythrocytes}", "PercentFetalErythrocytes [Number Fraction Units]"),
    PERCENT_HEMOGLOBIN("%{Hemoglobin}", "PercentHemoglobin [Mass Or Substance Fraction Units]"),
    PERCENT_HEMOGLOBIN_A1C("%{HemoglobinA1C}", "PercentHemoglobinA1C [Mass Or Substance Fraction Units]"),
    PERCENT_HEMOGLOBIN_SATURATION("%{HemoglobinSaturation}", "PercentHemoglobinSaturation [Mass Or Substance Fraction Units]"),
    PERCENT_HEMOLYSIS("%{Hemolysis}", "PercentHemolysis [Number Fraction Units]"),
    PERCENT_INHIBITION("%{Inhibition}", "PercentInhibition [Catalytic Fraction Or Arbitrary Fraction Units]"),
    PERCENT_NORMAL("%{Normal}", "PercentNormal [Number Fraction Units]"),
    PERCENT_NORMAL_POOLED_PLASMA("%{NormalPooledPlasma}", "PercentNormalPooledPlasma [Catalytic Fraction Or Arbitrary Fraction Units]"),
    PERCENT_OF_BACTERIA("%{ofBacteria}", "PercentofBacteria [Number Fraction Units]"),
    PERCENT_OF_LYMPHOCYTES("%{OfLymphocytes}", "PercentOfLymphocytes [Number Fraction Units]"),
    PERCENT_OF_WBCS("%{OfWBCs}", "PercentOfWBCs [Number Fraction Units]"),
    PERCENT_OXYGEN("%{Oxygen}", "PercentOxygen [Volume Fraction Units]"),
    PERCENT_PER_100WBC("%/100{WBC}", "PercentPer100WBC [Number Fraction Units]"),
    PERCENT_POSITIVE("%{Positive}", "PercentPositive [Number Fraction Units]"),
    PERCENT_SPERM_MOTILITY("%{SpermMotility}", "PercentSpermMotility [Number Fraction Units]"),
    PERCENT_TOTAL("%{Total}", "PercentTotal [General Fraction Unit]"),
    PERCENT_TOTAL_PROTEIN("%{TotalProtein}", "PercentTotalProtein [Mass Or Substance Fraction Units]"),
    PERCENT_UPTAKE("%{Uptake}", "PercentUptake [Mass Or Substance Rate Fraction Units]"),
    PER_DECILITER("/dL", "PerDeciLiter [Number Concentration Units]"),
    PER_ENTITY("/{Entity}", "PerEntity [Entitic Number Units]"),
    PER_GRAM("/g", "PerGram [Number Content Units]"),
    PER_GRAM_CREATININE("/g{creat}", "PerGramCreatinine [Number Content Units]"),
    PER_GRAM_HEMOGLOBIN("/g{HGB}", "PerGramHemoglobin [Number Content Units]"),
    PER_GRAM_TOTAL_NITROGEN("/g{tot`nit}", "PerGramTotalNitrogen [Number Content Units]"),
    PER_GRAM_TOTAL_PROTEIN("/g{tot`prot}", "PerGramTotalProtein [Number Content Units]"),
    PER_GRAM_WET_TISSUE("/g{wet`tis}", "PerGramWetTissue [Number Content Units]"),
    PER_HOUR("/h", "PerHour [Number Events]"),
    PER_KILOGRAM("/kg", "PerKiloGram [Number Content Units]"),
    PER_KILOGRAM_BODY_WEIGHT("/kg{body`wt}", "PerKiloGramBodyWeight [Number Content Units]"),
    PER_LITER("/L", "PerLiter [Number Concentration Units]"),
    PER_MICROLITER("/uL", "PerMicroLiter [Most Common Healthcare Units]"),
    PER_MILLIGRAM("/mg", "PerMilliGram [Number Content Units]"),
    PER_MILLILITER("/mL", "PerMilliLiter [Number Concentration Units]"),
    PER_MILLION("/10*6", "PerMillion [Number Fraction Units]"),
    PER_MINUTE("/min", "PerMinute [Number Events]"),
    PER_SECOND("/s", "PerSecond [Number Events]"),
    PER_SQUARE_METER("/m2", "PerSquareMeter [Areic Number Units]"),
    PER_TEN_GIGA("/10*10", "PerTenGiga [Number Fraction Units]"),
    PER_TOTAL_COUNT("/{tot}", "PerTotalCount [Unity]"),
    PER_TRILLION("/10*12", "PerTrillion [Number Fraction Units]"),
    PER_TRILLION_RED_BLOOD_CELLS("/10*12{rbc}", "PerTrillionRedBloodCells [Entitic Number Units]"),
    PH("[pH]", "pH [pH Units]"),
    PICOGRAM("pg", "PicoGram [SI Mass Units]"),
    PICOGRAMS("pg", "PicoGrams [Most Common Healthcare Units]"),
    PICOGRAMS_PER_DECILITER("pg/dL", "PicoGramsPerDeciLiter [Mass Concentration Units]"),
    PICOGRAMS_PER_LITER("pg/L", "PicoGramsPerLiter [Mass Concentration Units]"),
    PICOGRAMS_PER_MILLILITER("pg/mL", "PicoGramsPerMilliLiter [Most Common Healthcare Units]"),
    PICOGRAMS_PER_MILLIMETER("pg/mm", "PicoGramsPerMilliMeter [Lineic Mass Units]"),
    PICOLITER("pL", "PicoLiter [SI Volume Units]"),
    PICOMETER("pm", "PicoMeter [SI Length Units]"),
    PICOMOLE("pmol", "PicoMole [Substance Units]"),
    PICOMOLES_PER_DECILITER("pmol/dL", "PicoMolesPerDeciLiter [Substance Concentration Units]"),
    PICOMOLES_PER_LITER("pmol/L", "PicoMolesPerLiter [Substance Concentration Units]"),
    PICOMOLES_PER_MICROMOLE("pmol/umol", "PicoMolesPerMicroMole [Substance Ratio Or Substance Fraction Units]"),
    PICOMOLES_PER_MILLILITER("pmol/mL", "PicoMolesPerMilliLiter [Substance Concentration Units]"),
    PICOSECOND("ps", "PicoSecond [Time Units]"),
    PINT("[pt_us]", "Pint [English Volume Units]"),
    POUND("[lb_av]", "Pound [English Mass Units]"),
    QUART("[qt_us]", "Quart [English Volume Units]"),
    RED_BLOOD_CELLS_PER_MICROLITER("{rbc}/uL", "RedBloodCellsPerMicroLiter [Number Concentration Units]"),
    RELATIVE_PERCENT("{Relative}%", "RelativePercent [General Fraction Unit]"),
    SECOND("s", "Second [Time Units]"),
    SPERMATOZOA_PER_MILLILITER("{Spermatozoa}/mL", "SpermatozoaPerMilliLiter [Number Concentration Units]"),
    SQUARE_CENTIMETER("cm2", "SquareCentiMeter [SI Area Units]"),
    SQUARE_FEET("[sft_i]", "SquareFeet [English Area Units]"),
    SQUARE_INCH("[sin_i]", "SquareInch [English Area Units]"),
    SQUARE_METER("m2", "SquareMeter [SI Area Units]"),
    SQUARE_MILLIMETER("mm2", "SquareMilliMeter [SI Area Units]"),
    SQUARE_YARD("[syd_i]", "SquareYard [English Area Units]"),
    STATUTEMILE("[mi_i]", "StatuteMile [English Length Units]"),
    TEN_TO_EIGHTH("10*8", "TenToEighth [Unity]"),
    THOUSAND("10*3", "Thousand [Unity]"),
    THOUSAND_COPIES_PER_MILLILITER("10*3{Copies}/mL", "ThousandCopiesPerMilliLiter [Number Concentration Units]"),
    THOUSAND_PER_LITER("10*3/L", "ThousandPerLiter [Number Concentration Units]"),
    THOUSAND_PER_MILLILITER("10*3/mL", "ThousandPerMilliLiter [Number Concentration Units]"),
    THOUSAND_PER_RED_BLOOD_CELLS("10*3.{RBC}", "ThousandRedBloodCells [Unity]"),
    THOUSANDS_PER_MICROLITER("10*3/uL", "ThousandsPerMicroLiter [Number Concentration Units]"),
    TON("[ston_av]", "Ton [English Mass Units]"),
    TRILLION_PER_LITER("10*12/L", "TrillionPerLiter [Number Concentration Units]"),
    TROY_OUNCE("[oz_tr]", "TroyOunce [English Mass Units]"),
    UNITS_PER_GRAM("U/g", "UnitsPerGram [Substance Rate Content Units]"),
    UNITS_PER_GRAM_CREATININE("U/g{Cre}", "UnitsPerGramCreatinine [Substance Rate Content Units]"),
    UNITS_PER_GRAM_HEMOGLOBIN("U/g{Hgb}", "UnitsPerGramHemoglobin [Substance Rate Content Units]"),
    UNITS_PER_LITER("U/L", "UnitsPerLiter [Most Common Healthcare Units]"),
    VOLUME_PERCENT("%{vol}", "VolumePercent [Volume Fraction Units]"),
    WEEK("wk", "Week [Time Units]"),
    YARD("[yd_i]", "Yard [English Length Units]"),
    YEAR("a", "Year [Time Units]");

    public static final String AHG_EQUIVALENTS_PER_MILLILITER_CODE = "{AHG}eq/mL";
    public static final String BILLION_PER_LITER_CODE = "10*9/L";
    public static final String BILLIONS_PER_MICROLITER_CODE = "10*9/uL";
    public static final String BILLIONS_PER_MILLILITER_CODE = "10*9/mL";
    public static final String BONE_COLLAGEN_EQUIVALENTS_PER_MICROMOLE_CREATININE_CODE = "{BoneCollagen}eq/umol{Cre}";
    public static final String BONE_COLLAGEN_EQUIVALENTS_PER_MILLIOMOLE_CREATININE_CODE = "{BoneCollagen}eq/mmol{Cre}";
    public static final String CELLS_PER_MICROLITER_CODE = "{Cells}/uL";
    public static final String CENTIGRAM_CODE = "cg";
    public static final String CENTILITER_CODE = "cL";
    public static final String CENTIMETER_CODE = "cm";
    public static final String CODE_SYSTEM_NAME = "";
    public static final String CODE_SYSTEM_OID = "";
    public static final String COLONY_FORMING_UNITS_PER_MILLILITER_CODE = "{cfu}/mL";
    public static final String COMPLEMENT_CH50_UNITS_PER_MILLILITER_CODE = "{ComplementCh50}U/mL";
    public static final String COPIES_PER_MILLILITER_CODE = "{Copies}/mL";
    public static final String CUBIC_INCH_CODE = "[cin_i]";
    public static final String CUP_CODE = "[cup_us]";
    public static final String DAY_CODE = "d";
    public static final String DECIGRAM_CODE = "dg";
    public static final String DECILITER_CODE = "dL";
    public static final String DECIMETER_CODE = "dm";
    public static final String DEGREES_CELSIUS_CODE = "Cel";
    public static final String DEGREES_FAHRENHEIT_CODE = "[degF]";
    public static final String DEGREES_KELVIN_CODE = "K";
    public static final String DEGREES_OF_ARC_CODE = "deg";
    public static final String DESCRIPTIVE_CODE = "Code";
    public static final String DRAM_CODE = "[dr_av]";
    public static final String EHRLICH_UNITS_PER_100_GRAM_CODE = "{Ehrlich_U}/100g";
    public static final String EHRLICH_UNITS_PER_DECILITER_CODE = "{Ehrlich_U}/dL";
    public static final String ELISA_UNITY_PER_MILLILITER_CODE = "{Elisa_U}/mL";
    public static final String EQUIVALENT_CODE = "eq";
    public static final String EQUIVALENTS_PER_LITER_CODE = "eq/L";
    public static final String EQUIVALENTS_PER_MICROMOLE_CODE = "eq/umol";
    public static final String EQUIVALENTS_PER_MILLILITER_CODE = "eq/mL";
    public static final String EQUIVALENTS_PER_MILLIMOLE_CODE = "eq/mmol";
    public static final String FATHOM_CODE = "[fth_i]";
    public static final String FEET_CODE = "[ft_i]";
    public static final String FEMTOGRAM_CODE = "fg";
    public static final String FEMTOLITER_CODE = "fL";
    public static final String FEMTOMETER_CODE = "fm";
    public static final String FEMTOMOLE_CODE = "fmol";
    public static final String FEMTOMOLES_PER_GRAM_CODE = "fmol/g";
    public static final String FEMTOMOLES_PER_MILLIGRAM_CODE = "fmol/mg";
    public static final String FEMTOMOLES_PER_MILLILITER_CODE = "fmol/mL";
    public static final String FLUID_DRAM_CODE = "[fdr_us]";
    public static final String FLUID_OUNCE_CODE = "[foz_us]";
    public static final String FRENCH_CODE = "[Ch]";
    public static final String GALLON_CODE = "[gal_us]";
    public static final String GRAIN_CODE = "[gr]";
    public static final String GRAM_CODE = "g";
    public static final String GRAM_METER_CODE = "g.m";
    public static final String GRAM_METER_PER_HEARTBEAT_CODE = "g.m/{hb}";
    public static final String GRAM_METER_PER_HEARTBEAT_PER_SQUARE_METER_CODE = "g.m/({hb}.m2)";
    public static final String GRAMS_PER_100_GRAM_CODE = "g/[100]g";
    public static final String GRAMS_PER_DECILITER_CODE = "g/dL";
    public static final String GRAMS_PER_GRAM_CODE = "g/g";
    public static final String GRAMS_PER_GRAM_CREATININE_CODE = "g/g{Cre}";
    public static final String GRAMS_PER_KILOGRAM_CODE = "g/kg";
    public static final String GRAMS_PER_LITER_CODE = "g/L";
    public static final String GRAMS_PER_MILLILITER_CODE = "g/mL";
    public static final String GRAMS_PER_SQUARE_METER_CODE = "g/m2";
    public static final String GRAMS_PER_TOTAL_WEIGHT_CODE = "g/{TotalWeight}";
    public static final String HECTOLITER_CODE = "hL";
    public static final String HOUR_CODE = "h";
    public static final String IGA_PHOSPHOLIPID_UNITS_PER_MILLILITER_CODE = "{IgAPhospholipid}U/mL";
    public static final String IGG_PHOSPHOLIPID_UNITS_PER_MILLILITER_CODE = "{IgGPhospholipid}U/mL";
    public static final String IGM_PHOSPHOLIPID_UNITS_PER_MILLILITER_CODE = "{IgMPhospholipid}U/mL";
    public static final String INCH_CODE = "[in_i]";
    public static final String INTERNATIONAL_UNIT_CODE = "[iU]";
    public static final String INTERNATIONAL_UNITS_PER_DECILITER_CODE = "[iU]/dL";
    public static final String INTERNATIONAL_UNITS_PER_GRAM_CODE = "[iU]/g";
    public static final String INTERNATIONAL_UNITS_PER_GRAM_HEMOGLOBIN_CODE = "[iU]/g{Hgb}";
    public static final String INTERNATIONAL_UNITS_PER_KILOGRAM_CODE = "[iU]/kg";
    public static final String INTERNATIONAL_UNITS_PER_LITER_CODE = "[iU]/L";
    public static final String INTERNATIONAL_UNITS_PER_MILLILITER_CODE = "[iU]/mL";
    public static final String KATAL_PER_KILOGRAM_CODE = "kat/kg";
    public static final String KELVIN_PER_WATT_CODE = "K/W";
    public static final String KILO_CALORIES_PER_OUNCE_CODE = "kCal/[oz_av]";
    public static final String KILOGRAM_CODE = "kg";
    public static final String KILOGRAMS_PER_CUBICMETER_CODE = "kg/m3";
    public static final String KILOGRAMS_PER_LITER_CODE = "kg/L";
    public static final String KILOGRAMS_PER_MOLE_CODE = "kg/mol";
    public static final String KILOGRAMS_PER_SQUAREMETER_CODE = "kg/m2";
    public static final String KILO_INTERNATIONAL_UNITS_PER_MILLILITER_CODE = "k[iU]/mL";
    public static final String KILOLITER_CODE = "kL";
    public static final String KILOMETER_CODE = "km";
    public static final String KILOPASCAL_CODE = "kPa";
    public static final String KILOSECOND_CODE = "ks";
    public static final String KILO_UNITS_PER_GRAM_CODE = "kU/g";
    public static final String LITER_CODE = "L";
    public static final String LITERS_PER_KILOGRAM_CODE = "L/kg";
    public static final String LITER_SQUARE_SECOND_PER_SECOND_CODE = "L.s2/s";
    public static final String LOG10_CODE = "[lg]";
    public static final String MEGASECOND_CODE = "Ms";
    public static final String METER_CODE = "m";
    public static final String METRIC_TON_CODE = "t";
    public static final String MICRO_EQUIVALENT_CODE = "ueq";
    public static final String MICRO_EQUIVALENTS_PER_LITER_CODE = "ueq/L";
    public static final String MICRO_EQUIVALENTS_PER_MILLILITER_CODE = "ueq/mL";
    public static final String MICROGRAM_CODE = "ug";
    public static final String MICROGRAM_PER_100_GRAM_CODE = "ug/[100]g";
    public static final String MICROGRAM_PER_GRAM_CREATININE_CODE = "ug/g{Cre}";
    public static final String MICROGRAM_PER_GRAM_DRY_WEIGHT_CODE = "ug/g{DryWeight}";
    public static final String MICROGRAMS_PER_DECILITER_CODE = "ug/dL";
    public static final String MICROGRAMS_PER_DECILITER_RED_BLOOD_CELLS_CODE = "ug/dL{rbc}";
    public static final String MICROGRAMS_PER_GRAM_CODE = "ug/g";
    public static final String MICROGRAMS_PER_GRAM_HEMOGLOBIN_CODE = "ug/g{Hgb}";
    public static final String MICROGRAMS_PER_KILOGRAM_CODE = "ug/kg";
    public static final String MICROGRAMS_PER_LITER_CODE = "ug/L";
    public static final String MICROGRAMS_PER_MILLIGRAM_CODE = "ug/mg";
    public static final String MICROGRAMS_PER_MILLIGRAM_CREATININE_CODE = "ug/mg{Cre}";
    public static final String MICROGRAMS_PER_MILLILITER_CODE = "ug/mL";
    public static final String MICROGRAMS_PER_NANOGRAM_CODE = "ug/ng";
    public static final String MICROGRAMS_PER_SPECIMEN_CODE = "ug/{Specimen}";
    public static final String MICROGRAMS_PER_SQUAREMETER_CODE = "ug/m2";
    public static final String MICROGRAMS_PER_TOTAL_VOLUME_CODE = "ug/{TotalVolume}";
    public static final String MICRO_INTERNATIONAL_UNIT_CODE = "u[iU]";
    public static final String MICRO_INTERNATIONAL_UNITS_PER_MILLILITER_CODE = "u[iU]/mL";
    public static final String MICROLITER_CODE = "uL";
    public static final String MICROMETER_CODE = "um";
    public static final String MICROMOLE_CODE = "umol";
    public static final String MICROMOLES_PER_DECILITER_CODE = "umol/dL";
    public static final String MICROMOLES_PER_GRAM_CODE = "umol/g";
    public static final String MICROMOLES_PER_GRAM_CREATININE_CODE = "umol/g{Cre}";
    public static final String MICROMOLES_PER_GRAM_HEMOGLOBIN_CODE = "umol/g{Hgb}";
    public static final String MICROMOLES_PER_LITER_CODE = "umol/L";
    public static final String MICROMOLES_PER_MILLIGRAM_CODE = "umol/mg";
    public static final String MICROMOLES_PER_MILLIGRAM_CREATININE_CODE = "umol/mg{Cre}";
    public static final String MICROMOLES_PER_MILLILITER_CODE = "umol/mL";
    public static final String MICROMOLES_PER_MINUTE_PER_GRAM_CODE = "umol/min/g";
    public static final String MICROMOLES_PER_MOLE_CODE = "umol/mol";
    public static final String MICROMOLES_PER_MOLE_CREATININE_CODE = "umol/mol{Cre}";
    public static final String MICROSECOND_CODE = "us";
    public static final String MILLI_EQUIVALENT_CODE = "meq";
    public static final String MILLI_EQUIVALENT_PER_MILLILITER_CODE = "meq/mL";
    public static final String MILLI_EQUIVALENTS_PER_DECILITER_CODE = "meq/dL";
    public static final String MILLI_EQUIVALENTS_PER_GRAM_CODE = "meq/g";
    public static final String MILLI_EQUIVALENTS_PER_GRAM_CREATININE_CODE = "meq/g{Cre}";
    public static final String MILLI_EQUIVALENTS_PER_KILOGRAM_CODE = "meq/kg";
    public static final String MILLI_EQUIVALENTS_PER_LITER_CODE = "meq/L";
    public static final String MILLI_EQUIVALENTS_PER_SPECIMEN_CODE = "meq/{Specimen}";
    public static final String MILLI_EQUIVALENTS_PER_SQUAREMETER_CODE = "meq/m2";
    public static final String MILLIGRAM_CODE = "mg";
    public static final String MILLIGRAM_PER_GRAM_CREATININE_CODE = "mg/g{Cre}";
    public static final String MILLIGRAM_PER_TOTAL_VOLUME_CODE = "mg/{TotalVolume}";
    public static final String MILLIGRAMS_PER_DECILITER_CODE = "mg/dL";
    public static final String MILLIGRAMS_PER_GRAM_CODE = "mg/g";
    public static final String MILLIGRAMS_PER_KILOGRAM_CODE = "mg/kg";
    public static final String MILLIGRAMS_PER_LITER_CODE = "mg/L";
    public static final String MILLIGRAMS_PER_MILLIGRAM_CODE = "mg/mg";
    public static final String MILLIGRAMS_PER_MILLIGRAM_CREATININE_CODE = "mg/mg{Cre}";
    public static final String MILLIGRAMS_PER_MILLILITER_CODE = "mg/mL";
    public static final String MILLIGRAMS_PER_SQUAREMETER_CODE = "mg/m2";
    public static final String MILLIGRAMS_PER_VOLUME_CODE = "mg/{Volume}";
    public static final String MILLIGRAMS_PHENYLKETONES_PER_DECILITER_CODE = "mg{Phenylketones}/dL";
    public static final String MILLI_INTERNATIONAL_UNITS_PER_LITER_CODE = "m[iU]/L";
    public static final String MILLI_INTERNATIONAL_UNITS_PER_MILLILITER_CODE = "m[iU]/mL";
    public static final String MILLILITER_CODE = "mL";
    public static final String MILLILITERS_PER_DECILITER_CODE = "mL/dL";
    public static final String MILLILITERS_PER_HEARTBEAT_CODE = "mL/{h`b}";
    public static final String MILLILITERS_PER_KILOGRAM_CODE = "mL/kg";
    public static final String MILLIMETER_CODE = "mm";
    public static final String MILLIMETERS_OF_MERCURY_CODE = "mm[Hg]";
    public static final String MILLIMOLE_CODE = "mmol";
    public static final String MILLIMOLES_PER_DECILITER_CODE = "mmol/dL";
    public static final String MILLIMOLES_PER_GRAM_CODE = "mmol/g";
    public static final String MILLIMOLES_PER_KILOGRAM_CODE = "mmol/kg";
    public static final String MILLIMOLES_PER_LITER_CODE = "mmol/L";
    public static final String MILLIMOLES_PER_MOLE_CODE = "mmol/mol";
    public static final String MILLIMOLES_PER_MOLE_CREATININE_CODE = "mmol/mol{Cre}";
    public static final String MILLIMOLES_PER_SQUAREMETER_CODE = "mmol/m2";
    public static final String MILLIMOLES_PER_TOTAL_VOLUME_CODE = "mmol/{TotalVolume}";
    public static final String MILLION_CODE = "10*6";
    public static final String MILLION_EQUIVALENTS_PER_MILLILITER_CODE = "10*6.eq/mL";
    public static final String MILLION_INTERNATIONAL_UNIT_CODE = "10*6.[iU]";
    public static final String MILLION_PER_LITER_CODE = "10*6/L";
    public static final String MILLION_PER_MILLILITER_CODE = "10*6/mL";
    public static final String MILLION_PER_SPECIMEN_CODE = "10*6/{Specimen}";
    public static final String MILLIONS_PER_MICROLITER_CODE = "10*6/uL";
    public static final String MILLIOSMOLE_CODE = "mosm";
    public static final String MILLIOSMOLES_PER_KILOGRAM_CODE = "mosm/kg";
    public static final String MILLIOSMOLES_PER_LITER_CODE = "mosm/L";
    public static final String MILLISECOND_CODE = "ms";
    public static final String MILLI_UNITS_PER_GRAM_CODE = "mU/g";
    public static final String MILLI_UNITS_PER_GRAM_HEMOGLOBIN_CODE = "mU/g{Hgb}";
    public static final String MILLI_UNITS_PER_MILLIGRAM_CODE = "mU/mg";
    public static final String MILLI_UNITS_PER_MILLIGRAM_CREATININE_CODE = "mU/mg{Cre}";
    public static final String MINUTE_CODE = "min";
    public static final String MOLE_CODE = "mol";
    public static final String MOLES_PER_CUBICMETER_CODE = "mol/m3";
    public static final String MOLES_PER_KILOGRAM_CODE = "mol/kg";
    public static final String MOLES_PER_LITER_CODE = "mol/L";
    public static final String MOLES_PER_MILLILITER_CODE = "mol/mL";
    public static final String MONTH_CODE = "mo";
    public static final String NANOGRAM_CODE = "ng";
    public static final String NANOGRAMS_PER_DECILITER_CODE = "ng/dL";
    public static final String NANOGRAMS_PER_GRAM_CODE = "ng/g";
    public static final String NANOGRAMS_PER_GRAM_CREATININE_CODE = "ng/g{Cre}";
    public static final String NANOGRAMS_PER_KILOGRAM_CODE = "ng/kg";
    public static final String NANOGRAMS_PER_LITER_CODE = "ng/L";
    public static final String NANOGRAMS_PER_MILLIGRAM_CODE = "ng/mg";
    public static final String NANOGRAMS_PER_MILLIGRAM_PROTEIN_CODE = "ng/mg{Protein}";
    public static final String NANOGRAMS_PER_MILLILITER_CODE = "ng/mL";
    public static final String NANOGRAMS_PER_MILLILITER_RED_BLOOD_CELLS_CODE = "ng/mL{rbc}";
    public static final String NANOGRAMS_PER_SQUAREMETER_CODE = "ng/m2";
    public static final String NANOLITER_CODE = "nL";
    public static final String NANOMETER_CODE = "nm";
    public static final String NANOMOLE_CODE = "nmol";
    public static final String NANOMOLES_PER_DECILITER_CODE = "nmol/dL";
    public static final String NANOMOLES_PER_GRAM_CODE = "nmol/g";
    public static final String NANOMOLES_PER_GRAM_CREATININE_CODE = "nmol/g{Cre}";
    public static final String NANOMOLES_PER_LITER_CODE = "nmol/L";
    public static final String NANOMOLES_PER_MILLIGRAM_CODE = "nmol/mg";
    public static final String NANOMOLES_PER_MILLILITER_CODE = "nmol/mL";
    public static final String NANOMOLES_PER_MILLIMOLE_CODE = "nmol/mmol";
    public static final String NANOMOLES_PER_MILLIMOLE_CREATININE_CODE = "nmol/mmol{Cre}";
    public static final String NANOMOLES_PER_MOLE_CODE = "nmol/mol";
    public static final String NANOSECOND_CODE = "ns";
    public static final String NAUTICAL_MILE_CODE = "[nmi_i]";
    public static final String ONE_HUNDRED_THOUSAND_CODE = "10*5";
    public static final String OSMOLES_PER_KILOGRAM_CODE = "osm/kg";
    public static final String OSMOLES_PER_LITER_CODE = "osm/L";
    public static final String OUNCE_CODE = "[oz_av]";
    public static final String PER_100_CODE = "/100";
    public static final String PER_100_SPERMATOZOA_CODE = "/100{Spermatozoa}";
    public static final String PER_100_WBC_CODE = "/100{WBC}";
    public static final String PER_ARBITRARY_UNIT_CODE = "/[arb`U]";
    public static final String PER_BILLION_CODE = "/10*9";
    public static final String PERCENT_CODE = "%";
    public static final String PERCENT_0_TO_3_HOURS_CODE = "%{0to3Hours}";
    public static final String PERCENT_ABNORMAL_CODE = "%{Abnormal}";
    public static final String PERCENT_ACTIVITY_CODE = "%{Activity}";
    public static final String PERCENT_BASAL_ACTIVITY_CODE = "%{BasalActivity}";
    public static final String PERCENT_BINDING_CODE = "%{Binding}";
    public static final String PERCENT_BLOCKADE_CODE = "%{Blockade}";
    public static final String PERCENT_BOUND_CODE = "%{Bound}";
    public static final String PERCENT_CARBOXY_HEMOGLOBIN_CODE = "%{Carboxyhemoglobin}";
    public static final String PERCENT_EOSINOPHILS_SEEN_CODE = "%{EosSeen}";
    public static final String PERCENT_EXCRETION_CODE = "%{Excretion}";
    public static final String PERCENT_FETAL_ERYTHROCYTES_CODE = "%{FetalErythrocytes}";
    public static final String PERCENT_HEMOGLOBIN_CODE = "%{Hemoglobin}";
    public static final String PERCENT_HEMOGLOBIN_A1C_CODE = "%{HemoglobinA1C}";
    public static final String PERCENT_HEMOGLOBIN_SATURATION_CODE = "%{HemoglobinSaturation}";
    public static final String PERCENT_HEMOLYSIS_CODE = "%{Hemolysis}";
    public static final String PERCENT_INHIBITION_CODE = "%{Inhibition}";
    public static final String PERCENT_NORMAL_CODE = "%{Normal}";
    public static final String PERCENT_NORMAL_POOLED_PLASMA_CODE = "%{NormalPooledPlasma}";
    public static final String PERCENT_OF_BACTERIA_CODE = "%{ofBacteria}";
    public static final String PERCENT_OF_LYMPHOCYTES_CODE = "%{OfLymphocytes}";
    public static final String PERCENT_OF_WBCS_CODE = "%{OfWBCs}";
    public static final String PERCENT_OXYGEN_CODE = "%{Oxygen}";
    public static final String PERCENT_PER_100_WBC_CODE = "%/100{WBC}";
    public static final String PERCENT_POSITIVE_CODE = "%{Positive}";
    public static final String PERCENT_SPERM_MOTILITY_CODE = "%{SpermMotility}";
    public static final String PERCENT_TOTAL_CODE = "%{Total}";
    public static final String PERCENT_TOTAL_PROTEIN_CODE = "%{TotalProtein}";
    public static final String PERCENT_UPTAKE_CODE = "%{Uptake}";
    public static final String PER_DECILITER_CODE = "/dL";
    public static final String PER_ENTITY_CODE = "/{Entity}";
    public static final String PER_GRAM_CODE = "/g";
    public static final String PER_GRAM_CREATININE_CODE = "/g{creat}";
    public static final String PER_GRAM_HEMOGLOBIN_CODE = "/g{HGB}";
    public static final String PER_GRAM_TOTAL_NITROGEN_CODE = "/g{tot`nit}";
    public static final String PER_GRAM_TOTAL_PROTEIN_CODE = "/g{tot`prot}";
    public static final String PER_GRAM_WET_TISSUE_CODE = "/g{wet`tis}";
    public static final String PER_HOUR_CODE = "/h";
    public static final String PER_KILOGRAM_CODE = "/kg";
    public static final String PER_KILOGRAM_BODY_WEIGHT_CODE = "/kg{body`wt}";
    public static final String PER_LITER_CODE = "/L";
    public static final String PER_MICROLITER_CODE = "/uL";
    public static final String PER_MILLIGRAM_CODE = "/mg";
    public static final String PER_MILLILITER_CODE = "/mL";
    public static final String PER_MILLION_CODE = "/10*6";
    public static final String PER_MINUTE_CODE = "/min";
    public static final String PER_SECOND_CODE = "/s";
    public static final String PER_SQUAREMETER_CODE = "/m2";
    public static final String PER_TEN_GIGA_CODE = "/10*10";
    public static final String PER_TOTAL_COUNT_CODE = "/{tot}";
    public static final String PER_TRILLION_CODE = "/10*12";
    public static final String PER_TRILLION_RED_BLOOD_CELLS_CODE = "/10*12{rbc}";
    public static final String PH_CODE = "[pH]";
    public static final String PICOGRAM_CODE = "pg";
    public static final String PICOGRAMS_CODE = "pg";
    public static final String PICOGRAMS_PER_DECILITER_CODE = "pg/dL";
    public static final String PICOGRAMS_PER_LITER_CODE = "pg/L";
    public static final String PICOGRAMS_PER_MILLILITER_CODE = "pg/mL";
    public static final String PICOGRAMS_PER_MILLIMETER_CODE = "pg/mm";
    public static final String PICOLITER_CODE = "pL";
    public static final String PICOMETER_CODE = "pm";
    public static final String PICOMOLE_CODE = "pmol";
    public static final String PICOMOLES_PER_DECILITER_CODE = "pmol/dL";
    public static final String PICOMOLES_PER_LITER_CODE = "pmol/L";
    public static final String PICOMOLES_PER_MICROMOLE_CODE = "pmol/umol";
    public static final String PICOMOLES_PER_MILLILITER_CODE = "pmol/mL";
    public static final String PICOSECOND_CODE = "ps";
    public static final String PINT_CODE = "[pt_us]";
    public static final String POUND_CODE = "[lb_av]";
    public static final String QUART_CODE = "[qt_us]";
    public static final String RED_BLOOD_CELLS_PER_MICROLITER_CODE = "{rbc}/uL";
    public static final String RELATIVE_PERCENT_CODE = "{Relative}%";
    public static final String SECOND_CODE = "s";
    public static final String SPERMATOZOA_PER_MILLILITER_CODE = "{Spermatozoa}/mL";
    public static final String SQUARE_CENTIMETER_CODE = "cm2";
    public static final String SQUAREFEET_CODE = "[sft_i]";
    public static final String SQUAREINCH_CODE = "[sin_i]";
    public static final String SQUAREMETER_CODE = "m2";
    public static final String SQUAREMILLIMETER_CODE = "mm2";
    public static final String SQUAREYARD_CODE = "[syd_i]";
    public static final String STATUS_MILE_CODE = "[mi_i]";
    public static final String TEN_TO_EIGHTH_CODE = "10*8";
    public static final String THOUSAND_CODE = "10*3";
    public static final String THOUSAND_COPIES_PER_MILLILITER_CODE = "10*3{Copies}/mL";
    public static final String THOUSAND_PER_LITER_CODE = "10*3/L";
    public static final String THOUSAND_PER_MILLILITER_CODE = "10*3/mL";
    public static final String THOUSAND_RED_BLOOD_CELLS_CODE = "10*3.{RBC}";
    public static final String THOUSANDS_PER_MICROLITER_CODE = "10*3/uL";
    public static final String TON_CODE = "[ston_av]";
    public static final String TRILLION_PER_LITER_CODE = "10*12/L";
    public static final String TROY_OUNCE_CODE = "[oz_tr]";
    public static final String UNITS_PER_GRAM_CODE = "U/g";
    public static final String UNITS_PER_GRAM_CREATININE_CODE = "U/g{Cre}";
    public static final String UNITS_PER_GRAM_HEMOGLOBIN_CODE = "U/g{Hgb}";
    public static final String UNITS_PER_LITER_CODE = "U/L";
    public static final String VOLUME_PERCENT_CODE = "%{vol}";
    public static final String WEEK_CODE = "wk";
    public static final String YARD_CODE = "[yd_i]";
    public static final String YEAR_CODE = "a";
    private String code;
    private String displayName;

    public static Ucum getEnum(String code) {
        for (Ucum x : Ucum.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(Ucum.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (Ucum x : Ucum.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private Ucum(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public CD getCD() {
        CD cd = new CD();
        cd.setCodeSystem("");
        cd.setCode(this.code);
        cd.setDisplayName(this.displayName);
        return cd;
    }

    public Code getCode() {
        return new Code(this.code, "", this.displayName);
    }

    public String getCodeSystemName() {
        return "";
    }

    public String getCodeSystemOid() {
        return "";
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

