/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.model.Code;

public enum StatusCode {
    ABORTED("aborted", "aborted"),
    ACTIVE("active", "active"),
    CANCELLED("cancelled", "cancelled"),
    COMPLETED("completed", "completed"),
    HELD("held", "held"),
    NEW("new", "new"),
    SUSPENDED("suspended", "suspended");

    public static final String ABORTED_CODE = "aborted";
    public static final String ACTIVE_CODE = "active";
    public static final String CANCELLED_CODE = "cancelled";
    public static final String CODE_SYSTEM_NAME = "ActStatus";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.5.14";
    public static final String COMPLETED_CODE = "completed";
    public static final String HELD_CODE = "held";
    public static final String NEW_CODE = "new";
    public static final String SUSPENDED_CODE = "suspended";
    private String code;
    private String displayName;

    public static StatusCode getEnum(String code) {
        for (StatusCode x : StatusCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(StatusCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (StatusCode x : StatusCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private StatusCode(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public Code getCode() {
        return new Code(this.code, CODE_SYSTEM_OID, this.displayName);
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public CS getCS() {
        CS cs = new CS();
        cs.setCode(this.code);
        return cs;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

