/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.model.Code;

public enum Signature {
    INTENDED("I", "intended"),
    REQUIRED("X", "required"),
    SIGNED("S", "signed");

    public static final String CODE_SYSTEM_NAME = "ParticipationSignature";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.5.89";
    public static final String INTENDED_CODE = "I";
    public static final String REQUIRED_CODE = "X";
    public static final String SIGNED_CODE = "S";
    private String code;
    private String displayName;

    public static Signature getEnum(String code) {
        for (Signature x : Signature.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(Signature.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (Signature x : Signature.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private Signature(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public Code getCode() {
        return new Code(this.code, CODE_SYSTEM_OID, this.displayName);
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public CS getCS() {
        CS cs = new CS();
        cs.setCode(this.code);
        return cs;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

