/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.model.Code;

public enum Severity {
    HIGH_SEVERITY("H", "high severity"),
    LOW_SEVERITY("L", "low severity"),
    MODERATE_SEVERITY("M", "moderate severity");

    public static final String CODE_SYSTEM_NAME = "HL7SeverityObservation";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.5.1063";
    public static final String HIGH_SEVERITY_CODE = "H";
    public static final String LOW_SEVERITY_CODE = "L";
    public static final String MODERATE_SEVERITY_CODE = "M";
    private String code;
    private String displayName;

    public static Severity getEnum(String code) {
        for (Severity x : Severity.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(Severity.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (Severity x : Severity.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private Severity(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public CD getCD() {
        CD cd = new CD();
        cd.setCodeSystem(CODE_SYSTEM_OID);
        cd.setCode(this.code);
        cd.setDisplayName(this.displayName);
        return cd;
    }

    public Code getCode() {
        return new Code(this.code, CODE_SYSTEM_OID, this.displayName);
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

